<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;

class OdeApi_Particulier extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $params = json_decode( base64_decode($champ['params']),true);

        $avisImpot = explode(',', $params['avis_impot']);
        $label_avis_impot = array();

        foreach ($avisImpot as $impot) {
            $label_avis_impot[$impot] = $app_list_strings[$params['liste_avis_impot']][$impot];
        }

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("type", "api_particulier");
        $smarty->assign("avis", $params['avis_impot']);
        $smarty->assign("avis_impot_condition", $params['avis_impot_condition']);
        $smarty->assign("name", $name);
        $smarty->assign("required", "");
        $smarty->assign("disabled", $disabled);
        $smarty->assign("aria", $champ["libelle"]);

        if(isset($value["value"]))
        {
            $smarty->assign("value", $value["value"]);
        }
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("name_numero_fiscal", "name_numero_fiscal");
        $smarty->assign("name_referece_fiscal", "name_referece_fiscal");
        $smarty->assign("name_avis_impot", "name_avis_impot");
        $smarty->assign("label_avis_impot", $label_avis_impot);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        if(isset($value["numero_fiscal"]))
        {
            $smarty->assign("value_numero_fiscal", $value["numero_fiscal"]);
        }

        if(isset($value["referece_fiscal"]))
        {
            $smarty->assign("value_referece_fiscal", $value["referece_fiscal"]);
        }

        if(isset($value["avis_impot"]))
        {
            $smarty->assign("value_avis_impot", $value["avis_impot"]);
        }

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_particulier_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_particulier.tpl");
        }


        return $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"]);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $params = json_decode( base64_decode($champ['params']),true);

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $data_required = ( $required != '' ) ? ' data-required="true" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $avisImpot = explode(',', $params['avis_impot']);
        $label_avis_impot = array();

        foreach ($avisImpot as $impot) {
            $label_avis_impot[$impot] = $app_list_strings[$params['liste_avis_impot']][$impot];
        }

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("type", "api_particulier");
        $smarty->assign("avis", $params['avis_impot']);
        $smarty->assign("avis_impot_condition", $params['avis_impot_condition']);
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("data_required", $data_required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("aria", $champ["libelle"]);

        if(isset($value["value"]))
        {
            $smarty->assign("value", $value["value"]);
        }
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("name_numero_fiscal", "name_numero_fiscal");
        $smarty->assign("name_referece_fiscal", "name_referece_fiscal");
        $smarty->assign("name_avis_impot", "name_avis_impot");
        $smarty->assign("label_avis_impot", $label_avis_impot);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        if(isset($value["numero_fiscal"]))
        {
            $smarty->assign("value_numero_fiscal", $value["numero_fiscal"]);
        }

        if(isset($value["referece_fiscal"]))
        {
            $smarty->assign("value_referece_fiscal", $value["referece_fiscal"]);
        }

        if(isset($value["avis_impot"]))
        {
            $smarty->assign("value_avis_impot", $value["avis_impot"]);
        }

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_particulier_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_particulier.tpl");
        }

        return $field_html;
    }

    public function getFieldValue($value_bdd)
    {   
        if(!empty($value_bdd)){
            $value_bdd = str_replace('&amp;#x3D;','=',$value_bdd);
            $value = json_decode( base64_decode($value_bdd),true );
            $value["avis_impot"] = json_decode( base64_decode($value["avis_impot"]),true );;
            $value['value'] = $value_bdd;
        }
        return (!empty($value)) ? $value : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
        return (!empty($value_defaut)) ? str_replace('"', '&quot;',  html_entity_decode($value_defaut) ) : "";
    }
    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        global $app_list_strings;
        if(!empty($value)){
            $value = $this->getFieldValue($value);
        } else {
            $value = array();
        }
        
        $params = json_decode( base64_decode($champ['params']),true);
        $avisImpot = explode(',', $params['avis_impot']);
        $label_avis_impot = array();

        foreach ($avisImpot as $impot) {
            $label_avis_impot[$impot] = $app_list_strings[$params['liste_avis_impot']][$impot];
        }
        $value['label_avis_impot'] = $label_avis_impot;
        $value['label_numero_fiscal'] = 'Numéro fiscal';
        $value['label_referece_fiscal'] = 'Référence de l\'avis fiscal';

        return (!empty($value)) ? $value : "";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public static function getLibelle()
    {
        return "Api particulier";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeApi_Particulier::getLibelle(),
            'icon' => 'fas fa-university',
            'route' => '/champs/?type=api_particulier',
            'attributes' => '',
        ];
    }
}
