<?php

namespace ODE\Generateur\Factory;

use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\Model\GenerateurVueModel;
use ODE\ActionStatut\OdeActionStatut;
use Sugar_Smarty;

use Datetime;
use DateTimeZone;

use BeanFactory;

class OdeFormFactory
{

    protected $bean;
    protected $editable;
    protected $donnees;
    private $typeDouble = array('wysiwyg','note','adresse','api_particulier','adresse_geoloc','tableau','api_r2p');

    function __construct($bean_dossier = null, $editable = false, $donnees = [])
    {
        $this->bean = $bean_dossier;
        $this->editable = $editable;
        $this->donnees = $donnees;
    }

    /**
     * @param string $containerId
     *
     * @return callable
     */
    public function getEtapes($vue="")
    {
        $etapes = [];
        $onglets = $this->getVueOnglets();

        $vueModel = new GenerateurVueModel($this->donnees["vue"]["id"]);
        $liste_champs = $vueModel->getChamps();
        $liste_onglets = [];

        // On récupère le statut et ses actions afin de savoir s'il y a une action visible/modifiable
        $obj_statut = BeanFactory::getBean("OPS_statut", $this->bean->ops_statut_id);

        if($obj_statut!= false){
            $obj_statut->load_relationship('ops_action_statut_ops_statut');

            $listeActions = $obj_statut->ops_action_statut_ops_statut->get();
    
            foreach ($listeActions as $action) {
                $actionBean = BeanFactory::getBean('OPS_action_statut', $action);

                if($actionBean->active == 1 && $actionBean->ext_valeur_2 == "modif_onglet"){
    
                    $action_statut = new OdeActionStatut($actionBean, null);
                    $donnees = $action_statut->getExtValeurText('rendrevisiblemodifiableongletaction');
    
                    if ($vue == 'usager') {
                        $ongletsId = explode(',', $donnees['onglet_internet']);
                        if (empty($ongletsId)) {
                            $ongletsId = $donnees['onglet_internet'];
                        }
        
                        foreach ($ongletsId as $onglet_id) {
                            $liste_onglets[$onglet_id] = array('visible' => $donnees['visible_internet'], 'modifiable' => $donnees['modifiable_internet']);
                        }
                    } else if ($vue == 'partenaire' || $vue == 'avis') {

                        $ongletsId = explode(',', $donnees['onglet_partenaire']);
                        if (empty($ongletsId)) {
                            $ongletsId = $donnees['onglet_partenaire'];
                        }

                        foreach ($ongletsId as $onglet_id) {
                            $liste_onglets[$onglet_id] = array('visible' => $donnees['visible_partenaire'], 'modifiable' => $donnees['modifiable_partenaire']);
                        }

                    }
                }
            }
        }


        $ordre_cond = 0 ; 
        $modifiable = true; 
        $visible = true;
        foreach ($onglets as $ordre => $onglet) {
            $condition_remplie = true;

            // Vérification des conditions de l'étape courante ou précédent 
            $conditions = json_decode( base64_decode($onglet['conditions']) ) ;

            //Si l'onglet fait parti de la liste d'onglets qui ont une visibilité et modification custom. On ne le prend en compte que s'il n'y a pas de conditions sur l'onglet
            if(array_key_exists($onglet["id"], $liste_onglets)) {

                $modifiable = ($liste_onglets[$onglet["id"]]["modifiable"] == 'on') ? true : false;
                $visible = ($liste_onglets[$onglet["id"]]["visible"] == 'on') ? true : false;
            }

            else {
                $modifiable = $onglet["modifiable"];
                $visible = $onglet["visible"];
            }

            // S'il existe une condition sur les étapes passées ou courantes pour l'édition ou récupération des conditions pour le détail 
            if( !empty($conditions->conditions)  ){

                $au_moins_une_condition = false; 
                $condition_remplie = false ;
                $modifiable = $conditions->modifiable; 
                foreach ($conditions->conditions as $key => $condition) {

                    $fieldFactory = new OdeFieldFactory($this->bean, $this->editable, $this->donnees);
                    $value = $fieldFactory->getValueChamp($condition->champ, $liste_champs[$condition->champ]['description']) ;

                    // lancement de la vérification de la condition 
                    $condition_remplie =  $this->is_condition(  $condition->value, $condition->operator ,$value ,  $liste_champs[$condition->champ] );

                    if( $conditions->verified == "all" && $condition_remplie == false ){ // Si toutes les conditions doivent être remplies 
                        break;
                    }
                    elseif( $conditions->verified != "all" && $condition_remplie == true ){ // Si une des conditions est remplie on continue
                        break;
                    }
                }
            }

            // S'il existe un blocage sur le profil 
            if( !empty($conditions->type_profil) && ( (isset( $condition_remplie) && $condition_remplie == true )  || !isset($condition_remplie) ) ){

                $condition_remplie = false ;
                if( !empty($this->bean->ops_personne_morale) ){
                    $obj_pm = BeanFactory::getBean('OPS_personne_morale', $this->bean->ops_personne_morale);

                    foreach ($conditions->type_profil as $type) 
                    {
                        foreach($type as $key => $type_name)
                        {
                            if( $obj_pm->ops_type_personne_id  == $key )
                            {
                                $condition_remplie = true;
                            }
                        }
                    }
                }

            }

            if( empty($conditions->conditions) && !$visible ) {
                $this->donnees['etape_ordre']++ ;
            }
            else if( ( empty($conditions->conditions) && empty($conditions->type_profil) ) 
                || ( $condition_remplie == true && $conditions->visible == true)
                || ( $condition_remplie == false && $conditions->visible != true) 
                || !isset($condition_remplie) 
                || (empty($conditions->conditions)  && empty($conditions->type_profil) && $visible) ){
                $ordre_cond += 1 ; 
                $etapes[$ordre_cond] = [
                    "ordre" => $ordre,
                    "name" => $onglet["libelle"],
                    "conditions" => $onglet["conditions"],
                    "description" => $onglet["description"],
                    "modifiable" => $modifiable,
                ];
            }
            else{
                $this->donnees['etape_ordre']++ ;
            }
        }
        
        return $etapes;
    }

    private function is_condition( $condition_value , $operateur , $champ_value, $champ_type ){

        // Retrait des simples coat sinon => erreur 
        str_replace("'", "", $condition_value );
        str_replace("'", "", $champ_value );

        $champ_value = empty($champ_value) ? 0 : $champ_value;

        $operateur = ( $operateur == "=" ) ? "==" : $operateur;

        switch ($champ_type['type']) {
            case 'checkbox' :
                $condition_value = ( !empty($condition_value) && $condition_value != 'false' && $condition_value != '0' ) ? '1' : '0'; 
                $eval_condition = "'".$champ_value."'=='".$condition_value."'";
                $retour = eval('return ('.$eval_condition.');') ; 
                break;
            case 'liste' :
            case 'liste_referentiel' :
                $params = json_decode( base64_decode($champ_type['params']) ) ; 
                if( $params->multiple == true ){
                    $champ_value = str_replace("^", "", $champ_value );
                    $array_value = explode(",", $champ_value);
                    $retour = in_array($condition_value, $array_value) ; 
                }
                else{
                    $champ_value = str_replace("^", "", $champ_value );
                    $eval_condition = "'".$champ_value."'".$operateur."'".$condition_value."'";
                    $retour = eval('return ('.$eval_condition.');') ; 
                }
                break;
            case 'checkboxmulti' :
                $params = json_decode( base64_decode($champ_type['params']) ) ; 
                $champ_value = str_replace("^", "", $champ_value );
                $array_value = explode(",", $champ_value);
                $retour = in_array($condition_value, $array_value) ; 
                break;
            case 'nombre' :
                if(!empty($champ_value)){
                    $champ_value = number_format($champ_value, 2);
                    $condition_value = number_format($condition_value, 2);
                    $eval_condition = "'".$champ_value."'".$operateur."'".$condition_value."'";
                }else{
                    $eval_condition = 0;
                }
                $retour = eval('return ('.$eval_condition.');') ; 
                break;
            case 'date' :
                // Vérification si la date de condition est saisie en anglais "2000-12-30" ou fr "30/12/2000"
                if( empty( $champ_value ) || strlen($champ_value) != 10 || strlen($condition_value) != 10 ){
                    return false ;
                }

                if( strpos($condition_value, "-") === false ){
                    $date_condition = DateTime::createFromFormat('d/m/Y', $condition_value);
                    $date_condition = $date_condition->format('Y-m-d');
                }
                else{
                    $date_condition = $condition_value ; 
                }            
                $date_value = DateTime::createFromFormat('d/m/Y', $champ_value);
                $date_value = $date_value->format('Y-m-d');

                $eval_condition = "'".$date_value."'".$operateur."'".$date_condition."'";
                $retour = eval('return ('.$eval_condition.');') ; 
                break;
            case 'api_particulier':
                    $params = json_decode( base64_decode($champ_type['params']),true);
                    $value = str_replace('&amp;#x3D;','=',$champ_value);
                    $value = json_decode( base64_decode($value),true);
                    $value_condition = json_decode( base64_decode($value["avis_impot"]),true);
                    $eval_condition = "'".$value_condition[$params['avis_impot_condition']]."'".$operateur."'".$condition_value."'";
                    $retour = eval('return ('.$eval_condition.');') ; 
                break;
            default:
                $eval_condition = "'".$champ_value."'".$operateur."'".$condition_value."'";
                $retour = eval('return ('.$eval_condition.');') ; 

                break;
        }

        return $retour ;


    }

    /**
     * @param string $containerId
     *
     * @return array
     */
    public function getVueOnglets()
    {
        // On vérifie qu'on a bien récupérer la vue 
        if (empty($this->donnees["vue"]["id"])) {
            $GLOBALS['log']->fatal(" OdeFormFactory :: getVueOnglets => L'id de la vue n'est pas renseigné ");
            return [];
        }
        // On récupere les onglets de la vue
        $vueModel = new GenerateurVueModel($this->donnees["vue"]["id"]);
        $vue = $vueModel->getOnglets();

        // On vérifie que la vue n'est pas vide
        return (is_array($vue) && count($vue) > 0) ? $vue : [];
    }

    /**
     * @param string $ordre_onglet
     *
     * @return string
     */
    public function getEtapeHtml($ordre_onglet = null)
    {

        global $current_user, $beanFiles;

        $etape_html = "";
        $etape = [];

        do {

            // On récupere les onglets de la vue et on vérifie que le teableau n'est pas vide
            $onglets = $this->getVueOnglets();
            if (!is_array($onglets) || count($onglets) === 0) {
                $GLOBALS['log']->fatal(" OdeFormFactory :: getEtapeHtml => La vue ne dispose d'aucun onglet ");
                break;
            }

            foreach ($onglets as $onglet) {
                if ($ordre_onglet !== null && $onglet["ordre"] == $ordre_onglet) {
                    $etape = $onglet;
                }
            }

            if (!is_array($etape) || count($etape) === 0) {
                $GLOBALS['log']->fatal(" OdeFormFactory :: getEtapeHtml => L'onglet ordre = " . $ordre_onglet . " n'existe pas dans la vue " . $this->donnees["vue"]["id"]);
                break;
            }

            $etape_html .= '<div role="group" data-role="etape-formulaire" data-ordre="' . $etape["ordre"] . '" data-conditions="' . $etape["conditions"] . '" >';
            if (is_array($etape["lignes"]) && count($etape["lignes"]) > 0) {
                $tab_champs = array();
                foreach ($etape["lignes"] as $ligne) {            
                    if ($ligne["type"] === "section") {
                        $etape_html .=  $this->getSectionHtml($ligne["title"],$ligne["conditions"]);
                        //Ajout condition pour les sections
                        array_push($tab_champs, $ligne['id'] ) ; 
                        $tab_conditions = json_decode( base64_decode( $ligne['conditions'] ) ) ; 
                        if( is_object( $tab_conditions )){
                            foreach ($tab_conditions as $cle => $value) {
                                foreach ($value as $clef => $condition) {
                                    $tab_champs_conditions[] = $condition->champ ; 
                                }
                            }
                        }
                    } else if ($ligne["type"] === "ligne_double_champ") {
                        $etape_html .=  $this->getLigneDoubleChampHtml($ligne["champs"]);
                    } else if ($ligne["type"] === "ligne_simple_champ") {
                        $etape_html .=  $this->getLigneSimpleChampHtml($ligne["champs"]);
                    } else {
                        $GLOBALS['log']->fatal(" OdeFormFactory :: getHtml => type ");
                    }
    
                    // Récupération des conditions des champs 
                    foreach ($ligne["champs"] as $key => $champ) {
                        array_push($tab_champs, $champ['name'] ) ; 
                        $tab_conditions = json_decode( base64_decode( $champ['conditions'] ) ) ; 
                        if( is_object( $tab_conditions )){
                            foreach ($tab_conditions as $cle => $value) {
                                foreach ($value as $clef => $condition) {
                                    $tab_champs_conditions[] = $condition->champ ; 
                                }
                            }
                        }
                    }

                }


            }
            $etape_html .= '</div>';

            // Création d'un div hidden pour la gestion des valeurs de champ conditionné 
            if( is_array($tab_champs_conditions) && !empty($tab_champs_conditions) && $this->editable == true ){
                $vueModel = new GenerateurVueModel($this->donnees["vue"]["id"]);
                $liste_champs = $vueModel->getChamps();
                $etape_html .= '<div role="etape-conditions-fields" style="display:none;">';
                foreach ($tab_champs_conditions as $key => $value) {
                    if( !in_array( $value, $tab_champs ) ){
                        $etape_html .= $this->getChampHtml($liste_champs[$value]) ;
                    }
                }
                $etape_html .= '</div>';
            }


        } while (0);

        return $etape_html;
    }

    /**
     * @access private
     * @name getChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getChampHtml($champ)
    {

        $fieldFactory = new OdeFieldFactory($this->bean, $this->editable, $this->donnees);
        return $fieldFactory->getHtml($champ);
    }

    /**
     * @access private
     * @name getSectionHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getSectionHtml($titre, $conditions)
    {
        // $smarty = new Sugar_Smarty();
        // $smarty->assign("titre", $titre);
        // return $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/section.tpl");

        $section_html = '<div class="row field-line section">';
        $section_html .= '<div class="col-md-12 section-title section-title-wide   field-box">';
        $section_html .= '<h3 data-role="section-formulaire" rel="section" data-name="'.create_guid().'" data-conditions="'.$conditions.'"> ' . $titre . ' </h3>';
        $section_html .= '</div></div>';
        return $section_html;

    }

    /**
     * @access private
     * @name getChampVideHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getChampVideHtml()
    {
        return '<div class="row"></div>';
    }

    /**
     * @access private
     * @name getLigneDoubleChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getLigneDoubleChampHtml($champs)
    {

        if(is_array($champs) && in_array($champs[0]['type'], $this->typeDouble) ){
                $ligne_html .= $this->getChampHtml($champs[0]);
                $champ_1 = ( is_array($champs[0]) && count($champs[0]) > 0 ) ? $this->getChampHtml($champs[0]) : $this->getChampVideHtml();
                $smarty = new Sugar_Smarty();
                $smarty->assign("champ_1", $champ_1);
                return $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/ligne_simple.tpl");
        }
        else if(is_array($champs) && in_array($champs[1]['type'], $this->typeDouble)){
                $ligne_html .= $this->getChampHtml($champs[1]);
                $champ_1 = ( is_array($champs[1]) && count($champs[1]) > 0 ) ? $this->getChampHtml($champs[1]) : $this->getChampVideHtml();
                $smarty = new Sugar_Smarty();
                $smarty->assign("champ_1", $champ_1);
                return $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/ligne_simple.tpl");
        }else{
            $champ_1 = "";
            $champ_2 = "";
            if (is_array($champs) && count($champs) === 2) {
                $champ_1 = ( is_array($champs[0]) && count($champs[0]) > 0 ) ? $this->getChampHtml($champs[0]) : $this->getChampVideHtml();
                $champ_2 = ( is_array($champs[1]) && count($champs[1]) > 0 ) ? $this->getChampHtml($champs[1]) : $this->getChampVideHtml();
            }
            $smarty = new Sugar_Smarty();
            $smarty->assign("champ_1", $champ_1);
            $smarty->assign("champ_2", $champ_2);
            return $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/ligne_double.tpl");
        }
    }

    /**
     * @access private
     * @name getLigneSimpleChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getLigneSimpleChampHtml($champs)
    {
        //$ligne_html .= $this->getChampHtml($champs[0]);
        $champ_simple = ( is_array($champs[0]) && count($champs[0]) > 0 ) ? $this->getChampHtml($champs[0]) : $this->getChampVideHtml();
        
        /**
         * #2966
        */
        if(!strpos($champ_simple, 'col-md-6'))
        {
            $champ_simple = str_replace('col-md-4', 'col-md-2', $champ_simple);
            $champ_simple = str_replace('col-md-8', 'col-md-10', $champ_simple);
        }

        $smarty = new Sugar_Smarty();
        $smarty->assign("champ_1", $champ_simple);
        return $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/ligne_simple.tpl");
    }

}
