var Router = Router || {};

var FormulaireChampCondition = {};

Router = (function ($, formulaireChamp, formulaireCondition, formulaireOnglet, listeCondition, formulaireListe, formulaireSection) {

  var history = [];
  const root = "/";

  return {

    /**
     * Fonction d'initialisation du Router 
     *  => Initialise le click sur les boutons
     *  => Redirige vers la page home "/"
     * 
     * @return @return {void}
     */
    start: function() {
      this.setClickRoutes();
      this.navigate(root);
    },

    /**
     * Fonction qui initialise le onclick sur les boutons de navigation
     *
     * @return @return {void}
     */
    setClickRoutes: function() {
      const self = this;
      $("[role=navigation]").each(function() {
        $(this).off().click(function(){ self.navigate($( this ).attr( "data-route" )); });
      });
    },

    /**
     * Fonction qui retourne la derniere ligne de l'historique de navigation
     *
     * @return {string} last_route
     */
    getLastHistory: function() { return history.slice(-1)[0] ; },

    /**
     * Fonction qui supprime la derniere ligne de l'historique de navigation
     *
     * @return {void}
     */
    splitLastHistory: function() { history.pop() },

    /**
     * Fonction qui ajoute la route à l'historique de navigation
     * 
     * @param {string} route La nouvelle route
     * @return {void} 
     */
    pushHistory: function(route) { history.push(route) },

    /**
     * Fonction qui retourne l'historique de navigation
     *
     * @return {array} history 
     */
    getHistory: function() { return history; },

    /**
     * Fonction de navigation entre les differentes pages
     *
     * @param {string} route La route de destination
     * @return {void} 
     */
    navigate: function(route) {

      const self = this;

      if ( route === "back" ) {
        // Si la route est égal à "back" => on supprime la derniere ligne de l'historique ( Localisation actuelle ) et on récupere la derniere route 
        this.splitLastHistory();
        route = this.getLastHistory();

      } else {
        // Si la derniere route est le formuaire de champs 
        let last_history = this.getLastHistory();

        // Les exeptions : 
        if ( this.isChampExeption(route, last_history) || route === "back-formulaire" )  this.splitLastHistory();

        if ( route !== "back-formulaire" &&  route !== last_history ) this.pushHistory(route);
        
      }
      
      var page_route = this.initPage(route);

      $("[role=page]").each(function() {
        ( $(this).attr("data-route") === page_route ) ?  $(this).fadeIn(400) : $(this).hide();
      });
      
    },

    initPage: function(route) { 

      if ( route.includes("/champs/") ){
          formulaireChamp.display(this.getRouteParam("type", route) , this.getRouteParam("id", route));
          return "/formulaire/champ";
      } 

      if ( route.includes("/section/") ){
        formulaireSection.display('section', this.getRouteParam("id", route));
        return "/formulaire/section";
      } 

      if ( route.includes("back-formulaire-champ") ){
          return "/formulaire/champ";
      } 
    
      if ( route.includes("back-formulaire-onglet") ){
        return "/formulaire/onglet";
      } 

      if ( route.includes("/conditions/champ-list") ){
          listeCondition.display(this.getRouteParam("type", route));
          return "/conditions/champ-list";
      } 

      if ( route.includes("/champ/edit-liste") ){
          formulaireListe.display();
          return "/champ/edit-liste";
      } 

      if ( route.includes("/formulaire-condition") ){
        FormCondition.display( this.getRouteParam("champ", route) , this.getRouteParam("operator", route), this.getRouteParam("value", route) );
        return "/formulaire-condition";
      } 

      if ( route.includes("/conditions/champ") ){
          formulaireCondition.display( this.getRouteParam("champ", route) , this.getRouteParam("operator", route), this.getRouteParam("value", route) );
          return "/conditions/champ";
      } 

      if ( route.includes("/formulaire/onglet") ){
          formulaireOnglet.display(this.getRouteParam("vue_type", route) , this.getRouteParam("vue_id", route), this.getRouteParam("onglet_id", route));
          return "/formulaire/onglet";
      } 

      return route;
    },

    /**
     * Fonction qui retourne la valeur du parametre de la route
     *
     * @param {string} param Le libelle du parametre
     * @param {string} route La route 
     * @return {string} value 
     */
    getRouteParam: function( param, route){
      param = param.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
      var regexS = "[\\?&]"+param+"=([^&#]*)";
      var regex = new RegExp( regexS );
      var results = regex.exec( route );
      return results == null ? null : results[1];
    },

    isChampExeption: function(route, last_history) {
      return ( (last_history !== undefined && last_history.includes("/champs/") && !route.includes("/conditions/champ-list") && !route.includes("/champ/edit-liste")) || (last_history !== undefined && last_history.includes("/section")) ) ? true : false;
    },

    isOngletExeption: function(route, last_history) {
      return ( (last_history !== undefined && last_history.includes("/champs/") && !route.includes("/conditions/champ-list") && !route.includes("/champ/edit-liste")) || (last_history !== undefined && last_history.includes("/section")) ) ? true : false;
    },

  }

})(jQuery,FormulaireChamp,FormulaireChampCondition,FormulaireOnglet,FormulaireChampConditionListe,FormulaireChampListe,FormulaireSection);