var FormulaireChamp = (function($,Champ) {

    return {

        /**
         * Fonction qui initialise le formulaire "formulaire-champ.tpl" avant le display par le routeur
         * 
         * @param {string} champ_type Le type de champ : text, date, relation ... etc
         * @param {string} champ_id L'id du champ 
         * @return {void} 
         */
         display: function( champ_type, champ_id ){
    
            const self = this;

            /*******  Propriétés  ********/ 

            // Initialisation les tabs de navigation 
            this.initTabs();

            // Initialisation du sous titre du formulaire ( Type de champ )
            $("#g-champ-form-sous-title").text( Champ.getLibelleType(champ_type) );

            // On vérifie si il s'agit d'une création ou d'une modification
            var creation = ( champ_id !== undefined && champ_id !== null && !champ_id.isEmpty() ) ? false : true;

            // On récupere les données du champ si il s'agit d'une modification sinon un object vide
            var data = ( creation ) ? Champ.getEmptyData(champ_type) : Champ.getData(champ_id);

            // Initialisation du titre du formulaire
            ( creation ) ? $("#g-champ-form-title").text("Nouveau champ") : $("#g-champ-form-title").text(data.libelle) ;

            // Initialisation de proprité "disabled" de l'input "nom"
            ( creation ) ? $("#form-field-nom").removeAttr("disabled") : $("#form-field-nom").attr("disabled","disabled");

            // On stocke les differents parametres du champ dans les input hidden du formulaire
            ( creation ) ? $("#g-champ-form-id").val("") : $("#g-champ-form-id").val( champ_id );
            $("#g-champ-form-type").val( champ_type );
            $("#g-champ-form-description").val( data.description );
            $("#g-champ-form-modifiable").val( data.modifiable );
            $("#g-champ-form-params").val( data.params );
            $("#g-champ-form-conditions").val( data.conditions );

            // On récupere les elements du formulaire afin d'afficher uniquement les elements qui concerne le type 
            const fields = $("#g-champ-form-formulaire").children(); 
            $('[data-role-defaut]').hide();
            fields.each(function() {
                let role = $(this).attr("data-role");
                let regex = new RegExp(champ_type + '(\\+|$)');
                if ( $(this).attr("data-role") === "all" || $(this).attr("data-role") === champ_type || ($(this).attr("data-role") != undefined && regex.test(role)) ){

                    let field_name = ( $(this).attr("data-name") !== undefined && $(`#${$(this).attr("data-name")}`) !== undefined ) ? $(`#${$(this).attr("data-name")}`).attr("data-name")  : false ;
                    if (  field_name !== false ){
                        let field_value = ( Object.getLength(data) > 0 && data.hasOwnProperty(field_name) && !data[field_name].isEmpty() ) ? data[field_name] : null;
                        self.setDataField($(`#${$(this).attr("data-name")}`),field_name,field_value);
                    }
                    if(champ_type === "note" && $(this).attr("data-name") == 'form-field-defaut-note'){
                        self.initBtnWysiwyg(true);
                    }else{
                        self.initBtnWysiwyg(false);
                    }
                    if(champ_type === "tableau" && $(this).attr("data-name") == 'form-field-param-tableau'){
                        self.initBtnTableau(true);
                    }else{
                        self.initBtnTableau(false);
                    }
                    if(champ_type === "liste_referentiel"){
                        self.initSelectDefautReferentiel();
                    }
                    if(champ_type === "fonction"){
                        self.cacheParametrePourFonction();
                    }

                    // #4221 - Implémentation de la surchage | Support du champ Données Financières.
                    if(champ_type === "donnees_comptables" && $(this).attr("data-name") == 'form-field-type-donnee-comptable'){
                        self.initSelectDonneeComptable();
                    }

                    Champ.hideVerification( $(`#${$(this).attr("data-name")}`) );
                    $(this).show();
                } else if($(this).attr("data-role-defaut") === undefined){
                    $(this).hide();
                }
            });

            // On initilise le onClick sur le bouton " Edition de liste"
            this.setClickEditListe();

            // On cache le formulaire de modification des listes
            $("#g-champ-form-formulaire").show();
            $("#g-champ-form-liste").hide();

            if(champ_id !== undefined && champ_id !== null)
            {
                $('[href="#g-champ-condition-form"]').closest('li').show();
                $('[href="#g-champ-form"]').closest('li').css('width', '50%');
                $('[href="#g-champ-form"]').css('border-right', '0');

                /***********   Conditions   ***********/ 

                // On initialise la route du bouton "+" ( ajouter une condition ) avec l'id du champ si il s'agit d'une modification
                ( creation ) ? $("#g-champ-form-condition-add-btn").attr("data-route",`/formulaire-condition?id=`) : $("#g-champ-form-condition-add-btn").attr("data-route",`/formulaire-condition?id=${champ_id}`);
                
                // On récupere les conditions du champ au format object 
                var field_conditions = ( !data.conditions.isEmpty() ) ? JSON.parse( data.conditions.b64ToUtf8() ) : { verified: "all",  visible: 1, modifiable: 1, conditions: [], type_profil:[] };
                OdeLog.log( OdeLog.asAlert("field_conditions"), field_conditions );

                // On initialise la liste des conditions
                this.setListeConditions( field_conditions );
         
                // On initilise la valeur du selection de vérification " Toutes les conditions ou une seule condition "
                $(`#g-champ-form-condition-verified option[value="${field_conditions.verified}"]`).prop('selected', true);
                OdeLog.log( OdeLog.asAlert("field_conditions.verified"), field_conditions.verified );
                // On initilise la valeur des boutons radio pour la visibilité
                ( field_conditions.visible === 1 ) ? $('#g-champ-form-condition-visible-oui').prop('checked', true) : $('#g-champ-form-condition-visible-non').prop('checked', true);

                // On initilise la valeur des boutons radio pour la modification
                ( field_conditions.modifiable === 1 ) ? $('#g-champ-form-condition-modifiable-oui').prop('checked', true) : $('#g-champ-form-condition-modifiable-non').prop('checked', true);

                // On initialise le click sur le bouton " Ajouter une condition "
                this.setClickAddConditionBtn();

                // On affiche la liste des conditions et on cache le formulaire 
                $("#g-champ-form-condition-liste").show();
                $("#g-champ-form-condition-formulaire").hide();
            }
            else
            {
                $('[href="#g-champ-condition-form"]').closest('li').hide();
                $('[href="#g-champ-form"]').closest('li').css('width', '100%');
                $('[href="#g-champ-form"]').css('border-right', '1px solid hsl(210, 6%, 79%)');
            }
            

            // On initilise le bouton " Sauvegarde " du formulaire 
            this.setSaveFormulaireBtn();

            // On initialise le select du champ défaut
            this.setChangeDefautBtn();

        },

        /** 
         * Fonction qui initialise le click sur les tabs "Propriétés" et "Conditions"
         * 
         * @return {void} 
        */
        initTabs: function() { 
            $('.g-champ-tabs-nav a').off().on('click', function (event) {
                event.preventDefault();
                $('.g-champ-tab-active').removeClass('g-champ-tab-active');
                $(this).parent().addClass('g-champ-tab-active');
                if ( $(this).attr('href') === "#g-champ-form" ) {
                    $("#g-champ-form").show();
                    $("#g-champ-condition-form").hide();
                } else {
                    $("#g-champ-form").hide();
                    $("#g-champ-condition-form").show();
                }
            });
            $('.g-champ-tabs-nav a:first').trigger('click');
        }, 

        /**
         * Fonction qui initialise le select du champ défaut
         * 
         * @return {void} 
        */
        setChangeDefautBtn: function() {
            $( "#form-field-defaut" ).off().change(function() {
                if($(this).val() == 'demandeur' || $(this).val() == 'beneficiaire'){
                    $('#select_defaut_OPS_individu').show();
                    $('#select_defaut_OPS_individu').val('');
                    $('#select_defaut_OPS_personne_morale').hide();
                    $('#form-field-defaut-url').hide();
                    $('[data-role-defaut]').hide();
                }else if($(this).val() == 'profil'){
                    $('#select_defaut_OPS_personne_morale').show();
                    $('#select_defaut_OPS_personne_morale').val('');
                    $('#select_defaut_OPS_individu').hide();
                    $('#form-field-defaut-url').hide();
                    $('[data-role-defaut]').hide();
                }else if($(this).val() == 'autre'){
                    $('#select_defaut_OPS_individu').hide();
                    $('#select_defaut_OPS_individu').val('');
                    $('#select_defaut_OPS_personne_morale').hide();
                    $('#select_defaut_OPS_personne_morale').val('');
                    $('#form-field-defaut-url').hide();
                    $('[data-role-defaut]').hide();
                    $('[data-role-defaut]').each(function() {
                        if($(this).attr("data-role-defaut").includes($("#g-champ-form-type").val())){
                            let field_name = ( $(this).attr("data-name") !== undefined && $(`#${$(this).attr("data-name")}`) !== undefined ) ? $(`#${$(this).attr("data-name")}`).attr("data-name")  : false ;
                            if (  field_name !== false && $('#g-champ-form-type').val() != "liste_referentiel" ){
                                $(this).val(FormulaireChamp.setDataField($(`#${$(this).attr("data-name")}`),field_name,''));
                            }
                            $(this).show();
                        }
                    });
                }else if($(this).val() == 'url'){
                    $('#select_defaut_OPS_individu').hide();
                    $('#select_defaut_OPS_personne_morale').hide();
                    $('[data-role-defaut]').hide();
                    $('#form-field-defaut-url').show();
                    $('[data-role-defaut=url]').show();
                }
                else{
                    $('#select_defaut_OPS_individu').hide();
                    $('#select_defaut_OPS_individu').val('');
                    $('#select_defaut_OPS_personne_morale').hide();
                    $('#select_defaut_OPS_personne_morale').val('');
                    $('[data-role-defaut]').hide();
                    $('#form-field-defaut-url').hide();
                }
            });
        },

        /**
         * Fonction qui initialise la sauvegarde du formulaire
         * 
         * @return {void} 
        */
        setSaveFormulaireBtn: function() { 
            const self = this;
            $( "#g-champ-save-btn" ).off().click(function() {
                // On récupere l'id et les data du champ
                var champ_id = self.getChampId();
                var champ_data = self.getChampData(champ_id);
                // Vérification des champs du formulaire
                var is_valid = self.isValidFormulaire(champ_id,champ_data);
                if ( is_valid ) {
                    var params = (champ_data.params === "")?{"ineditable":"false"}:JSON.parse( atob(champ_data.params) );
                    if(champ_data.type == 'nombre'){
                        params.minimum = champ_data.minimum;
                        params.maximum = champ_data.maximum;
                        params.decimal = champ_data.decimal;
                    }
                    if(champ_data.type == 'file'){
                        params.attache = champ_data.attache;
                    }
                    if(champ_data.type == 'api_particulier'){
                        params.avis_impot = champ_data.avis_impot;
                        params.avis_impot_condition = champ_data.avis_impot_condition;
                    }
                    if(champ_data.type == 'calcul'){
                        params.formule_calcul = champ_data.formule_calcul;
                        params.format = champ_data.format;
                        params.decimal = champ_data.decimal;
                    }
                    if(champ_data.type == 'text'){
                        params.mask = champ_data.mask;
                    }
                    if(champ_data.type == 'tableau'){
                        params.tableau_param = champ_data.tableau_param;
                    }
                    if(champ_data.type == 'liste_referentiel'){
                        params.liste_referentiel = champ_data.liste_referentiel;
                    }
                    if(champ_data.type == 'grille_tarifaire'){
                        params.grille_tarifaire = champ_data.grille_tarifaire;
                    }
                    if(champ_data.type == 'fonction'){
                        params.fonction = champ_data.fonction;
                        params.parametre_fonction = champ_data.parametre_fonction;
                    }
                    if(champ_data.type == 'api_r2p'){
                        params.api_r2p = champ_data.api_r2p;
                    }

                    // #4221 - Implémentation de la surchage | Support du champ Données Financières.
                    if(champ_data.type == 'donnees_comptables'){
                        params.type_donnee_comptable = champ_data.type_donnee_comptable;
                        params.annee_comptable = champ_data.annee_comptable;
                        params.tableau_existe_comptable = btoa(unescape(encodeURIComponent(champ_data.tableau_existe_comptable)));
                    }

                    champ_data.params = btoa( JSON.stringify( params ) );

                    // Si l'id est vide => il s'agit d'une création sinon modification
                    ( champ_id.isEmpty() ) ? self.createChamp(champ_data) : self.updateChamp(champ_id,champ_data);
                }
            });
        },

        /**
         * Fonction qui retourne l'id du champ sauvegardé dans l'input hidden
         * 
         * @return {string} 
        */
        getChampId: function(){ return ( $("#g-champ-form-id").val() !== undefined ) ? $("#g-champ-form-id").val() : ""; },

        /**
         * Fonction qui retourne les données du formulaire en format object 
         * 
         * @return {object} 
        */
        getChampData: function(champ_id){
             
            const self = this;
            var data = {};
  
            // On récupere les valeurs des elements du formulaire par type
            const formulaire_fields = $("#g-champ-form-formulaire").children();
            formulaire_fields.each(function() {
                let role = $(this).attr("data-role");
                let regex = new RegExp($("#g-champ-form-type").val() + '(\\+|$)');
                 if ( $(this).attr("data-role") === "all" || $(this).attr("data-role") === $("#g-champ-form-type").val() || ($(this).attr("data-role") && regex.test(role)) ){

                    let field_name = ( $(this).attr("data-name") !== undefined && $(`#${$(this).attr("data-name")}`) !== undefined ) ? $(`#${$(this).attr("data-name")}`).attr("data-name")  : false ;
                    if (  field_name !== false ){
                        data[field_name] = self.getDataField($(`#${$(this).attr("data-name")}`),field_name);
                    }
                }
            });

            // On complete avec les champs hidden
            if ( Object.getLength(data) > 0 ) {
                data["id"] =  $("#g-champ-form-id").val();
                data["description"] =  $("#g-champ-form-description").val();
                data["modifiable"] = $("#g-champ-form-modifiable").val();
                data["type"] = $("#g-champ-form-type").val();
                data["conditions"] = (champ_id)?JSON.stringify( this.getChampConditions() ).utf8ToB64():"eyJ2ZXJpZmllZCI6ImFsbCIsInZpc2libGUiOjEsIm1vZGlmaWFibGUiOjEsInR5cGVfcHJvZmlsIjpbXSwiY29uZGl0aW9ucyI6W119";
                data["params"] = $("#g-champ-form-params").val();
            }

            OdeLog.log( OdeLog.asSuccess("data"), data);

            return data;
     
        },

        /**
         * Fonction qui retourne la valeur d'un element selon son type et tag
         * 
         * @return {string} 
        */
        getDataField: function( field, field_name ) { 

            var field_value = "";
            var field_tag = field.get(0).tagName;
            var field_type = field.attr("type");

            if(field_name == 'defaut' && field_tag == 'SELECT'){
                field_value = this.getChampDefaut( field );
            }else if ( field_tag === "INPUT" ){
                if ( field_type === "text" ){
                    if(field_name == 'defaut-champ'){
                        field_value = ( !field.val().isEmpty() ) ? unescape(encodeURIComponent(field.val())) : "";
                    }else{
                        field_value = ( !field.val().isEmpty() ) ? field.val() : "";
                    }
                } else if ( field_type === "checkbox" ) {
                    if ( field_name === "multiple" ){ 
                        ( field.prop("checked") === true ) ? this.setMultipleValue(1) : this.setMultipleValue(0);
                    } else {
                        field_value = ( field.prop("checked") === true ) ? "1" : "0";
                    }
                } else if ( field_type === "number" ) { 
                    field_value = ( !field.val().isEmpty() ) ? field.val() : 0;
                } else {
                    OdeLog.log( OdeLog.asAlert("Erreur"), "Type champ input non géré", field );
                }
            } else if ( field_tag === "SELECT" ){
                if ( field_name === "liste" ){
                } else if ( field_name === "defaut" 
                         || field_name === "attache" 
                         || field_name === "avis_impot_condition" 
                         || field_name === "defaut-champ" 
                         || field_name === "format" 
                         || field_name === "liste_referentiel" 
                         || field_name === "fonction" 
                         || field_name === "grille_tarifaire"
                         /* #4221 - Implémentation de la surchage | Support du champ Données Financières. */
                         || field_name === "type_donnee_comptable" 
                         || field_name === "annee_comptable"
                ){
                    field_value = this.getChampDefautList( field.attr("id") );
                } else if(field_name === "mime" 
                       || field_name === "avis_impot" 
                       || field_name === "api_r2p"
                ){
                    field_value = this.getChampMulti( field.attr("id") );
                } else {
                    OdeLog.log( OdeLog.asAlert("Erreur"), "param champ non géré", field );
                }
            } 
            else if(field_tag === "TEXTAREA"){
                if(field_name == 'formule_calcul' || field_name == 'parametre_fonction'){
                    field_value = ( !field.val().isEmpty() ) ? field.val() : "";
                }else{
                    field_value = ( !field.text().isEmpty() ) ? field.text() : "";
                }
            }else {
                OdeLog.log( OdeLog.asAlert("Erreur"), "Tag champ non géré", field );
            }

            return field_value;
        },

        /**
         * Fonction qui vérifie si 
         *          Le champ nom n'est pas vide et n'existe pas dans la liste des champs
         *          Le champ libelle n'est pas vide
         * 
         * @param {string}  champ_id     L'id du champ 
         * @param {object}  champ_data   Les données du champ
         * @return {boolean} 
        */
        isValidFormulaire: function(champ_id,champ_data){
            var valid = true;
            Object.keys(champ_data).forEach(function (champ_name) {
                var champ_value = champ_data[champ_name];
                switch(champ_name){
                    case 'nom':
                        if ( Champ.isChampExist(champ_value) && champ_id.isEmpty() ){
                            valid = false;
                            Champ.displayVerification( $("#form-field-nom") , "warning", `Le champ ${champ_value} existe déjà dans le référentiel` )
                        } else {
                            if ( champ_value.isEmpty() ){
                                valid = false;
                                Champ.displayVerification( $("#form-field-nom") , "error", "Le nom est obligatoire" )
                            } else {
                                Champ.displayVerification( $("#form-field-nom") , "success", "" )
                            }
                        }
                        break;
                    case 'libelle':
                        if ( champ_value.isEmpty() ){
                            valid = false;
                            Champ.displayVerification( $("#form-field-libelle") , "error", "Le libellé est obligatoire" )
                        } else {
                            Champ.displayVerification( $("#form-field-libelle") , "success", "" )
                        }
                        break;
                    case 'attache':
                        if ( champ_value.isEmpty() ){
                            valid = false;
                            Champ.displayVerification( $("#form-field-attache-file") , "error", "Le type est obligatoire" )
                        } else {
                            Champ.displayVerification( $("#form-field-attache-file") , "success", "" )
                        }
                        break;
                    case 'formule_calcul':
                        if ( champ_value.isEmpty() ){
                            valid = false;
                            Champ.displayVerification( $("#form-field-formule-calcul") , "error", "La formule de calcul est obligatoire" )
                        } else {
                            var regex = /^[A-Za-z0-9+\/()\-_$*\n ]*$/i;
                            if (regex.test(champ_value)) {
                              Champ.displayVerification( $("#form-field-formule-calcul") , "success", "" )
                            } else {
                              Champ.displayVerification( $("#form-field-formule-calcul") , "error", "La saisie contient des caractères non autorisés" )
                            }
                        }
                        break;
                    default:
                        $("[data-role=champ-formulaire]").each(function() {
                            if( $(this).attr("data-name") === champ_name ){
                                Champ.displayVerification( $(this) , "success" , "");
                            }
                        });
                        break;
                }
            });
     
            return valid;
        },

        /**
         * Fonction qui crée le champ dans le module OPS_generateur_referentiel 
         * 
         * @param {object}  data   Les données du champ
         * @return {void} 
        */
        createChamp: function(data){
            loading = function(){
                OdeLoadingHelper.addSpinnerMenu();
            };
            callBack = function(){
                setTimeout(function(){ OdeLoadingHelper.removeSpinnerMenu(); }, 1500);
                if ( typeof this.result === "string" ){
                    OdeAlertHelper.set($(`#g-champ-form-message`), "error", "La ressource demandée n'existe pas");
                }  else {

                    // On ajoute le champ à la liste des champs et on réinitilise l'event draggable des champs
                    var champ_html = Champ.getHtml(this.result);
                    $("#list-champ-container").append($(champ_html));
                    Champ.setDraggable();

                    // On réinitialise l'event sur le role navigation pour activer l'edition du champ
                    Router.setClickRoutes();

                    // On redirige vers liste et on scroll tout en bas 
                    Router.navigate("/");
                    setTimeout(function(){ $("#g-menu").animate({scrollTop: 9999}, 1000) }, 500);
                }
            };
            Champ.create(data, loading, callBack);
        },

        /**
         * Fonction qui met à jour le champ en local  
         * 
         * @param {string}      id      L'id du champ 
         * @param {object}      data    Les données du champ
         * @return {void} 
        */
        updateChamp: function(id,data){
            OdeLoadingHelper.addSpinnerMenu();
            Champ.update(id , data);

            //Flag modification
            Champ.flagModification(data.id);
        },

        /**
         * Fonction qui ajoute l'attribut "multiple" au params des champs de type liste 
         * 
         * @param {string}      value      La valeur "1" ou "0"
         * @return {void} 
        */
        setMultipleValue: function( value ){
            var params = this.getChampParams();
            params.multiple = ( value === 1 ) ? 1 : 0 ;
            $("#g-champ-form-params").val( JSON.stringify(params).utf8ToB64() )
        },

        // Retourne un array des conditions du champ
        getChampConditions: function () {
            var conditions = { verified: "all",  visible: 1, modifiable: 1, type_profil:[], conditions: [] }; 
            var conditions_encoded = $("#g-champ-form-conditions").val();
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                conditions = JSON.parse(conditions_encoded.b64ToUtf8());  
            }

            /*var selectTypeProfil = $("#g-champ-form-condition-type-profil").val();
            if(selectTypeProfil[0] == '') selectTypeProfil.splice(0,1);
            $.each(selectTypeProfil, function(index, value) {
                if(index == 0){
                    type_profil += selectTypeProfil[index];
                }else{
                    type_profil += ','+selectTypeProfil[index]; 
                }
            });*/

            //conditions.type_profil = type_profil;
            conditions.verified = $("#g-champ-form-condition-verified option:selected").val();
            conditions.visible = ( $('#g-champ-form-condition-visible-oui').prop('checked') === true ) ? 1 : 0 ;
            conditions.modifiable = ( $('#g-champ-form-condition-modifiable-oui').prop('checked') === true ) ? 1 : 0 ;
            OdeLog.log( OdeLog.asWarning("conditions"), conditions );
            return conditions;
        },

        /**
         * Fonction qui retourne la valeur de l'attribut "multiple" des champs de type liste 
         * 
         * @return {string} 
        */
        getMultipleValue: function(){
            var params = this.getChampParams();
            return ( Object.getLength(params) > 0 && params.hasOwnProperty("multiple") && params.multiple === 1 ) ? 1 : 0;
        },

        /**
         * Fonction qui retourne les params du champ format object
         * 
         * @return {object} 
        */
        getChampParams: function ( type = null){
            var params_retour = { liste: {}, multiple: 0 };
            var params = $("#g-champ-form-params").val();
            if ( params !== undefined && !params.isEmpty() ){
                var params_decoded = JSON.parse( params.b64ToUtf8() );
                if ( Object.getLength(params_decoded) > 0 ){
                    if ( params_decoded.hasOwnProperty("liste_name") ){
                        params_retour.liste = this.getListeNative(params_decoded.liste_name);
                    }
                    if ( params_decoded.hasOwnProperty("liste_attache") && type == 'attache'){
                        params_retour.liste = JSON.parse( $("#type_document").val().b64ToUtf8());
                    }
                    if ( params_decoded.hasOwnProperty("liste_mime") &&  type == 'mime'){
                        params_retour.liste = this.getListeNative(params_decoded.liste_mime);
                    }
                    if ( params_decoded.hasOwnProperty("liste_avis_impot") &&  type == 'api_particulier'){
                        params_retour.liste = this.getListeNative(params_decoded.liste_avis_impot);
                    }
                    if ( params_decoded.hasOwnProperty("liste_api_r2p") &&  type == 'api_r2p'){
                        params_retour.liste = this.getListeNative(params_decoded.liste_api_r2p);
                    }

                    

                    if ( params_decoded.hasOwnProperty("multiple") && params_decoded.multiple === 1 ) {
                        params_retour.multiple = 1;
                    }
                    if ( params_decoded.hasOwnProperty("liste") && Object.getLength(params_decoded.liste) > 0 ){
                        params_retour.liste = params_decoded.liste;
                    }
                }
            }
            return params_retour;
        },

        /**
         * Fonction qui retourne les données de la liste ( Les listes app_string de SuiteCRM )
         * 
         * @return {object} 
        */
        getListeNative: function ( liste_name ){
            var liste = {};
            var liste_suiteCRM = JSON.parse( $("#suitecrm_listes").val().b64ToUtf8() );
            if ( Object.getLength(liste_suiteCRM) > 0 && liste_suiteCRM.hasOwnProperty(liste_name) ){
                liste = liste_suiteCRM[liste_name];
            }
            return liste;
        },

        /**
         * Fonction qui initialise le click sur le bouton " Ajouter une condition "
         * 
         * @return {void} 
         */
        setClickAddConditionBtn: function(){ 
            const self = this;
            $("#g-champ-form-condition-add-btn").off().click(function(){ 
                self.initFormCondition(null,null,null);
                $("#g-champ-form-condition-liste").hide();
                $("#g-champ-form-condition-formulaire").show();
            });

            $("#g-champ-form-condition-type-profil-add-btn").off().click(function(){
                open_popup("OPS_type_personne",600,400,"",true,false,
                {"call_back_function":"FormulaireChamp.getConditionTypeProfil","form_name":"generer","field_to_name_array":{"id":"id","name":"type_profil"}},"single",true);
            });
        },

        getConditionTypeProfil: function(typeProfil){
            var conditions_encoded = $("#g-champ-form-conditions").val();
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                conditions = JSON.parse(conditions_encoded.b64ToUtf8());
            }else{
                conditions = FormulaireOnglet.getConditions();
            }
            if(!Array.isArray(conditions.type_profil)) conditions.type_profil = [];
            if(conditions.type_profil.length > 0){
                var check = false;
                $.each(conditions.type_profil, function(key, tab) {
                    $.each(tab, function(id, value) {
                        if(conditions.type_profil[key][id] == typeProfil.name_to_value_array.type_profil && id == typeProfil.name_to_value_array.id ){
                            conditions.type_profil[key][id] = typeProfil.name_to_value_array.type_profil;
                            check = true; 
                            return false;
                        } 
                    });
                    if(check) return false;
                });
                if(!check) conditions.type_profil.push({[typeProfil.name_to_value_array.id]: typeProfil.name_to_value_array.type_profil});
            }else{
                conditions.type_profil.push({[typeProfil.name_to_value_array.id]: typeProfil.name_to_value_array.type_profil});
            }
            FormulaireChamp.setListeConditions(conditions);
            $("#g-champ-form-conditions").val(JSON.stringify(conditions).utf8ToB64() );
        },

        /**
         * Fonction qui initialise le formulaire d'ajout et de modification des conditions 
         * 
         * @param {string} champ 
         * @param {string} operator 
         * @param {string} value 
         * @return {void} 
        */
        initFormCondition: function( champ, operator, value){

            
            if ( champ === undefined || champ === null ) champ = "";
            if ( operator === undefined || operator === null ) operator = "";
            if ( value === undefined || value === null ) value = "";

            // On récupere la liste des champs de la vue courante 
            var champs = this.getChampVueCourante();

            // Initialisation du select champ
            var champs_options = this.getChampOptionHtml( champs );
            $("#g-champ-form-condition-champ").empty();
            $("#g-champ-form-condition-champ").append( champs_options );

            // Initialisation du select champ
            var operateurs_options = this.getOperateurOptionHtml();
            $("#g-champ-form-condition-operateur").empty();
            $("#g-champ-form-condition-operateur").append( operateurs_options );

            // On initilise le formulaire avec les valeurs
            $(`#g-champ-form-condition-champ option[value="${champ}"]`).prop("selected", "selected");
            $(`#g-champ-form-condition-operateur option[value="${operator}"]`).prop("selected", "selected");
            $("#g-champ-form-condition-value").val(value);

            $("#g-champ-form-condition-champ-old").val(champ), 
            $("#g-champ-form-condition-operateur-old").val(operator),
            $("#g-champ-form-condition-value-old").val(value),

            // On initialise le click sur le bouton " Fermer formulaire "
            this.setClickBackListeBtn();

            // On vérifie si il s'agit d'une création ou d'une modification
            var creation = ( champ.isEmpty() && operator.isEmpty() && value.isEmpty() ) ? true : false;
            ( creation ) ? $("#g-champ-form-condition-add-btn").show() : $("#form-g-champ-form-condition-btn").hide();
            ( creation ) ? $("#g-champ-form-condition-update-btn").hide() : $("#g-champ-form-condition-update-btn").show();
            ( creation ) ? $("#g-champ-form-condition-save-btn").val("Ajouter") : $("#g-champ-form-condition-save-btn").val("Modifier");
            
            // On initialise le click sur le bouton " Ajouter " / " Modifier "
            this.setSaveCondition();
       
        },

        getOperateurOptionHtml: function(){
            var options_html = '<option></option>';
            options_html    += '<option value="=">[ = ] est égal </option>';
            options_html    += '<option value=">">[ > ] est supérieur strict</option>';
            options_html    += '<option value=">=">[ >= ] est supérieur égal </option>';
            options_html    += '<option value="<">[ < ] est inférieur strict</option>';
            options_html    += '<option value="<=">[ <= ] est inférieur égal </option>';
            return options_html;
        }, 

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
         setSaveCondition: function(){ 

            const self = this;

            Champ.hideVerification( $("#g-champ-form-condition-champ") );
            Champ.hideVerification( $("#g-champ-form-condition-operateur") );

            $("#g-champ-form-condition-save-btn").off().click(function(){ 

                var valid = true;
                // On récupere les valeurs du formulaire ( la condition )
                var condition = {
                    champ: $("#g-champ-form-condition-champ option:selected").val(), 
                    operator: $("#g-champ-form-condition-operateur option:selected").val(),
                    value: $("#g-champ-form-condition-value").val(),
                };

                // On vérifie le parametre champ si il est valide
               
                if ( condition.champ.isEmpty() ){
                    valid = false;
                    Champ.displayVerification( $("#g-champ-form-condition-champ") , "error", "Le champ est obligatoire" )
                } else {
                    Champ.hideVerification( $("#g-champ-form-condition-champ") );
                }
    
                // On vérifie le parametre operator si il est valide
                if ( condition.operator.isEmpty() ){
                    valid = false;
                    Champ.displayVerification( $("#g-champ-form-condition-operateur") , "error", "L'opérateur est obligatoire" )
                } else {
                    Champ.hideVerification( $("#g-champ-form-condition-operateur") );
                }

                // Si la condition est valide 
                if ( valid === true ) {

                    // On récupere les données de la condition à éditer 
                    var old_condition = {
                        champ: $("#g-champ-form-condition-champ-old").val(), 
                        operator: $("#g-champ-form-condition-operateur-old").val(),
                        value: $("#g-champ-form-condition-value-old").val(),
                    };

                    // vérifie si il s'agit de création ou d'une modification
                    if ( old_condition.champ.isEmpty() && old_condition.operator.isEmpty() ){
                        self.addCondition( condition );
                    }else{
                        self.updateCondition( old_condition, condition );
                    }
                    
                }
            });
        },

        // Retourne un array, la liste des champs dans le réferentiel
        getChampVueCourante: function(){
            var liste = [];
            $('[role="vue"]').each(function() {
                if ( $(this).css("display") !== "none" ) {
                    var vue_champs = $(this).find($('[role="list-champ"]'));
                    vue_champs.each(function() {
                        liste.push({ nom: $(this).attr("data-nom"), libelle: $(this).attr("data-libelle") });
                    });
                }
            });

            liste.sort(function(a, b) {
              var nomA = a.libelle.toLowerCase();
              var nomB = b.libelle.toLowerCase();
              if (nomA < nomB) {
                return -1;
              }
              if (nomA > nomB) {
                return 1;
              }
              return 0;
            });

            return liste;
        },

        // Retourne les options du select "Liste des champs" avec le nom comme value et libellé en text
        getChampOptionHtml: function( champs ){
            var champs_html = "<option></option>";
            if ( Object.getLength(champs) > 0 ) {
                champs.forEach(function(item) {
                    champs_html += `<option value="${item.nom}">${item.libelle} (${item.nom})</option>`;
                }); 
            }
            return champs_html;
        },

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
        setClickBackListeBtn: function(){ 
            $("#g-champ-form-condition-back-liste").off().click(function(){ 
                $("#g-champ-form-condition-liste").show();
                $("#g-champ-form-condition-formulaire").hide();
            });
        },

        /**
         * Fonction qui retourne une ligne avec le message "Aucune condition" en format html  
         * 
         * @return {string} 
         */
        getEmptyListElement: function(){
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucune condition </li>';
        },

        /**
         * Fonction qui retourne une ligne avec le message "Aucun type de profil" en format html  
         * 
         * @return {string} 
         */
        getEmptyListElementTypeProfil: function(){
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucun type de profil </li>';
        },


        /**
         * Fonction qui initialise le click sur le bouton " Supprimer une condition "
         * 
         * @return {void} 
         */
         setClickDeleteConditionBtn: function(){ 
            const self = this;
            $("[role=delete-condition]").each(function() {
                $(this).click(function(){ 
                    // On supprime la condition des parametres du champ
                    var deleted = self.deleteCondition({
                        champ: $( this ).attr( "data-champ" ),
                        operator: $( this ).attr( "data-operator" ),
                        value: $( this ).attr( "data-value" ),
                    });
                    if ( deleted ) {
                        var data = self.getConditions();
                        self.setListeConditions( data );
                        OdeAlertHelper.set( $(`#g-champ-form-message`) , "success",`Condition supprimée`);
                    }
                });
            });

            $("[role=delete-condition-type-profil]").each(function() {
                $(this).click(function(){ 
                    var data = FormulaireChamp.getConditions();
                    var check = false;
                    var idCheck = $(this).attr('data-type-profil');
                    $.each(data.type_profil, function(key, tab) {
                        $.each(tab, function(id, value) {
                            if(id == idCheck ){
                                data.type_profil.splice(key,1);
                                check = true; 
                                return false;
                            } 
                        });
                        if(check) return false;
                    });
                    $("#g-champ-form-conditions").val(JSON.stringify(data).utf8ToB64());
                    FormulaireChamp.setListeConditions( data );
                });
            });
        },

        /**
         * Fonction qui initialise le click sur le bouton " Supprimer une condition "
         * 
         * @return {void} 
         */
        setClickUpdateConditionBtn: function(){ 
            const self = this;
            $("[role=update-condition]").each(function() {
                $(this).click(function(){ 
                    self.initFormCondition($(this).attr("data-champ"), $(this).attr("data-operator"), $(this).attr("data-value"));
                    $("#g-champ-form-condition-liste").hide();
                    $("#g-champ-form-condition-formulaire").show();
                });
            });
        },

        /**
         * Fonction retourne les conditions au format HTML
         * 
         * @param {object} conditions Les conditions du champ
         * @return {string} conditions_html Les conditions du champ en format HTML
         */
        getListElement: function( conditions ){
            var conditions_html = "";
            conditions.forEach(function(condition) {

                conditions_html += `<li class="list-group-item d-flex justify-content-between align-items-center">`;
                conditions_html +=      `<div class="row">`;
                conditions_html +=          `<div class="col-md-9">`;
                conditions_html +=              `<p> <strong>Si</strong> ${condition.champ} <strong> ${condition.operator} </strong> ${condition.value} </p>`;
                conditions_html +=          `</div>`;
                conditions_html +=          `<div class="col-md-3">`;
                conditions_html +=              `<button role="delete-condition" data-champ="${condition.champ}" data-operator="${condition.operator}" data-value="${condition.value}" title="Supprimer la condition" class="badge" style=" background-color: #dc3545; padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-trash-alt"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=              `<button role="update-condition" data-champ="${condition.champ}" data-operator="${condition.operator}" data-value="${condition.value}" title="Modifier la condition" class="badge" style="background-color:#28a745;padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-edit"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=          `</div>`;
                conditions_html +=      `</div>`;
                conditions_html += `</li>`;
            });
            return conditions_html;
        },

        /**
         * Fonction retourne les conditions au format HTML
         * 
         * @param {object} conditions Les conditions du champ
         * @return {string} conditions_html Les conditions du champ en format HTML
         */
        getListElementTypeProfil: function( type_profil ){
            var conditions_html = "";
            type_profil.forEach(function(tab, key) {
                $.each(tab, function(id, value) {

                    conditions_html += `<li class="list-group-item d-flex justify-content-between align-items-center">`;
                    conditions_html +=      `<div class="row">`;
                    conditions_html +=          `<div class="col-md-9">`;
                    conditions_html +=              `<p> ${value} </p>`;
                    conditions_html +=          `</div>`;
                    conditions_html +=          `<div class="col-md-3">`;
                    conditions_html +=              `<button role="delete-condition-type-profil" data-type-profil="${id}" title="Supprimer le type de profil" class="badge" style=" background-color: #dc3545; padding: 5px 6px;border: none;">`;
                    conditions_html +=                  `<i class="fas fa-trash-alt"></i>`;
                    conditions_html +=              `</button>`;
                    conditions_html +=          `</div>`;
                    conditions_html +=      `</div>`;
                    conditions_html += `</li>`;
                });
            });
            return conditions_html;
        },

        /**
         * Fonction qui initialise le click sur le bouton " Editer une liste "
         * 
         * @return {void} 
         */
        setClickEditListe: function(){ 
            const self = this;
            $("#g-champ-form-edit-liste-btn").off().click(function(){ 
                self.initFormListe();
                $("#g-champ-form-liste").show();
                $("#g-champ-form-formulaire").hide();
            });
        },

        /**
         * Fonction qui initialise le formulaire de modification de la liste
         * 
         * @return {void} 
        */
        initFormListe: function(){
            
            const self = this;

            OdeLog.log( OdeLog.asAlert("initFormListe"), "Initialisation " );

            // On initialise le click sur le bouton " Ajouter une ligne dans la liste "
            this.setClickAddLigneListe();
            
            // On initilise le click sur le btn " Fermer editeur liste " 
            this.setClickCloseListe();

            // On initilise le click sur le btn " Modifer la liste " 
            this.setClickUpdateListe();

            // On récupere la liste du champ
            var params = this.getChampParams();
            var liste = ( params.hasOwnProperty("liste") ) ? params["liste"] : {};

            $("#g-champ-form-liste-liste").empty();
            if ( Object.getLength(liste) > 0 ) {
                var lignes = "";
                liste.forEach(function(option_libelle,option_value) {
                    if ( !option_value.isEmpty() ){
                        lignes += self.getLigneListe( option_value, option_libelle );
                    }
                });
                $("#g-champ-form-liste-liste").append($(lignes));
                this.initDeleteLigneListe();
            } else {
                var ligne_vide = this.getEmptyLigneListe();
                $("#g-champ-form-liste-liste").append($(ligne_vide))
            }

        },

        /**
         * Fonction qui initialise le click sur le bouton " Fermer L'éditeur de liste "
         * 
         * @return {void} 
        */
        setClickCloseListe: function(){
            $("#g-champ-form-liste-close").off().click(function(){ 
                $("#g-champ-form-liste").hide();
                $("#g-champ-form-formulaire").show();
            });
        },

        getLigneListe: function( cle, value ){
            
            var _cle = ( cle !== null && cle !== undefined ) ? cle : "";
            var _value = ( value !== null && value !== undefined ) ? value : "";

            var ligne =`<li class="list-group-item d-flex justify-content-between align-items-center">`;
            ligne    +=     `<div role="formulaire-liste-ligne" class="row">`;
            ligne    +=         `<div class="col-md-4">`;
            ligne    +=             `<input role="formulaire-liste-cle" type="text" placeholder="Clé" value="${_cle}" style="width: 100%;" >`;
            ligne    +=         `</div>`;
            ligne    +=         `<div class="col-md-7">`;
            ligne    +=             `<input role="formulaire-liste-value" type="text" placeholder="Value" value="${this.escapeHTML(_value)}"style="width: 95%;" >`;
            ligne    +=         `</div>`;
            ligne    +=         `<div class="col-md-1">`;
            ligne    +=             `<button role="formulaire-liste-delete" title="Supprimer la ligne" class="badge" style=" float: right;margin-top: 4px;background-color: #dc3545; padding: 5px 6px;border: none;">`;
            ligne    +=                 `<i class="fas fa-trash-alt"></i>`;
            ligne    +=             `</button>`;
            ligne    +=         `</div>`;
            ligne    +=     `</div>`;
            ligne    += `</li>`;   

            return ligne;    

        },

        escapeHTML: function(value){
            var entityMap = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#39;',
                '/': '&#x2F;',
                '`': '&#x60;',
                '=': '&#x3D;',
                '\\': '\\\\',
                '\t': '      '
            };

            return String(value).replace(/[&<>"'`=\/\\\t]/g, function(s){
                return entityMap[s];
            });
        },
        
       /**
         * Fonction qui initialise le "add" ligne dans liste
         * 
         * @return {void} 
        */
        setClickAddLigneListe: function(){
           
            const self = this;
            $("#g-champ-form-liste-add-btn").off().click(function(){ 
                
                let ligne = self.getLigneListe( null, null);
                 
                if ( $(`#g-champ-form-liste-liste`).find($("[role=formulaire-liste-ligne]")).length > 0 ){
                    $(`#g-champ-form-liste-liste`).append($(ligne));
                } else {
                    $(`#g-champ-form-liste-liste`).empty();
                    $(`#g-champ-form-liste-liste`).append($(ligne));
                }
               /* */
                self.initDeleteLigneListe();
                  
            });
          
        },

        getEmptyLigneListe: function() {
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucun élement </li>';
        },
 
        initDeleteLigneListe: function(){
            $("[role=formulaire-liste-delete]").each(function() {
                $(this).off().click(function(){ 
                    $(this).parent().parent().parent().remove();
                });
            });
        },

        /**
         * Fonction qui initialise l'event click sur le bouton "Modifier liste"
         * 
         * @return {void} 
        */
        setClickUpdateListe: function(){
            const self = this;
            $("#g-champ-form-liste-update-btn").off().click(function(){ 
                var elements = {};
                var lignes = $(`#g-champ-form-liste-liste`).find($("[role=formulaire-liste-ligne]"));
                if ( lignes !== undefined && lignes.length > 0 ){
                    lignes.each(function() {
                        var input_cle = $(this).find($("[role=formulaire-liste-cle]"));
                        var input_value = $(this).find($("[role=formulaire-liste-value]"));
                        if ( input_cle !== undefined && input_value !== undefined ){
                            if ( !input_cle.val().isEmpty() ){
                                elements[input_cle.val()] = input_value.val();
                            }
                        }
                    });
                }
                self.setListe(elements);
                self.setChampListe();
                var default_value = self.getChampDefautList();
                self.setChampDefautList( default_value );
                OdeAlertHelper.set( $(`#g-champ-form-message`), "success",`La liste a bien été modifiée`);
                $("#g-champ-form-liste-close").click();
                
            });
        },
        /**
         * Fonction qui supprime 
         * 
         * @return {void} 
         */

        setDataField: function( field, field_name, field_value ){
          
            var field_tag = field.get(0).tagName;
            var field_type = field.attr("type");
            var params = ($("#g-champ-form-params").val() !== "")?JSON.parse( atob( $("#g-champ-form-params").val() ) ):undefined;

            if(field_name == 'defaut' && field_tag == 'SELECT'){
                this.setChampDefaut( field );
            }else if ( field_tag === "INPUT" ){
               
                if ( field_type === "text" )
                {
                    if(field_name == 'mask' && params !== undefined)
                    {
                        ( params.mask !== undefined ) ? field.val(params.mask) : field.val("");
                    }
                    // #4221 - Implémentation de la surchage | Support du champ Données Financières.
                    else if(field_name == 'tableau_existe_comptable' && params !== undefined){
                        ( params.tableau_existe_comptable !== undefined ) ? field.val(decodeURIComponent(escape(atob(params.tableau_existe_comptable)))) : field.val("");
                    }
                    else if(field_name == 'defaut-champ' && field_value !== undefined ){
                         (field_value !== null ) ? field.val(decodeURIComponent(escape(field_value))) : field.val("");
                    }
                    else
                    {
                        ( field_value !== null ) ? field.val(field_value) : field.val("");
                    }
                } else if ( field_type === "checkbox" ) {
                    if ( field_name === "multiple" ){ 
                        ( this.getMultipleValue() == "1" ) ? field.prop("checked","checked") : field.removeAttr("checked");
                    } else if(field_name === "decimal" && params !== undefined){
                        ( params.decimal !== null && params.decimal == "1") ? field.prop("checked","checked") : field.removeAttr("checked");
                    }else{
                        ( field_value !== null && field_value == "1") ? field.prop("checked","checked") : field.removeAttr("checked");
                    }
                } else if ( field_type === "number" ) { 
                    if(field_name == 'minimum' && params !== undefined){
                        ( params.minimum !== undefined ) ? field.val(params.minimum) : field.val("0");
                    }else if(field_name == 'maximum' && params !== undefined){
                        ( params.maximum !== undefined ) ? field.val(params.maximum) : field.val("0");
                    }
                    else{
                        ( field_value !== null ) ? field.val(field_value) : field.val("0");
                    }
                }else {
                    OdeLog.log( OdeLog.asAlert("Erreur"), "Type champ input non géré", field );
                }

            } else if ( field_tag === "SELECT" ){

                if ( field_name === "liste" ){
                        this.setChampListe();
                        ( this.isChampBasic() === true ) ? this.disableEditListe() : this.enableEditListe();
                } else if ( field_name === "defaut-champ" ){
                    ( field.attr("id") === "form-field-defaut-date" ) ? this.setChampDateDefaut( field_value ) : this.setChampDefautList( field_value );
                } else if ( field_name === "format" ){
                    ( field.attr("id") === "form-field-format" && params !== undefined  && params.format !== undefined ) ? this.setChampFormat( params.format ) : this.setChampFormat( 'entier' );
                }
                else if( field_name === "attache" ){
                    if($("#g-champ-form-params").val() === undefined || $("#g-champ-form-params").val() === ''){
                        var params_retour = { liste_attache: "type_attache" };
                        $("#g-champ-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }
                    this.setChampAttacheFile();
                }
                else if( field_name === "avis_impot" ){
                    if($("#g-champ-form-params").val() === undefined || $("#g-champ-form-params").val() === ''){
                        var params_retour = { liste_avis_impot: "avis_impot" };
                        $("#g-champ-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }else{
                        var params_retour = JSON.parse( atob( $("#g-champ-form-params").val() ) );
                        if(params_retour.liste_avis_impot === undefined || params_retour.avis_impot === ''){
                            params_retour.liste_avis_impot = "avis_impot";
                        }
                        $("#g-champ-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }
                    this.setChampAvisImpot();
                }
                else if( field_name === "avis_impot_condition" ){
                    if($("#g-champ-form-params").val() === undefined || $("#g-champ-form-params").val() === ''){
                        var params_retour = { liste_avis_impot: "avis_impot" };
                        $("#g-champ-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }
                    this.setChampAvisImpotCondition();
                }
                else if( field_name === "liste_referentiel" ){
                    if (typeof params !== 'undefined' && params !== null) {
                        if (params.hasOwnProperty('liste_referentiel') && params.liste_referentiel.length > 0) {
                            $('#form-field-liste-referentiel').val(params.liste_referentiel);
                        }
                    }else{
                        $('#form-field-liste-referentiel').val();
                    }   
                }
                else if( field_name === "grille_tarifaire" ){
                    if (typeof params !== 'undefined' && params !== null) {
                        if (params.hasOwnProperty('grille_tarifaire') && params.grille_tarifaire.length > 0) {
                            $('#form-field-grille-tarifaire').val(params.grille_tarifaire);
                        }
                    }else{
                        $('#form-field-liste-referentiel').val();
                    }   
                }
                else if( field_name === "fonction" ){
                    if (typeof params !== 'undefined' && params !== null) {
                        if (params.hasOwnProperty('fonction') && params.fonction.length > 0) {
                            $('#form-field-liste-fonction').val(params.fonction);
                        }
                    }else{
                        $('#form-field-liste-referentiel').val();
                    }   
                }
                else if( field_name === "api_r2p" ){
                    if($("#g-champ-form-params").val() === undefined || $("#g-champ-form-params").val() === ''){
                        var params_retour = { liste_api_r2p: "api_r2p" };
                        $("#g-champ-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }else{
                        var params_retour = JSON.parse( atob( $("#g-champ-form-params").val() ) );
                        if(params_retour.liste_api_r2p === undefined || params_retour.api_r2p === ''){
                            params_retour.liste_api_r2p = "api_r2p";
                        }
                        $("#g-champ-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }
                    this.setChampApiR2p();
                }

                // #4221 - Implémentation de la surchage | Support du champ Données Financières.
                else if ( field_name === "type_donnee_comptable" ){
                    ( field.attr("id") === "form-field-type-donnee-comptable" && params !== undefined  && params.type_donnee_comptable !== undefined ) ? this.setChampTypeDonneeComptable( params.type_donnee_comptable ) : this.setChampTypeDonneeComptable( '' );
                }
                else if ( field_name === "annee_comptable" ){
                    ( field.attr("id") === "form-field-annee-comptable" && params !== undefined  && params.annee_comptable !== undefined ) ? this.setChampAnneeComptable( params.annee_comptable ) : this.setChampAnneeComptable( '' );
                }

                else {
                    OdeLog.log( OdeLog.asAlert("Erreur"), "param champ non géré", field );
                }

            } 
            else if(field_tag === "TEXTAREA"){
                if(field_name === "tableau_param" && params !== undefined){
                    ( params.tableau_param !== undefined ) ? field.text(params.tableau_param) : field.text("");
                }
                else if(field_name == 'formule_calcul')
                {
                    ( params !== undefined && params.formule_calcul !== undefined ) ? field.val(params.formule_calcul) : field.val("");
                }
                else if(field_name == 'parametre_fonction')
                {
                    ( params !== undefined && params.parametre_fonction !== undefined ) ? field.val(params.parametre_fonction) : field.val("");
                }
                else{
                    ( field_value !== null ) ? field.text(field_value) : field.text("");
                }
            }else {
                OdeLog.log( OdeLog.asAlert("Erreur"), "Tag champ non géré", field );
            }
        },

        getChampDefautList: function( id ){
            return $(`#${id} option:selected`).val();
        },

        getChampMulti: function ( id ){
            var values = $(`#${id}`).val();
            var selected = '';
            if(values.length > 0){
                $.each(values, function(index, value){
                    if(index+1 == values.length){
                        selected += value;
                    }else{
                        selected += value+',';
                    }
                });
            }
            return selected;
        },

        setChampListe: function(){
            var liste_options = this.getOptionsListeChamp( null );
            $("#form-field-liste").empty();
            $("#form-field-liste").append($(liste_options));
        },

        setChampAttacheFile: function(){
            var params = JSON.parse( atob( $("#g-champ-form-params").val() ) );
            var liste_options = this.getOptionsListeChamp( params.attache, 'attache' );
            $("#form-field-attache-file").empty();
            $("#form-field-attache-file").append($(liste_options));
        },

        setChampAvisImpot: function(){
            var params = JSON.parse( atob( $("#g-champ-form-params").val() ) );
            var liste_options = this.getOptionsListeChamp( params.avis_impot, 'api_particulier' );
            liste_options = liste_options.replace('<option></option>','');
            $("#form-field-avis-impot").empty();
            $("#form-field-avis-impot").append($(liste_options));
        },

        setChampAvisImpotCondition: function(){
            var params = JSON.parse( atob( $("#g-champ-form-params").val() ) );
            var liste_options = this.getOptionsListeChamp( params.avis_impot_condition, 'api_particulier' );
            $("#form-field-avis-impot-condition").empty();
            $("#form-field-avis-impot-condition").append($(liste_options));
        },

        setChampApiR2p: function(){
            var params = JSON.parse( atob( $("#g-champ-form-params").val() ) );
            var liste_options = this.getOptionsListeChamp( params.api_r2p, 'api_r2p' );
            liste_options = liste_options.replace('<option></option>','');
            $("#form-field-api-r2p").empty();
            $("#form-field-api-r2p").append($(liste_options));
        },

        // #4221 - Implémentation de la surchage | Support du champ Données Financières.
        setChampTypeDonneeComptable: function( value ){
            var options = $("#form-field-type-donnee-comptable").find("option");
            options.each(function() {
                ( $(this).val() === value ) ? $(this).prop('selected', true) : $(this).removeAttr("selected");
            });
        },

        setChampAnneeComptable: function( value ){
            var options = $("#form-field-annee-comptable").find("option");
            options.each(function() {
                ( $(this).val() === value ) ? $(this).prop('selected', true) : $(this).removeAttr("selected");
            });
        },


        setChampDateDefaut: function( value ){
            var options = $("#form-field-defaut-date").find("option");
            options.each(function() {
                ( $(this).val() === value ) ? $(this).prop('selected', true) : $(this).removeAttr("selected");
            });
        },

        setChampFormat: function( value ){
            var options = $("#form-field-format").find("option");
            options.each(function() {
                ( $(this).val() === value ) ? $(this).prop('selected', true) : $(this).removeAttr("selected");
            });
        },

        setChampDefautList: function( value ){
            var defaut_options = this.getOptionsListeChamp( value );
            $("#form-field-defaut-liste").empty();
            $("#form-field-defaut-liste").append($(defaut_options))
        },

        setChampDefaut: function( field ){
            $('#form-field-defaut').val('');
            $('#select_defaut_OPS_individu').val('');
            $('#select_defaut_OPS_personne_morale').val('');

            var champ = $('#'+$("#g-champ-form-id").val()).attr('data-defaut');

            if(champ){
                try {
                    var defautValues = JSON.parse(atob(champ));
                } catch (error) {
                    console.log("Le champ n'est pas un JSON.");
                }
            }

            if(defautValues){
                $('#form-field-defaut').val(defautValues.defaut);
                if(defautValues.defaut == 'demandeur' || defautValues.defaut == 'beneficiaire'){
                    $('#select_defaut_OPS_individu').val(defautValues.defaut_value);
                    $('#select_defaut_OPS_individu').show();
                    $('#select_defaut_OPS_personne_morale').hide();
                    $('[data-role-defaut]').hide();
                    $('#form-field-defaut-url').hide();
                }else if(defautValues.defaut == 'profil'){
                    $('#select_defaut_OPS_personne_morale').val(defautValues.defaut_value);
                    $('#select_defaut_OPS_personne_morale').show();
                    $('#select_defaut_OPS_individu').hide();
                    $('[data-role-defaut]').hide();
                    $('#form-field-defaut-url').hide();
                }else if(defautValues.defaut == 'autre'){
                    $('#form-field-defaut-url').hide();
                    $('#select_defaut_OPS_individu').hide();
                    $('#select_defaut_OPS_personne_morale').hide();
                    $('[data-role-defaut]').hide();
                    $('[data-role-defaut]').each(function() {
                        if($(this).attr("data-role-defaut").includes($("#g-champ-form-type").val())){
                            let field_name = ( $(this).attr("data-name") !== undefined && $(`#${$(this).attr("data-name")}`) !== undefined ) ? $(`#${$(this).attr("data-name")}`).attr("data-name")  : false ;
                            if (  field_name !== false ){
                                $(this).val(FormulaireChamp.setDataField($(`#${$(this).attr("data-name")}`),field_name,defautValues.defaut_value));
                            }
                            $(this).show();
                        }
                    });
                }
                else if(defautValues.defaut == 'url'){
                    $('#select_defaut_OPS_individu').hide();
                    $('#select_defaut_OPS_personne_morale').hide();
                    $('[data-role-defaut]').hide();
                    $('#form-field-defaut-url').val(defautValues.defaut_value);
                    $('#form-field-defaut-url').show();
                    $('[data-role-defaut=url]').show();
                }
            }else{
                $('#select_defaut_OPS_individu').hide();
                $('#select_defaut_OPS_personne_morale').hide();
                $('[data-role-defaut]').hide();
                $('#form-field-defaut-url').hide();
            }
        },

        getChampDefaut: function( field ){
            var champDefaut = {};
            champDefaut.defaut = $(field).val();

            if($(field).val() == 'demandeur' || $(field).val() == 'beneficiaire'){
                champDefaut.defaut_value = $('#select_defaut_OPS_individu').val();
            }else if($(field).val() == 'profil'){
                champDefaut.defaut_value = $('#select_defaut_OPS_personne_morale').val();
            }else if($(field).val() == 'autre'){
                $('[data-role-defaut]').each(function() {
                    if($(this).attr("data-role-defaut").includes($("#g-champ-form-type").val())){
                    let field_name = ( $(this).attr("data-name") !== undefined && $(`#${$(this).attr("data-name")}`) !== undefined ) ? $(`#${$(this).attr("data-name")}`).attr("data-name")  : false ;
                        if (  field_name !== false ){
                            champDefaut.defaut_value = FormulaireChamp.getDataField($(`#${$(this).attr("data-name")}`),field_name);
                        }   
                    }
                });
            }else if($(field).val() == 'url'){
                champDefaut.defaut_value = $('#form-field-defaut-url').val();
            }

            return btoa(JSON.stringify(champDefaut));
        },

        isChampBasic: function(){
            return ( $("#g-champ-form-description").val() === "basic" ) ? true : false;
        },

        enableEditListe: function(){
           $("#g-champ-form-edit-liste-btn").css("color","#f08377");
           $("#g-champ-form-edit-liste-btn").css("cursor","pointer");
           Router.setClickRoutes();
        },

        disableEditListe: function(){
           $("#g-champ-form-edit-liste-btn").css("color","#959393");
           $("#g-champ-form-edit-liste-btn").css("cursor","initial");
           $("#g-champ-form-edit-liste-btn").off();
        },

        getOptionsListeChamp: function ( value, type = null ){
            var params = this.getChampParams(type);
            if( type == 'attache' ){
                var liste = params.liste;
            }else{
                var liste = ( params.hasOwnProperty("liste") ) ? params["liste"] : {};
            }
            
            var options = "<option></option>";
            if ( Object.getLength(liste) > 0 ) {
                liste.forEach(function(option_libelle,option_value) {
                    if ( !option_value.isEmpty() ){
                        if ( value === option_value
                            || ( value != null && value.indexOf(option_value) != -1  && (type == 'mime' || type == 'api_particulier' || type == 'api_r2p') ) ){
                            options += `<option value="${option_value}" selected="selected" >${option_libelle}</option>`
                        } else {
                            options += `<option value="${option_value}" >${option_libelle}</option>`
                        }
                    }
                });
            }
            return options;
        },

        setListe: function(elements){
            if ( typeof elements === "object" && Object.getLength(elements) > 0 ){
                var params = this.getChampParams();
                params.liste = elements;
                $("#g-champ-form-params").val( JSON.stringify(params).utf8ToB64() )
            }
        },

        // On ajoute une condition au champ
        addCondition: function ( condition ){
            var data = this.getConditions();
            OdeLog.log( OdeLog.asSuccess("data"), data );
            if ( this.isConditionValid( condition, data.conditions) ) {
                data.conditions.push(condition);
                $("#g-champ-form-conditions").val(JSON.stringify(data).utf8ToB64() );
                OdeLog.log( OdeLog.asSuccess("addCondition :: conditions "), $("#g-champ-form-conditions") );
                this.setListeConditions( data );
                $("#g-champ-form-condition-liste").show();
                $("#g-champ-form-condition-formulaire").hide();
                OdeAlertHelper.set( $(`#g-champ-form-message`) , "success",`La condition a bien été ajoutée`);
            } else {
                OdeAlertHelper.set( $(`#g-champ-form-message`) , "warning",`Cette condition existe deja sur le champ`);
            }
        },

        // On edit une condition
        setListeConditions: function ( conditions ){
            // On initialise la liste des conditions avec le message " Aucune condition "
            var liste_element_html = this.getEmptyListElement();
            // On ajoute les conditions à la liste 
            if ( Object.getLength(conditions.conditions ) > 0){
                liste_element_html = this.getListElement( conditions.conditions );
            }
            $("#g-champ-form-condition-form-liste").empty();
            $("#g-champ-form-condition-form-liste").append(liste_element_html);

            var liste_element_type_profil_html = this.getEmptyListElementTypeProfil();
            // On ajoute les types de profil à la liste 
            if(!Array.isArray(conditions.type_profil)) conditions.type_profil = [];
            if ( conditions.type_profil && Object.getLength(conditions.type_profil ) > 0){
                liste_element_type_profil_html = this.getListElementTypeProfil( conditions.type_profil );
            }
            $("#g-champ-form-condition-type-profil-form-liste").empty();
            $("#g-champ-form-condition-type-profil-form-liste").append(liste_element_type_profil_html);
            
            // On initilise le click sur les boutons " Supprimer une condition "
            this.setClickDeleteConditionBtn();

            // On initilise le click sur les boutons " Modifier une condition "
            this.setClickUpdateConditionBtn();
            var champ_id = this.getChampId();
            if ( !champ_id.isEmpty() ) {
                nbCondition = Object.getLength(conditions.conditions) + Object.getLength(conditions.type_profil);
                this.displayIconeConditions( champ_id, nbCondition );
            }
        },

        displayIconeConditions: function ( champ_id, nb ){
            $(`#${champ_id}`).find('[role="display-conditions"]').empty();
            if ( typeof nb === "number" && nb > 0 ) {
                var icone_html = `<i style="margin-left: 8px;color: #f08377;cursor: help;" title="${nb} condition(s)" class="fas fa-filter"></i>`;
                icone_html +=`<span style="top: 1px;position: relative;margin-left: -1px;color: #f08377;font-size: 11px;font-weight: bold;">${nb}</span>`;
                $(`#${champ_id}`).find('[role="display-conditions"]').append( icone_html );
            }
        },

        setIconeConditions: function() {
            const self = this;
            $("[role=list-champ]").each(function() {
                if ( $(this).hasClass("list-champ-dropped") ) {
                    if ( !$(this).attr("data-conditions").isEmpty() ) {
                        var data_conditions = JSON.parse($(this).attr("data-conditions").b64ToUtf8());  
                        if ( data_conditions.hasOwnProperty("conditions") && !data_conditions.hasOwnProperty("type_profil")){
                            nbCondition = Object.getLength(data_conditions.conditions);
                            self.displayIconeConditions( $(this).attr("id") , nbCondition );
                        }else if(data_conditions.hasOwnProperty("conditions") && data_conditions.hasOwnProperty("type_profil")){
                            nbCondition = Object.getLength(data_conditions.conditions) + Object.getLength(data_conditions.type_profil);
                            self.displayIconeConditions( $(this).attr("id") , nbCondition );
                        }
                    }
            
                }
            });
        },

        // On edit une condition
        updateCondition: function ( old_condition, new_condition ){

            var updated = false;
            var data = this.getConditions();
            if ( !this.isConditionValid( new_condition, data.conditions) || !this.isEgalCondition(new_condition,old_condition) ) {
                var new_conditions = [];
                data.conditions.forEach(function(element) {
                    if ( element.champ === old_condition.champ && element.operator === old_condition.operator && element.value === old_condition.value ){
                        new_conditions.push(new_condition);
                        updated = true;
                    }else{
                        new_conditions.push(element);
                    }
                });
                data.conditions = new_conditions;
                $("#g-champ-form-conditions").val( JSON.stringify(data).utf8ToB64() );

                this.setListeConditions( data );
            } else {
                updated = true;
            }

            // Redirection + message 
            if ( updated ){
                $("#g-champ-form-condition-liste").show();
                $("#g-champ-form-condition-formulaire").hide();
                OdeAlertHelper.set( $(`#g-champ-form-message`) , "success",`La condition a bien été modifiée`);
            } else {
                OdeAlertHelper.set( $(`#g-champ-form-message`) , "warning",`Erreur de modification de la condition`);
            } 

        },

        isEgalCondition:function (condition_1, condition_2){
            return ( condition_1.champ === condition_2.champ && condition_1.operator === condition_2.operator && condition_1.value === condition_2.value  ) ? true : false;
        },

        isConditionValid:function (condition, conditions){
            if ( Object.getLength(conditions) === 0 ) return true;
            var exist = false;
            conditions.forEach(function(_condition) {
                if ( _condition.champ === condition.champ ){
                    if ( _condition.operator === condition.operator ){
                        if ( _condition.value === condition.value ){
                            exist = true;
                        }
                    }
                }
            });
            return ( exist === false ) ? true : false;
        },

        // On supprime une condition au champ
        deleteCondition: function ( condition ){
            var data = this.getConditions();
            var new_conditions = [];
            var old_conditions = [];
            data.conditions.forEach(function(element) {
                if ( element.champ === condition.champ ){
                    if ( element.operator === condition.operator ){
                        if ( element.value !== condition.value ){
                            new_conditions.push(element);
                        }
                    }else{
                        new_conditions.push(element);
                    }
                }else{
                    new_conditions.push(element);
                }
            });
            var old_conditions = data.conditions;
            data.conditions = new_conditions;
            $("#g-champ-form-conditions").val( JSON.stringify(data).utf8ToB64() );
            return ( Object.getLength(old_conditions) !== Object.getLength(new_conditions) ) ? true : false;
        },

        // Retourne un array des conditions du champ
        getConditions: function (){
            var conditions = { verified: "all",  visible: 1, modifiable: 1, conditions: [], type_profil: [] };
            var conditions_encoded = $("#g-champ-form-conditions").val();
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                var conditions = JSON.parse(conditions_encoded.b64ToUtf8());  
            }
            return conditions;
        },

        initBtnWysiwyg: function(verif){
            if(verif){
                $('#form-field-defaut-note_btn').click(function(){
                    if($('#wysiwyg-note_parent').length > 0){
                        $(tinymce.get(0)).get(0).remove();
                    }
                    wysiwyg('wysiwyg-note');
                    if($('#form-field-defaut-note').text()){
                        setTimeout( function(){tinyMCE.get(0).setContent( decodeURIComponent(escape(window.atob($('#form-field-defaut-note').text()))) )}, 330);
                    }else{
                        tinyMCE.get(0).setContent('');
                    }
                    $('#modal-note').modal();
                });
            }else{
                $('#form-field-defaut-note_btn').off();
            }
        },

        valideNote: function(){
            var cont = tinyMCE.get(0).getContent();
            cont = window.btoa(unescape(encodeURIComponent(cont.trim())));
            $('#form-field-defaut-note').text(cont);
            $('#modal-note').modal('toggle');
        },
        
        initBtnTableau: function(verif){
            if(verif){
                $('#form-field-param-tableau_btn').off().click(function(){
                    $("#ongletLigne").parent().addClass("active");
                    $("#ongletColonne").parent().removeClass("active");
                    $("#contenuLigne").addClass("active in");
                    $("#contenuColonne").removeClass("active in");
                    $('#ongletsTableau a').off().click(function (e) {
                        e.preventDefault();
                        $(this).tab('show');
                    });
                    $('#modal-tableau-body-ligne tbody').empty();
                    $('#modal-tableau-body-colonne tbody').empty();
                    $('#nombre-ligne-tableau').val('');
                    $('#ajout-ligne-tableau').prop('checked',false);
                    if($('#form-field-param-tableau').text() != '' && $('#form-field-param-tableau').text() !== undefined){
                        var params = JSON.parse(decodeURIComponent(escape(atob($('#form-field-param-tableau').text()))));
                        if(params === undefined && params != ''){
                            FormulaireChamp.addLigneTableau("ligne");
                            FormulaireChamp.addLigneTableau("colonne");
                        }else{
                            $.each(params.lignes, function(index,element){
                                FormulaireChamp.addLigneTableau("ligne");
                                $($('.tableau-ligne')[index]).find(".tableau-ligne-libelle").val(element);
                            });
                            $('#ajout-ligne-tableau').prop('checked',params.ajout_ligne);
                            $('#largeur-colonne-zero').val(params.largeur_colonne_zero);
                            $.each(params.colonnes, function(index,element){
                                FormulaireChamp.addLigneTableau("colonne");
                                $($('.tableau-colonne')[index]).find(".tableau-libelle").val(element.libelle);
                                $($('.tableau-colonne')[index]).find(".tableau-format").val(element.format);
                                $($('.tableau-colonne')[index]).find(".tableau-largeur").val(element.largeur);
                                if(element.obligatoire){
                                    $($('.tableau-colonne')[index]).find(".tableau-obligatoire").prop('checked',true);
                                }
                                if(element.format == 'nombre' || element.format == 'montant' || element.format == "calcul"){
                                    $($('.tableau-colonne')[index]).find(".tableau-calcul-visible").show();
                                    if(element.calcul){
                                        $($('.tableau-colonne')[index]).find(".tableau-calcul").prop('checked',true);
                                    }
                                    if(element.format == "calcul"){
                                        $($('.tableau-colonne')[index]).find(".tableau-format").siblings('.tableau-format-calcul').show();
                                        $($('.tableau-colonne')[index]).find(".tableau-format-calcul").val(element.format_calcul);
                                    }
                                }
                                else if(element.format == "liste_deroulante"){
                                    $($('.tableau-colonne')[index]).find(".tableau-format").siblings('.tableau-format-liste').show();
                                    $($('.tableau-colonne')[index]).find(".tableau-format-liste").val(element.format_liste);
                                }
                            });
                        }
                    }else{
                        FormulaireChamp.addLigneTableau("colonne");
                        FormulaireChamp.addLigneTableau("ligne");
                    }

                    $('[role=delete-colonne]').off().click(function(){
                        $(this).parent().parent().remove();
                        var num = 1;
                        $('.tableau-colonne').each(function(){
                            $(this).find(".num-colonne").text(num);
                            num++;
                        });
                    });
                    $('[role=delete-ligne]').off().click(function(){
                        $(this).parent().parent().remove();
                        var num = 1;
                        $('.tableau-ligne').each(function(){
                            $(this).find(".num-ligne").text(num);
                            num++;
                        });
                    });

                    $('#add-tableau-colonne').off().click(function(){
                        FormulaireChamp.addLigneTableau("colonne");
                        $('[role=delete-colonne]').off().click(function(){
                            $(this).parent().parent().remove();
                            var num = 1;
                            $('.tableau-colonne').each(function(){
                                $(this).find(".num-colonne").text(num);
                                num++;
                            });
                        });
                    });
                    $('#add-tableau-ligne').off().click(function(){
                        FormulaireChamp.addLigneTableau("ligne");
                        $('[role=delete-ligne]').off().click(function(){
                            $(this).parent().parent().remove();
                            var num = 1;
                            $('.tableau-ligne').each(function(){
                                $(this).find(".num-ligne").text(num);
                                num++;
                            });
                        });
                    });
                    $('#modal-tableau').modal();
                });
            }else{
                $('#form-field-param-tableau_btn').off();
            }
        },

        initSelectDefautReferentiel: function(){
            $('#form-field-defaut-liste option.valueReferentiel').remove();

            if($('#liste_valeur_referentiel').val() && $('#form-field-liste-referentiel').val()){
                var listeValeurReferentiel = JSON.parse(atob($('#liste_valeur_referentiel').val()));
                var selectElement = $('#form-field-defaut-liste');
                var valReferentiel = $('#form-field-liste-referentiel').val();
                var champ = $('#'+$("#g-champ-form-id").val()).attr('data-defaut');

                if(champ !== undefined && champ != 'undefined'){
                    var champDefaut = JSON.parse(atob(champ));
                }

                if(champDefaut && champDefaut['defaut'] == 'autre'){
                    $.each(listeValeurReferentiel[valReferentiel], function(key, value) {
                        if(champDefaut['defaut_value'] == key){
                            selectElement.append($('<option>', {
                                value: key,
                                text: value,
                                class: "valueReferentiel",
                                selected: "selected"
                            }));
                        }else{
                            selectElement.append($('<option>', {
                                value: key,
                                text: value,
                                class: "valueReferentiel",
                            }));
                        }
                    });
                }else{
                    $.each(listeValeurReferentiel[valReferentiel], function(key, value) {
                        selectElement.append($('<option>', {
                            value: key,
                            text: value,
                            class: "valueReferentiel",
                        }));
                    });
                }
            }

            $('#form-field-liste-referentiel').off().change(function(){
                if($('#liste_valeur_referentiel').val()){
                    $('#form-field-defaut-liste option.valueReferentiel').remove();
                    var listeValeurReferentiel = JSON.parse(atob($('#liste_valeur_referentiel').val()));
                    var selectElement = $('#form-field-defaut-liste');
                    var valReferentiel = $(this).val();

                    $.each(listeValeurReferentiel[valReferentiel], function(key, value) {
                        selectElement.append($('<option>', {
                            value: key,
                            text: value,
                            class: "valueReferentiel"
                        }));
                    });
                }
            });
        },

        addLigneTableau: function(tpl){

            if(tpl == "colonne"){
                var template = $('#template-colonne-tableau').html();
                $('#modal-tableau-body-colonne tbody').append(template);
                var num = 1;
                $('.tableau-colonne').each(function(){
                    $(this).find(".num-colonne").text(num);
                    num++;
                });
                $('.tableau-format').off().change(function(){
                    $(this).siblings('.tableau-format-calcul').hide();
                    $(this).siblings('.tableau-format-calcul').val('');
                    $(this).siblings('.tableau-format-liste').hide();
                    $(this).siblings('.tableau-format-liste').val('');
                    $(this).parent().parent().find('.tableau-calcul-visible').hide();
                    if($(this).val() == 'nombre' || $(this).val() == 'montant'){
                        $(this).parent().parent().find('.tableau-calcul-visible').show();
                    }
                    else if($(this).val() == 'liste_deroulante'){
                        $(this).siblings('.tableau-format-liste').show();
                    }else if($(this).val() == 'calcul'){
                        $(this).siblings('.tableau-format-calcul').show();
                        $(this).parent().parent().find('.tableau-calcul-visible').show();
                    }
                });
            }
            else if(tpl == "ligne"){
                var template = $('#template-ligne-tableau').html();
                $('#modal-tableau-body-ligne tbody').append(template);
                var num = 1;
                $('.tableau-ligne').each(function(){
                    $(this).find(".num-ligne").text(num);
                    num++;
                });
            }
        },

        valideTableau: function(){
            var params = {}
            params.lignes = {};
            params.colonnes = {};
            var index = 0; 
            $('.tableau-ligne').each(function() {
                params.lignes[index++] = $(this).find(".tableau-ligne-libelle").val();
            });
            params.ajout_ligne = $('#ajout-ligne-tableau').prop('checked');
            params.largeur_colonne_zero = $('#largeur-colonne-zero').val();
            index = 0; 
            $('.tableau-colonne').each(function() {
                var colonne = {};
                colonne.libelle = $(this).find(".tableau-libelle").val();
                colonne.format = $(this).find(".tableau-format").val();
                if($(this).find(".tableau-format").val() == "liste_deroulante"){
                    colonne.format_liste = $(this).find(".tableau-format-liste").val();
                }else if($(this).find(".tableau-format").val() == "calcul"){
                    colonne.format_calcul = $(this).find(".tableau-format-calcul").val();
                }
                colonne.largeur = $(this).find(".tableau-largeur").val();
                colonne.obligatoire = $(this).find(".tableau-obligatoire").prop('checked');
                colonne.calcul = $(this).find(".tableau-calcul").prop('checked');
                params.colonnes[index++] = colonne;
            });
            cont = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, params)) ) ) );
            $('#form-field-param-tableau').text(cont);
            $('#modal-tableau').modal('toggle');
        },

        cacheParametrePourFonction : function(){
            $(document).on("change", "#form-field-liste-fonction", function(){
                let fonction = $(this).val();
                if(fonction != "CalculAge") {
                    $("#form-field-parametre_fonction").parents("[role='form-field']").hide();
                    $("#form-field-parametre_fonction").val("");
                }
                else {
                    $("#form-field-parametre_fonction").parents("[role='form-field']").show();
                }
            })
        },

        // #4221 - Implémentation de la surchage | Support du champ Données Financières.
        initSelectDonneeComptable: function(){
            FormulaireChamp.updateSelectAnneeComptable();
            $('#form-field-type-donnee-comptable').off().change(function(){
                FormulaireChamp.updateSelectAnneeComptable();
                $('#form-field-annee-comptable').val('');
                $('#form-field-annee-comptable option[value=""]').show();                
            });
        },

        updateSelectAnneeComptable: function(){
            // Récupération de l'option sélectionnée
            var selectedDonneeComptable = $('#form-field-type-donnee-comptable').find(':selected');
            var selectAnneeComptable = $('#form-field-annee-comptable option');

            // Récupération des valeurs des attributs data-annee-min et data-annee-max de l'option sélectionnée
            var anneeMin = selectedDonneeComptable.data('annee-min');
            var anneeMax = selectedDonneeComptable.data('annee-max');
            var displayOption = false;

            selectAnneeComptable.hide();
            selectAnneeComptable.each(function(index){
                if($(this).val() === anneeMin){
                    displayOption = true;
                }

                if(displayOption) $(this).show();

                if($(this).val() === anneeMax) return false;
            });
        },

    }
})(jQuery,Champ);

function suppLigne(data){
    //Flag modification
    var vue = $(data).closest('[role=vue]');
    Section.flagModification($(vue).attr('id'));
    data.parentNode.remove();
}