<?php

namespace ODE\CustomBlock\modules;

/**
 * Classe BlockGeneric
 * pour que les classes définissant les blocks est une structure commune
 */
abstract class BlockGeneric {

    protected $infos;
    /**
     * getter pour récuperer les infos du block
     */
    abstract protected function getInfos();

    /**
     * récupérer les controllers de l'ensemble des éléments présent dans le block
     * dans un dossier
     * @param string $path = chemin des controllers de chaque elements dans le block
     * @return array d'objets 
     */
    protected function getControllersObjects($path){
        $phpControllers = [];
        $scanDir = scandir($path);
        if(!$scanDir) return [];
        $files = array_diff(scandir($path), array('.', '..'));
        foreach($files as $file){
            require_once($path . "/" . $file);            
            $classeName = str_replace(".php", "", $file);
            $supplement = new $classeName($smarty);
            $phpControllers[] = $supplement;
        }

        // trie en fonction de l'ordre
        usort($phpControllers, function($a,$b){
            
            $ordreA = method_exists($a,"getOrdre") ? $a->getOrdre() : 9999999;
            $ordreB = method_exists($b,"getOrdre") ? $b->getOrdre() : 9999999;

            if ($ordreA == $ordreB) {
                return 0;
            }
            return ($ordreA < $ordreB) ? -1 : 1;
        });

        return $phpControllers;
    }


    protected function getJsPath($path){
        $jsPath = array();
        $files = array_diff(scandir($path), array('.', '..'));
        if (is_array($files) && count($files) > 0) {
            foreach ($files as $file_name) {
                if (pathinfo($file_name, PATHINFO_EXTENSION) === 'js') {
                    $jsPath[] = $path . "/" . $file_name . "?=" . time();
                }
            }
        }
        return $jsPath;
    }

    protected function getCssPath($path){
        $jsPath = array();
        $files = array_diff(scandir($path), array('.', '..'));
        if (is_array($files) && count($files) > 0) {
            foreach ($files as $file_name) {
                if (pathinfo($file_name, PATHINFO_EXTENSION) === 'css') {
                    $jsPath[] = $path . "/" . $file_name;
                }
            }
        }
        return $jsPath;
    }

}