var RendreVisibleModifiableOngletAction = (function ($) {
	return {
		start: function () {

			$(document).ready(function () {
				var modele = RendreVisibleModifiableOngletAction.getModele();
				var onglets = RendreVisibleModifiableOngletAction.getOnglets();
				var vues = RendreVisibleModifiableOngletAction.getVues();

				RendreVisibleModifiableOngletAction.init(modele, onglets, vues);
				RendreVisibleModifiableOngletAction.initSauvegarde();

			});

		},

		//Récupération des modèles de dossier
		getModele: function () {
			var listeModele = $('#ext_valeur_1').val();
			return JSON.parse(window.atob(listeModele));
		},

		//Récupération des onglets de chaque vue
		getOnglets: function () {
			var listeOnlgets = $('#ext_valeur_4').val();
			return JSON.parse(window.atob(listeOnlgets));
		},

		//Récupération des vues de chaque modèle
		getVues: function () {
			var listeVue = $('#ext_valeur_3').val();
			return JSON.parse(window.atob(listeVue));
		},


		init: function (modele, onglets, vues) {

			//Récupérer les valeurs dans ext_valeur_text
			var ext_valeur_text = $('#ext_valeur_text');

			$(ext_valeur_text).val(String($(ext_valeur_text).val()).trim());
			if ($(ext_valeur_text).val() == '|') { $(ext_valeur_text).val(''); }
			if (String($(ext_valeur_text).val()).substr(-1) == '|') {
				new_ext_valeur_text = $(ext_valeur_text).val(String($(ext_valeur_text).val()).substr(0, -1));
				$(ext_valeur_text).val($(ext_valeur_text).val(new_ext_valeur_text));
			}
			var champs = ($(ext_valeur_text).val() == '') ? [] : ($(ext_valeur_text).val()).trim().split('|');

			var idModele = '';
			var idOngletCRM = '';
			var idOngletInternet = '';
			var idOngletPartenaire = '';
			var visible_crm = '';
			var modifiable_crm = '';
			var visible_internet = '';
			var modifiable_internet = '';
			var visible_partenaire = '';
			var modifiable_partenaire = '';

			$.each(champs, function (i, champ) {

				if (String(champ).substr(-1) == ';') {
					champ = (String(champ)).substr(0, -1);
				}


				if (String(champ).includes(';')) {
					champArray = String(champ).trim().split(';'); // Decoupe sur le séparateur ; [key;value]
					var field = champArray[0];
					var value = champArray[1];
				} else {
					var field = champ;
					var value = '';
				}

				switch (field) {
					case 'modele_dossier':
						idModele = value;
						break;
					case 'onglet_crm':
						idOngletCRM = value;;
						break;
					case 'onglet_internet':
						idOngletInternet = value;;
						break;
					case 'onglet_partenaire':
						idOngletPartenaire = value;;
						break;
					case 'visible_crm':
						visible_crm = value;
						break;
					case 'modifiable_crm':
						modifiable_crm = value;
						break;
					case 'visible_internet':
						visible_internet = value;
						break;
					case 'modifiable_internet':
						modifiable_internet = value;
						break;
					case 'visible_partenaire':
						visible_partenaire = value;
						break;
					case 'modifiable_partenaire':
						modifiable_partenaire = value;
						break;
				}
			});


			//Construction du div
			var divSelects = document.createElement('div');
			divSelects.id = 'modif_onglet';
			divSelects.setAttribute('style', 'display: flex; flex-direction: column; padding-left: 15px;');

			//Construction div modèle de dossier
			var divModele = document.createElement('div');
			divModele.setAttribute('style', 'display: flex; width: 35%; flex-direction: row; align-items: center; justify-content: space-between; margin-bottom: 1%;');

			var label = document.createElement('label');
			label.setAttribute('style', 'display: flex; width: 50%; font-size: 14px;');
			var textLabel = document.createTextNode('Modèle de dossier :');
			label.appendChild(textLabel);
			divModele.appendChild(label);

			//Construction du select modèle de dossier
			var select = document.createElement('select');
			$(select).attr('style', 'width: 75%;');
			$(select).attr('id', 'modele_dossier');
			var modele_selectionne = false;

			$default_option = $('<option value="" default="-1">--- Choisir un modèle de dossier ---</option>');
			$default_option.appendTo(select);



			//Remplissage du select modèle de dossier
			Object.keys(modele).map(function (key) {
				var optionModele = $("<option>").attr({
					'value': key,
					'id': key
				}).text(modele[key]);
				if (idModele == key) {
					modele_selectionne = true;
					optionModele.attr('selected', 'selected')
				}
				optionModele.appendTo(select);
			});

			divModele.appendChild(select);
			divSelects.appendChild(divModele);

			//Construction du titre CRM
			var div = document.createElement('div');
			$(div).html('<h4 style="" role="section_title">CRM<br/></h4><hr style="border-top: 1px solid black;margin: 0;width: 100%;"><br/>');
			divSelects.appendChild(div);

			//Construction div Onglet CRM
			var div = document.createElement('div');
			div.setAttribute('style', 'display: flex; width: 35%; flex-direction: row; align-items: center; justify-content: space-between; margin-bottom: 1%;');

			var label = document.createElement('label');
			label.setAttribute('style', 'display: flex; width: 50%; font-size: 14px;');
			var textLabel = document.createTextNode('Onglets à modifier :');
			label.appendChild(textLabel);
			div.appendChild(label);

			//Construction du select onglet CRM
			var selectCRM = document.createElement('select');
			$(selectCRM).attr('id', 'onglet_crm');
			$(selectCRM).attr('style', 'width: 75%; height:200px;');
			$(selectCRM).attr('size', '5');
			$(selectCRM).attr('multiple', 'multiple');
			div.appendChild(selectCRM);
			divSelects.appendChild(div);

			//Construction des variables visible/modifiable de CRM

			var div = document.createElement('div');
			div.setAttribute('style', 'display: flex; width: 75%; flex-direction: row; align-items: center; justify-content: space-between; margin-bottom: 1%;');

			var label = document.createElement('label');
			label.setAttribute('style', 'display: font-size: 14px;');
			var textLabel = document.createTextNode('Visible');
			label.appendChild(textLabel);
			div.appendChild(label);

			var inputVisibleCRM = document.createElement('input');
			$(inputVisibleCRM).attr('id', 'visible_crm');
			$(inputVisibleCRM).attr('type', 'checkbox');
			$(inputVisibleCRM).attr('class', 'checkbox');
			if (visible_crm != 'off') $(inputVisibleCRM).attr('checked', true);
			div.appendChild(inputVisibleCRM);

			var label = document.createElement('label');
			label.setAttribute('style', 'font-size: 14px;')
			var textLabel = document.createTextNode('Modifiable');
			label.appendChild(textLabel);
			div.appendChild(label);

			var inputModifiableCRM = document.createElement('input');
			$(inputModifiableCRM).attr('id', 'modifiable_crm');
			$(inputModifiableCRM).attr('type', 'checkbox');
			$(inputModifiableCRM).attr('class', 'checkbox');
			if (modifiable_crm != 'off') $(inputModifiableCRM).attr('checked', true);
			div.appendChild(inputModifiableCRM);

			divSelects.appendChild(div);

			//Construction du titre Internet
			var div = document.createElement('div');
			$(div).html('<h4 style="" role="section_title">Internet<br/></h4><hr style="border-top: 1px solid black;margin: 0;width: 100%;"><br/>');
			divSelects.appendChild(div);

			//Construction div Onglet Internet
			var div = document.createElement('div');
			div.setAttribute('style', 'display: flex; width: 35%; flex-direction: row; align-items: center; justify-content: space-between; margin-bottom: 1%;');

			var label = document.createElement('label');
			label.setAttribute('style', 'display: flex; width: 50%; font-size: 14px;');
			var textLabel = document.createTextNode('Onglets à modifier :');
			label.appendChild(textLabel);
			div.appendChild(label);

			//Construction du select onglet Internet
			var selectInternet = document.createElement('select');
			$(selectInternet).attr('id', 'onglet_internet');
			$(selectInternet).attr('style', 'width: 75%; height:200px;');
			$(selectInternet).attr('size', '5');
			$(selectInternet).attr('multiple', 'multiple');
			div.appendChild(selectInternet);
			divSelects.appendChild(div);

			//Construction des variables visible/modifiable de Internet

			var div = document.createElement('div');
			div.setAttribute('style', 'display: flex; width: 75%; flex-direction: row; align-items: center; justify-content: space-between; margin-bottom: 1%;');

			var label = document.createElement('label');
			label.setAttribute('style', 'font-size: 14px;');
			var textLabel = document.createTextNode('Visible');
			label.appendChild(textLabel);
			div.appendChild(label);

			var inputVisibleInternet = document.createElement('input');
			$(inputVisibleInternet).attr('id', 'visible_internet');
			$(inputVisibleInternet).attr('type', 'checkbox');
			$(inputVisibleInternet).attr('class', 'checkbox');
			if (visible_internet != 'off') $(inputVisibleInternet).attr('checked', true);
			div.appendChild(inputVisibleInternet);

			var label = document.createElement('label');
			label.setAttribute('style', 'font-size: 14px;');
			var textLabel = document.createTextNode('Modifiable');
			label.appendChild(textLabel);
			div.appendChild(label);

			var inputModifiableInternet = document.createElement('input');
			$(inputModifiableInternet).attr('id', 'modifiable_internet');
			$(inputModifiableInternet).attr('type', 'checkbox');
			$(inputModifiableInternet).attr('class', 'checkbox');
			if (modifiable_internet != 'off') $(inputModifiableInternet).attr('checked', true);
			div.appendChild(inputModifiableInternet);

			divSelects.appendChild(div);

			if (document.getElementById('partenaire_installed') != null) {
				//Construction du titre Partenaire
				var div = document.createElement('div');
				$(div).html('<h4 style="" role="section_title">Partenaire<br/></h4><hr style="border-top: 1px solid black;margin: 0;width: 100%;"><br/>');
				divSelects.appendChild(div);

				//Construction div Onglet Partenaire
				var div = document.createElement('div');
				div.setAttribute('style', 'display: flex; width: 35%; flex-direction: row; align-items: center; justify-content: space-between; margin-bottom: 1%;');

				var label = document.createElement('label');
				label.setAttribute('style', 'display: flex; width: 50%; font-size: 14px;');
				var textLabel = document.createTextNode('Onglets à modifier :');
				label.appendChild(textLabel);
				div.appendChild(label);

				//Construction du select onglet Partenaire
				var selectPartenaire = document.createElement('select');
				$(selectPartenaire).attr('id', 'onglet_partenaire');
				$(selectPartenaire).attr('style', 'width: 75%; height:200px;');
				$(selectPartenaire).attr('size', '5');
				$(selectPartenaire).attr('multiple', 'multiple');
				div.appendChild(selectPartenaire);
				divSelects.appendChild(div);

				//Construction des variables visible/modifiable de selectPartenaire

				var div = document.createElement('div');
				div.setAttribute('style', 'display: flex; width: 75%; flex-direction: row; align-items: center; justify-content: space-between; margin-bottom: 1%;');

				var label = document.createElement('label');
				label.setAttribute('style', 'font-size: 14px;');
				var textLabel = document.createTextNode('Visible');
				label.appendChild(textLabel);
				div.appendChild(label);

				var inputVisiblePartenaire = document.createElement('input');
				$(inputVisiblePartenaire).attr('id', 'visible_partenaire');
				$(inputVisiblePartenaire).attr('type', 'checkbox');
				$(inputVisiblePartenaire).attr('class', 'checkbox');
				if (visible_partenaire != 'off') $(inputVisiblePartenaire).attr('checked', true);
				div.appendChild(inputVisiblePartenaire);

				var label = document.createElement('label');
				label.setAttribute('style', 'font-size: 14px;');
				var textLabel = document.createTextNode('Modifiable');
				label.appendChild(textLabel);
				div.appendChild(label);

				var inputModifiablePartenaire = document.createElement('input');
				$(inputModifiablePartenaire).attr('id', 'modifiable_partenaire');
				$(inputModifiablePartenaire).attr('type', 'checkbox');
				$(inputModifiablePartenaire).attr('class', 'checkbox');
				if (modifiable_partenaire != 'off') $(inputModifiablePartenaire).attr('checked', true);
				div.appendChild(inputModifiablePartenaire);
			}

			divSelects.appendChild(div);

			first = document.getElementById("ext_valeur_1");
			document.getElementById("corps_fonction").insertBefore(divSelects, first);

			if (modele_selectionne) {

				//On remplie le select CRM
				selectCRM = $('#onglet_crm');
				selectCRM.append($("<option>").attr('value', '').text("--- Choisir un onglet ---"));

				Object.keys(vues[idModele]).map(function (vue) {
					if (vues[idModele][vue] == 'CRM') {

						Object.keys(onglets[vue]).map(function (onglet) {
							var option = $("<option>").attr({
								'value': onglet,
								'id': onglet
							}).text(onglets[vue][onglet]);
							if (idOngletCRM.includes(onglet)) {
								option.attr('selected', 'selected')
							}
							selectCRM.append(option);
						});
					}
				});

				//On remplie le select Internet
				selectInternet = $('#onglet_internet');
				selectInternet.append($("<option>").attr('value', '').text("--- Choisir un onglet ---"));

				Object.keys(vues[idModele]).map(function (vue) {
					if (vues[idModele][vue] == 'Internet') {

						Object.keys(onglets[vue]).map(function (onglet) {
							var option = $("<option>").attr({
								'value': onglet,
								'id': onglet
							}).text(onglets[vue][onglet]);
							if (idOngletInternet.includes(onglet)) {
								option.attr('selected', 'selected')
							}
							selectInternet.append(option);
						});
					}
				});

				if (document.getElementById('partenaire_installed') != null) {
					//On remplie le select Partenaire
					selectPartenaire = $('#onglet_partenaire');
					selectPartenaire.append($("<option>").attr('value','').text("--- Choisir un onglet ---"));

					Object.keys(vues[idModele]).map(function(vue){
						if (vues[idModele][vue] == 'Partenaire') {

							Object.keys(onglets[vue]).map(function(onglet){
								var option = $("<option>").attr({
								'value':onglet,
								'id':onglet
								}).text(onglets[vue][onglet]);
								if(idOngletPartenaire.includes(onglet)){
									option.attr('selected', 'selected')
								}
								selectPartenaire.append(option);
							});
						}
					});
				}
			}
		},

		initSauvegarde: function () {

			//Mise à jour des valeurs

			var view_fields = $('#corps_fonction  #modif_onglet');

			$.each(view_fields, function (i, field) {

				$(field).off().on('change', function (event) {

					var changing_field = $(event.target);
					var changing_id = changing_field.attr('id');
					var changing_val = $('#' + changing_id).val();

					event.preventDefault();

					//Dans le cas de la modification du modèle de dossier, on réinitialise les options des select onglet
					if (changing_id == 'modele_dossier') {

						var selectCRM = $('#onglet_crm');
						selectCRM.empty();
						selectCRM.val('');

						var selectInternet = $('#onglet_internet');
						selectInternet.empty();
						selectInternet.val('');

						if (document.getElementById('partenaire_installed') != null) {
							var selectPartenaire = $('#onglet_partenaire');
							selectPartenaire.empty();
							selectPartenaire.val('');
						}

						if (changing_val != '') {

							var onglets = RendreVisibleModifiableOngletAction.getOnglets();
							var vues = RendreVisibleModifiableOngletAction.getVues();

							//On réinitialise le select de CRM

							selectCRM.append($("<option>").attr('value', '').text("--- Choisir un onglet ---"));

							Object.keys(vues[changing_val]).map(function (vue) {
								if (vues[changing_val][vue] == 'CRM') {

									Object.keys(onglets[vue]).map(function (onglet) {
										var option = $("<option>").attr({
											'value': onglet,
											'id': onglet
										}).text(onglets[vue][onglet]);
										selectCRM.append(option);
									});
								}
							});

							//On réinitialise le select de Internet

							selectInternet.append($("<option>").attr('value', '').text("--- Choisir un onglet ---"));

							Object.keys(vues[changing_val]).map(function (vue) {
								if (vues[changing_val][vue] == 'Internet') {

									Object.keys(onglets[vue]).map(function (onglet) {
										var option = $("<option>").attr({
											'value': onglet,
											'id': onglet
										}).text(onglets[vue][onglet]);
										selectInternet.append(option);
									});
								}
							});

							if (document.getElementById('partenaire_installed') != null) {
								//On réinitialise le select de Partenaire
								selectPartenaire.append($("<option>").attr('value','').text("--- Choisir un onglet ---"));

								Object.keys(vues[changing_val]).map(function(vue){
									if (vues[changing_val][vue] == 'Partenaire') {

										Object.keys(onglets[vue]).map(function(onglet){
											var option = $("<option>").attr({
											'value':onglet,
											'id':onglet
											}).text(onglets[vue][onglet]);
											selectPartenaire.append(option);
										});
									}
								});
							}
						}
					}

					var champs = [];

					//On sauvegarde la valeur des variables checkbox

					//On récupère les id des checkbox cochées
					var checked = [];
					$('.checkbox:checked').each(function (j, checkbox) {
						checked.push($(checkbox).attr('id'));
					});

					//Si la checkbox est cochée => on sinon off
					$('#corps_fonction  #modif_onglet .checkbox').each(function (j, champ) {
						var current_id = $(champ).attr('id');
						var current_value = '';

						if (checked.includes(current_id)) {
							current_value = 'on';
						} else {
							current_value = 'off';
						}

						champs.push([current_id, current_value].join(';'));
					});

					//On sauvegarde la valeur des variables select
					$('#corps_fonction  #modif_onglet select').each(function (j, champ) {
						var current_id = $(champ).attr('id');
						var current_value = $('#' + current_id).val();

						if (current_value != '') {
							champs.push([current_id, current_value].join(';'));
						}
					});

					//On met toutes les valeurs mises à jour dans ext_valeur_text
					$('#ext_valeur_text').val(champs.join('|'));
				});
			});
		},
	}
})(jQuery);