var DemanderJustificatifAction = (function ($) {
    return {
        /**
         * Initialise le paramétrage de l'action "Demander justificatif".
         * Ajoute les titres "Internet" et "Partenaire" et réagence les champs "Type", "Obligatoire", "Partenaires" et "Commentaire".
         * @function
         */
        start: function (type_vue = 'edit') {
            if (type_vue == 'edit') {
                addToValidate('EditView', 'ext_valeur_1', 'text', true, 'Type');
                $('#ext_valeur_1').parent().parent().children(':first').append(' <span class="required">*</span>');
            }

            if (document.querySelector('div[field="ext_valeur_4"]') !== null) {
                var span_corps_fonction = document.getElementById('corps_fonction');

                // Ajout du titre "Internet" au début du paramétrage de l'action
                var internet_title = this.create_title('Internet');
                span_corps_fonction.appendChild(internet_title);

                // Création d'une div globale pour le bloc "Internet"
                var div_internet_line = document.createElement('div');
                div_internet_line.className = 'row ' + type_vue + '-view-row';

                // Déplacement du flag "Visible internet" dans le bloc "Internet"
                var div_visible_usager = document.querySelector('div[field="ext_valeur_4"]').parentElement;
                div_internet_line.appendChild(div_visible_usager);
                span_corps_fonction.appendChild(div_internet_line);

                // Ajout du titre "Partenaire" après la partie "Internet"
                var partenaireTitle = this.create_title('Partenaire');
                span_corps_fonction.appendChild(partenaireTitle);

                // Déplacement du bloc "Visible partenaire" et "Type partenaire" après le titre "Partenaire"
                var div_obligatoire_partenaire = document.querySelector('div[field="ext_valeur_5"]').parentElement.parentElement;
                span_corps_fonction.appendChild(div_obligatoire_partenaire);
            }
        },

        /**
         * Crée un élément de type div qui contient un titre (h4) et un séparateur (hr)
         * @param {string} name - Le texte du titre
         * @returns {HTMLDivElement} - L'élément créé
         */
        create_title: function (name) {
            var div_separator = document.createElement('div');
            var title = document.createElement('h4');
            var title_text = document.createTextNode(name);
            title.appendChild(title_text);
            div_separator.appendChild(title);
            var hr = document.createElement('hr');
            hr.style = 'border-top: 1px solid black;margin: 0;width: 100%;';
            div_separator.appendChild(hr);
            div_separator.appendChild(document.createElement('br'));

            return div_separator;
        }
    }
})(jQuery);