<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry'))
    define('sugarEntry', true);

class CreerDossierPourLeCompteDe
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action "Créer un dossier pour le compte de"
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'dossier';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action "Créer un dossier pour le compte de"
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Créer un dossier pour le compte de (Particulier)";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action "Créer un dossier pour le compte de"
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Créer un dossier pour le compte de";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {

        $data = $this->getDataEdition();

        $edit_tpl = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array('' => '- aucun -');

        foreach ($listReferentiel as $id => $ref) {
            if (!empty($ref->name)) {
                $tabReferentiel[$ref->id] = $ref->libelle . " (" . $ref->name . ")";
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=" . base64_encode(json_encode($liste_referentiel)) . ">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=" . base64_encode(json_encode($liste_champ)) . ">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=" . $this->action->ext_valeur_text . ">";
        $data['ext_valeur_6']['type']  = 'select';
        $data['ext_valeur_6']['label'] = 'Sélection du bénéficiaire <i aria-hidden="true" class="fa fa-info-circle info-tooltip" title="Le demandeur (clé = 0) ou une personne désignée dans le dossier (clé = 1)" data-avia-tooltip="Le demandeur (clé = 0) ou une personne désignée dans le dossier (clé = 1)"></i>';
        $data['ext_valeur_6']['form']  = '<select name="ext_valeur_6" id="ext_valeur_6" style="width: 75%;">'.$liste_referentiel.'</select>';

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach ($tabReferentielChamps as $ReferentielChamp) {
            if ("" != str_replace(" ", "", $ReferentielChamp)) {
                $tabReferentielChamp = explode(";", $ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if ("" != str_replace(" ", "", $nomChamp)) {
                    $choix = 'true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if ($choix == 'false') {
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {

        if (!empty($this->dossier) && !empty($this->action->ext_valeur_text)) {
            $objIndividu = BeanFactory::newBean('OPS_individu');


            $listeChamps = explode('|', $this->action->ext_valeur_text);
            $customChamp = json_decode(base64_decode($this->dossier->champs_custom));

            // dossier au compte de qui ?
            $objReferentielCompteDe = BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_6);
            $compteDe = "";
            if (!empty($this->dossier->{$objReferentielCompteDe->name})) {
                $compteDe = $this->dossier->{$objReferentielCompteDe->name};
            } else {
                $compteDe = $customChamp->{$objReferentielCompteDe->name};
            }

            // on part sur les valeurs 0 => pour le compte du demandeur, 1 => pour un tiers
            if($compteDe == "" && $compteDe != "0" && $compteDe != "1") return;
            

            // si c'est pour le demandeur on le met en tant que beneficiaire
            if($compteDe == "0"){
                $this->dossier->load_relationship("ops_individu_ops_dossier");
                $demandeurBean = reset($this->dossier->ops_individu_ops_dossier->getBeans()); // premier bean 
                $this->dossier->beneficiaire_id = $demandeurBean->id;
                $this->dossier->save();
                return;
            }


            // remplissage de l'individu 
            foreach ($listeChamps as $champs) {
                $champ = explode(';', $champs);
                $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);

                $value = null;
                // Récupération valeur du champ dans le dossier
                if (isset($this->dossier->{$objReferentiel->name}) && !empty($this->dossier->{$objReferentiel->name})) {
                    $value = $this->dossier->{$objReferentiel->name};
                } else {
                    $value = $customChamp->{$objReferentiel->name};
                }

                if ($objReferentiel->type == 'liste') {
                    $value = str_replace('^', '', $value);
                }

                // Adresse domiciliation
                if ($champ[0] == 'adresse_domiciliation') {
                    $value = html_entity_decode($value, ENT_NOQUOTES);

                    // Vérifie si la valeur est encodé en base 64
                    if (base64_encode(base64_decode($value, true)) === $value) {
                        $value = json_decode(base64_decode($value));

                        $objIndividu->primary_address_number = $value->numero;
                        $objIndividu->primary_address_street = $value->rue;
                        $objIndividu->primary_address_complement_batiment = $value->complement_batiment;
                        $objIndividu->primary_address_complement_lieu = $value->complement_lieu;
                        $objIndividu->primary_address_postalcode = $value->postcode;
                        $objIndividu->primary_address_city = $value->city;
                    }
                }
                // Adresse employeur
                else if ($champ[0] == 'adresse_employeur') {
                    $value = html_entity_decode($value, ENT_NOQUOTES);

                    // Vérifie si la valeur est encodé en base 64
                    if (base64_encode(base64_decode($value, true)) === $value) {
                        $value = json_decode(base64_decode($value));

                        $objIndividu->adresse_num = $value->numero;
                        $objIndividu->adresse_voie = $value->rue;
                        $objIndividu->adresse_complement_batiment = $value->complement_batiment;
                        $objIndividu->adresse_complement_lieu = $value->complement_lieu;
                        $objIndividu->address_postalcode = $value->postcode;
                        $objIndividu->address_city = $value->city;
                    }
                }
                // Autre champs
                else {
                    $objIndividu->{$champ[0]} = $value;
                }

            }

            // Check si l'individu existe déjà
            global $db;

            // pas de nom et prenom - fin
            if(empty($objIndividu->last_name) || empty($objIndividu->first_name)) {
                $GLOBALS['log']->fatal(print_r("Le prénom et le nom doivent être renseignés",true));
                $GLOBALS['log']->fatal(print_r(array(
                    "Prenom" => $objIndividu->first_name,
                    "Nom" =>  $objIndividu->last_name
                ),true));
                return;
            }


            // pas de mail ni aucun tel - fin
            if(empty($objIndividu->email1) &&  
                (empty($objIndividu->phone_mobile) && empty($objIndividu->phone_home) && empty($objIndividu->phone_work) && empty($objIndividu->phone_other))) {
                    $GLOBALS['log']->fatal(print_r("Aucun moyen de contact (Mail ou téléphone)",true));
                    return;
            }


            // normalisation nom et prenom
            $search = array('-','_',' ');
            $nomNormalise = str_replace($search, '', $objIndividu->last_name);
            $prenomNormalise = str_replace($search, '', $objIndividu->first_name);

            // verification de l'existante de l'individu
            $idIndividu = false;

            // par son mail
            if (!empty($objIndividu->email1)) {
                $queryMail = "SELECT ops_individu.id as id
                FROM ops_individu
                INNER JOIN email_addr_bean_rel ON email_addr_bean_rel.bean_id = ops_individu.id
                INNER JOIN email_addresses ON email_addresses.id = email_addr_bean_rel.email_address_id
                where ops_individu.deleted = 0 
                AND email_addresses.deleted = 0
                AND email_addresses.email_address = '" . $objIndividu->email1 . "'
                and (UPPER(TRIM(REPLACE( REPLACE( REPLACE( last_name, '_', ''), ' ', ''), '-', ''))) like '".$db->quote(strtoupper ( $nomNormalise ) ) ."') 
                and (UPPER(TRIM(REPLACE( REPLACE( REPLACE( first_name, '_', ''), ' ', ''), '-', ''))) like '".$db->quote(strtoupper ( $prenomNormalise ) ) ."')
                LIMIT 1";

                $requete = $db->query($queryMail);

                while ($row = $db->fetchRow($requete)) {
                    $idIndividu = $row['id'];
                }
            } 

            // par son tel
            if ((!empty($objIndividu->phone_mobile) || !empty($objIndividu->phone_home) || !empty($objIndividu->phone_work) || !empty($objIndividu->phone_other)) && $idIndividu != false) { 
                // si on est la c'est qu'on a pas de mail mais on a forcement un numero..
                $mobile = str_replace(" ", "",$objIndividu->phone_mobile ?? '-1') ;
                $home = str_replace(" ", "",$objIndividu->phone_home ?? '-1') ;
                $work = str_replace(" ", "",$objIndividu->phone_work ?? '-1') ;
                $other = str_replace(" ", "",$objIndividu->phone_other?? '-1' ) ;
                $queryTel = "SELECT ops_individu.id as id
                            FROM ops_individu
                            where ops_individu.deleted = 0 
                            AND (REPLACE(phone_mobile, ' ', '') = '$mobile' OR
                                REPLACE(phone_home, ' ', '') = '$home' OR
                                REPLACE(phone_work, ' ', '') = '$work' OR
                                REPLACE(phone_other, ' ', '') = '$other')
                            AND (UPPER(TRIM(REPLACE( REPLACE( REPLACE( last_name, '_', ''), ' ', ''), '-', ''))) like '".$db->quote(strtoupper ( $nomNormalise ) ) ."') 
                            AND (UPPER(TRIM(REPLACE( REPLACE( REPLACE( first_name, '_', ''), ' ', ''), '-', ''))) like '".$db->quote(strtoupper ( $prenomNormalise ) ) ."')
                            LIMIT 1";

                $requete = $db->query($queryTel);

                while ($row = $db->fetchRow($requete)) {
                    $idIndividu = $row['id'];
                }
            }


            // creation de l'individu ou recuperation de l'individu existant
            if(!$idIndividu)
                $objIndividu->save();
            else 
                $objIndividu = BeanFactory::getBean('OPS_individu', $idIndividu);

            // erreur
            if(empty($objIndividu->id)) return;

            $this->dossier->beneficiaire_id = $objIndividu->id;
            $this->dossier->save();
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "CreerDossierPourLeCompteDe";
    }

    private function getChamps()
    {
        return array(
            'salutation' => 'Civilité',
            'last_name' => 'Nom de famille',
            'nom_usage' => 'Nom d\'usage',
            'first_name' => 'Prénom',
            'situation_familiale' => 'Situation matrimoniale',
            'etat' => 'Etat',
            'nationalite' => 'Nationalité',
            'date_naissance' => 'Date de naissance',
            'lieu_naissance' => 'Ville de naissance',
            'pays_naissance' => 'Pays de naissance',
            'representant_parent' => 'Représentant parents d\'élèves',
            'email1' => 'E-mail',
            'phone_mobile' => 'Tél. portable',
            'phone_home' => 'Tél. fixe',
            'phone_work' => 'Tél. professionnel',
            'phone_other' => 'Autre tél.',
            'accepte_mail' => 'Accepte mails',
            'accepte_sms' => 'Accepte SMS',
            'adresse_domiciliation' => 'Adresse de domiciliation',
            'profession_pcs' => 'Catégorie socio-professionnelle',
            'nom_employeur' => 'Nom de l\'employeur',
            'adresse_employeur' => 'Adresse de l\'employeur',
        );
    }

}
