<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AssignationParTerritoireAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Assignation par territoire "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'dossier';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Assignation par territoire "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Assigner selon le territoire";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Assignation par territoire "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Assigner un dossier par territoire";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier)){
            
            $this->dossier->load_relationship('ops_sous_territoire_ops_dossier');
            $sousTerritoireIds = $this->dossier->ops_sous_territoire_ops_dossier->get();

            if(!empty($sousTerritoireIds) && count($sousTerritoireIds) == 1){

                $objSousTerritoire = BeanFactory::getBean('OPS_sous_territoire',$sousTerritoireIds[0]);

                if(!empty($objSousTerritoire->id)){

                    $objSousTerritoire->load_relationship('ops_sous_territoire_ops_territoire');
                    $terroireIdS = $objSousTerritoire->ops_sous_territoire_ops_territoire->get();

                    if(!empty($terroireIdS) && count($terroireIdS) == 1){

                        $objTerritoire = BeanFactory::getBean('OPS_territoire',$terroireIdS[0]);

                        if(!empty($objTerritoire->id) && !empty($objTerritoire->assigned_user_id)){
                            $oldAssignedUser = $this->dossier->assigned_user_id; // Sauvegarde de l'ancien utilisateur assigné
                            if ($oldAssignedUser !== $objTerritoire->assigned_user_id) {
                                $this->dossier->assigned_user_id = $objTerritoire->assigned_user_id;
                                $this->dossier->save(true);
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Assignation par territoire "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }
}
