<?php

namespace ODE\ActionLot\Action;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ExporterGuideInstructionAction
{

    /**
     * @access public
     * @name getAction()
     * Fonction qui retourne l'action " Exporter guide d'instruction en format Json "
     * 
     *  @return array       - $action
     */
    public function getAction()
    {

        return array(
            'module_name' => 'OPS_guide_instruction',
            'action_content' => $this->getActionContent(),
            'action_link' => $this->getActionLink(),
        );
    }

    /**
     * @access public
     * @name getActionOrdre()
     * Fonction qui retourne l'ordre de l'action
     * 
     *  @return array       - $action_ordre
     */
    public function getActionOrdre()
    {
        return 1;
    }

    /**
     * @access private
     * @name getActionContent()
     * Fonction qui retourne le content de l'action
     * 
     *  @return array       - $action_content
     */
    private function getActionContent()
    {
        return $this->getActionLink() . $this->getActionHTML();
    }

    /**
     * @access private
     * @name getActionLink()
     * Fonction qui retourne le link de l'action
     * 
     *  @return array       - $action_link
     */
    private function getActionLink()
    {
        return '<a id="exporter_json_button"  onclick="openModalExporterJson();"  > Exporter Guide d\'instruction </a>';
    }

    /**
     * @access private
     * @name getActionHTML()
     * Fonction qui retourne l'html de l'action
     * 
     *  @return array       - $action_html
     */
    private function getActionHTML()
    {
        return file_get_contents('modules/OPS_guide_instruction/tpls/exporter.tpl');
    }
}
