<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Response\DocumentResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;

class LogoutService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @param BeanManager $beanManager
     */
    public function __construct(BeanManager $beanManager)
    {
        $this->beanManager = $beanManager;
    }

    /**
     * @param string $accessToken
     *
     * @return DocumentResponse
     * @throws \InvalidArgumentException When access token is not found.
     */
    public function logout($accessToken)
    {
        // same logic in Access and Refresh token repository, refactor this later
        $token = $this->beanManager->newBeanSafe(\OAuth2Tokens::class);
        $token->retrieve_by_string_fields(
            ['access_token' => $accessToken]
        );

        if ($token->id === null) {
            throw new \InvalidArgumentException('Access token is not found for this client');
        }

        $token->mark_deleted($token->id);

        $response = new DocumentResponse();
        $response->setMeta(
            new MetaResponse(['message' => 'You have been successfully logged out'])
        );

        return $response;
    }
}
