<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\DocumentResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;

use ODE_API\V8\Param\DocumentsListParams;
use ODE_API\V8\Param\DocumentsSetParams;
use ODE_API\V8\Param\DocumentTelechargerParams;

use Exception;
use Slim\Http\Request;
use BeanFactory;

use UploadFile;
use Datetime;
use DateTimeZone;

class DocumentsService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;
    
    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;
    
    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;
    
    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;
    
    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager        = $beanManager;
        $this->attributeHelper    = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper   = $paginationHelper;
    }
    
    /**
     * getListDocuments
     * @param DocumentsListParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getListDocuments(DocumentsListParams $params, Request $request)
    {
        global $sugar_config;

        $objet = $params->getModuleName();
        $id_objet = $params->getId();
        
        try {
            $obj_module = $this->beanManager->getBeanSafe($objet,$id_objet);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        $tab_documents = $obj_module->get_linked_beans(strtolower($objet) . '_documents', 'Documents');
        
        if (count($tab_documents) > 0) {
            
            foreach ($tab_documents as $key => $un_document) {
                
                $doc_array                  = array();
                $doc_array['id']            = $un_document->id;
                $doc_array['document_name'] = $un_document->document_name;
                $doc_array['date_depot']    = $un_document->date_entered;
                $doc_array['importable']    = $un_document->importable;
                
                $obj_type = $un_document->get_linked_beans('ops_type_document_documents', 'OPS_type_document');
                
                $doc_array['type_piece_id']   = $obj_type[0]->id;
                $doc_array['type_piece_name'] = $obj_type[0]->name;
                
                
                $documentRevisions = $this->beanManager->getBeanSafe("DocumentRevisions",$un_document->document_revision_id);
             //   $documentRevisions = BeanFactory::getBean('DocumentRevisions', $un_document->document_revision_id);
                
                if (!empty($documentRevisions->filename)) {
                    
                    $doc_array['fichier']['filename']      = $documentRevisions->filename;
                    $doc_array['fichier']['file_contents'] = base64_encode(file_get_contents($sugar_config['upload_dir'] . $un_document->document_revision_id));
                    $doc_array['fichier']['mime_type']     = $documentRevisions->file_mime_type;
                    $doc_array['fichier']['file_id']       = $documentRevisions->id;
                    
                } else {
                    
                    $doc_array['fichier'] = "Fichier introuvable";
                }
                
                $return_array[] = $doc_array;
                
            }
            
        } else {
            
            throw new Exception('Aucun document', 401);
        }
        
        $response = new DocumentResponse();
        $response->setData($return_array);
        
        return $response;
    }


        /**
     * getListDocuments
     * @param DocumentsListParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function setDocument(DocumentsSetParams $params, Request $request)
    {
        global $sugar_config;

        
        $parametres = $params->getData();
        
        // Paramètres 
        $objet         = $parametres["objet"];
        $id_objet      = $parametres["id_objet"];
        $file          = $parametres["file"];
        $filename      = $parametres["filename"];
        $importable    = $parametres["file_importable"];
        $file_type_nom = $parametres["file_type_nom"];

        try {
            $obj_module = $this->beanManager->getBeanSafe($objet,$id_objet);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        
        if (!$obj_module->ACLAccess('save')) {
            throw new AccessDeniedException();
        }
        
        $new_doc = true;

        // Vérification de l'unicité du type de document
        if (!empty($file_type_nom)) {

            $obj_type_document = $this->beanManager->getBeanByField("OPS_type_document",array('identifiant' => $file_type_nom ));

            // Si type de document unique alors mise à jour du document courant
            if (!empty($obj_type_document->name) && $obj_type_document->document_unique == true) {
                // Vérification de l'existance d'un document sur l'objet courant 
                $tab_documents = $obj_module->get_linked_beans(strtolower($objet) . '_documents', 'Documents');
                if (count($tab_documents) > 0) {
                    foreach ($tab_documents as $key => $un_document) {
                        $obj_type = $un_document->get_linked_beans('ops_type_document_documents', 'OPS_type_document');
                        $id_type_doc = $obj_type[0]->id;
                        if ($id_type_doc == $obj_type_document->id) {
                            $new_doc      = false;
                            $obj_document = $un_document;
                        }
                    }
                }
            }
        }

        if (true == $new_doc) {
            
            $obj_document = $this->beanManager->newBeanSafe('Document');
            // Création du document 
            $obj_document->parent_type = $objet;
            $obj_document->parent_id   = $id_objet;
            
        }
        
        $obj_document->document_name    = $filename;
        $obj_document->related_doc_id   = $id_objet;
        $obj_document->filename         = $filename;
        $obj_document->importable       = $this->verifie_boolean($importable);
        $obj_document->modified_user_id = 1;
        $obj_document->created_by       = 1;
        $obj_document->doc_type         = "Sugar";
        $obj_document->related_doc_id   = null;
        $obj_document->save();

        if (!empty($obj_document->id)) {

            $obj_document_soap = new UploadFile('uploadfile');
            $decodedFile = base64_decode($file);
            $obj_document_soap->set_for_soap($filename, $decodedFile);
            
            $ext_pos                                  = strrpos($obj_document_soap->stored_file_name, ".");
            $obj_document_soap->file_ext = substr($obj_document_soap->stored_file_name, $ext_pos + 1);
            if (in_array($obj_document_soap->file_ext, $sugar_config['upload_badext'])) {
                $obj_document_soap->stored_file_name .= ".txt";
                $obj_document_soap->file_ext = "txt";
            }
            
            $revision                 = $this->beanManager->newBeanSafe('DocumentRevision');
            $revision->filename       = $obj_document_soap->get_stored_file_name();
            $revision->file_mime_type = $obj_document_soap->getMimeSoap($revision->filename);
            $revision->file_ext       = $obj_document_soap->file_ext;
            $revision->revision       = '1';
            $revision->document_id    = $obj_document->id;
            $revision->save();
            
            $obj_document->document_revision_id = $revision->id;
            $obj_document->save();
            
            $obj_document_soap->final_move($revision->id);
            
            $obj_module->load_relationship(strtolower($objet) . '_documents');
            $nom_rel = strtolower($objet) . '_documents';
            $obj_module->$nom_rel->add($obj_document->id);
            $obj_module->save();
            
            if (!empty($obj_type_document->name)) {
                $obj_type_document->load_relationship('ops_type_document_documents');
                $obj_type_document->ops_type_document_documents->add($obj_document->id);
                $obj_type_document->save();
            }
        }

        $return_array = array("id"=>$obj_document->id);
        
        $response = new DocumentResponse();
        $response->setData($return_array);
        
        return $response;
    }
    
    private function verifie_boolean($bool){

        $bool_verified = 0;

        if ( is_string($bool) && trim($bool) === '1' ) {
            if( trim($bool) === '1' || strcasecmp($bool,'true') == 0){
                $bool_verified = 1;
            }
        } elseif ( is_int($bool) && $bool === 1 ) {
            $bool_verified = 1;
        }

        return $bool_verified;

    }

    
    /**
     * getListDocumentsReçus
     * @param DocumentsListParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getListDocumentsRecus(DocumentsListParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config;

        $objet = $params->getModuleName();
        $id_objet = $params->getId();

        try {
            $obj_module = $this->beanManager->getBeanSafe($objet,$id_objet);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        if (!$obj_module->ACLAccess('save')) {
            throw new AccessDeniedException();
        }
        
        //initialisation du format de la timezone
        $target_time_zone = new DateTimeZone('Europe/Paris');
        
        //Récupération des dossiers
        $tab_dossiers = $obj_module->get_linked_beans('ops_individu_ops_dossier', 'ops_dossier', 'num_dossier DESC'); 

        foreach ($tab_dossiers as $key => $un_dossier) {

            $objet_document = 'Documents';
            $id_dossier = $un_dossier->id;


            //Récupération des pj pour chaque dossier
            $obj_dossier = $this->beanManager->getBeanSafe('OPS_dossier',$un_dossier->id);


            $liste_documents = $obj_dossier->get_linked_beans('ops_dossier_documents', 'documents', 'date_entered DESC'); 
            $document_array = array();
            
            foreach ($liste_documents as $doc_key => $un_doc) {
            	
                if ( !empty($un_doc->id ) && $un_doc->fetched_row['importable'] == 1 ){
                    $content_file = base64_encode(file_get_contents($sugar_config['upload_dir'] . $un_doc->document_revision_id));

                    # Récupération du format de date provenant du user
                    $format = explode(' ',$GLOBALS['timedate']->get_date_time_format())[0];
                    if (empty($format))
                    {
                        require_once('modules/Configurator/Configurator.php');

                        $configuratorObj = new Configurator();

                        $format = $configuratorObj->config['default_date_format'];
                    }

                    $date_formate = DateTime::createFromFormat( $format, $un_doc->active_date );
                    $active_date = $date_formate->format( 'd/m/Y' );

                    //formatage du format de la date (a utiliser dans le cas de probleme de format en Front).
                    //$local_date_time  = new DateTime($un_doc->active_date);
                    $dateTime = new DateTime('NOW');
                    $today = $dateTime->format('Y-m-d');
                    $date = date_create_from_format('d/m/Y', $active_date);
                    $date_key = date_format($date, 'd-m-Y H:i:s');
                    $date_tri = strtotime($date_key);

                    $profil_id = 'particulier';
                    $profil_name = 'Particulier';

                    if(!empty($un_dossier->ops_personne_morale)){
                        $profil_id   = $un_dossier->ops_personne_morale;
                        $profil_name = $un_dossier->personne_morale;

                        $GLOBALS['log']->fatal(__CLASS__. '::' . __FUNCTION__ . ' => ' . PHP_EOL . print_r(array(
                            'profil_name' => $profil_name,
                        ), true));
                    }


                    if($this->checkDuplication($liste_documents_result, $un_doc->id))
                    {
                      
                        // Gestion des filtres
                        $type_document_id = $un_doc->fetched_rel_row['ops_type_document_documents_id'];
                        $type_document_name = $un_doc->fetched_rel_row['ops_type_document_documents_name'];
                        
                        $retour_documents['filtres']['nums_dossier'][] = $un_dossier->num_dossier;

                        $retour_documents['filtres']['type_document'][$type_document_id]['name'] = $type_document_name ;
                        $retour_documents['filtres']['type_document'][$type_document_id]['nombre'] += 1;

                        $retour_documents['filtres']['profils'][$profil_id]['name'] = $profil_name; 
                        $retour_documents['filtres']['profils'][$profil_id]['nombre'] += 1;
                        
                        $obj_dispositif = BeanFactory::getBean("OPS_dispositif", $un_dossier->ops_dispositif_id);

                        $retour_documents['filtres']['dispositifs'][$un_dossier->ops_dispositif_id]['name'] = $obj_dispositif->name; 
                        $retour_documents['filtres']['dispositifs'][$un_dossier->ops_dispositif_id]['nombre'] += 1;
                      
                        //création du tableau qui sera retourné en front
                        $document_array = [
            
                            'id_pj'             => $un_doc->id,
                            'content_file'		=> $content_file,
                            'type_mime'			=> $un_doc->last_rev_mime_type,
                            'id_dossier'        => $id_dossier,
                            'id_entite'         => $id_objet,
                            'id_dispositif'     => $un_dossier->ops_dispositif_id,
                            'dispositif_name'   => $obj_dispositif->name,
                            'type_document'     => $type_document_name,
                            'profil'            => $un_dossier->type_tiers,
                            'document'          => $un_doc->document_name,
                            'num_dossier'       => $un_dossier->num_dossier,
                            'provenance'        => 'dossier',
                            'id_profil'         => $profil_id,
                            'name_profil'       => $profil_name,
                            'date_tri'          => $date_tri,
                            'date_depot'        => $active_date,
                            'statut'            => $un_doc->status_id
                            //$local_date_time->format('d/m/Y')
                        ];
                        
                        $liste_documents_result[] = $document_array;
                    }
                }
            }
        }
 
        //Récupération des document lié a l'individu
        $individu_documents = $obj_module->get_linked_beans('ops_individu_documents', 'documents', 'date_entered DESC'); 
        
        foreach ($individu_documents as $key => $un_doc_individu) {
            if ( !empty($un_doc_individu->id ) && $un_doc_individu->fetched_row['importable'] == 1 ){
            	$content_file = base64_encode(file_get_contents($sugar_config['upload_dir'] . $un_doc_individu->fetched_row['document_revision_id']));
            	
            	# Récupération du format de date provenant du user
                $format = explode(' ',$GLOBALS['timedate']->get_date_time_format())[0];
                if (empty($format))
                {
                    require_once('modules/Configurator/Configurator.php');

                    $configuratorObj = new Configurator();

                    $format = $configuratorObj->config['default_date_format'];
                }

                $date_formate = DateTime::createFromFormat( $format, $un_doc_individu->active_date );
                $active_date = $date_formate->format( 'd/m/Y' );

                //formatage du format de la date (a utiliser dans le cas de probleme de format en Front).
                //$local_date_time  = new DateTime($un_doc->active_date);
                $dateTime = new DateTime('NOW');
                $today = $dateTime->format('Y-m-d');
                $date = date_create_from_format('d/m/Y', $active_date);
                $date_key = date_format($date, 'd-m-Y H:i:s');
                $date_tri = strtotime($date_key);

                if($this->checkDuplication($liste_documents_result, $un_doc_individu->id))
                {
                    // Gestion des filtres
                    $type_document_id = $un_doc_individu->fetched_rel_row['ops_type_document_documents_id'];
                    $type_document_name = $un_doc_individu->fetched_rel_row['ops_type_document_documents_name'];

                    $retour_documents['filtres']['type_document'][$type_document_id]['name'] = $type_document_name ;
                    $retour_documents['filtres']['type_document'][$type_document_id]['nombre'] += 1;

                    $retour_documents['filtres']['profils']["particulier"]['name'] = "Particulier"; 
                    $retour_documents['filtres']['profils']["particulier"]['nombre'] += 1;

                    //création du tableau qui sera retourné en front
                    $document_indi_array = [
                        'id_pj'             => $un_doc_individu->id,
                        'content_file'		=> $content_file,
                        'type_mime'			=> $un_doc_individu->last_rev_mime_type,
                        'id_dossier'        => '',
                        'id_entite'         => $id_objet,
                        'id_dispositif'     => '',
                        'type_document'     => $un_doc_individu->fetched_rel_row['ops_type_document_documents_name'],
                        'profil'            => 'OPS_individu',
                        'document'          => $un_doc_individu->document_name,
                        'num_dossier'       => '',
                        'provenance'        => 'individu',
                        'id_profil'         => 'particulier',
                        'name_profil'       => 'Particulier',
                        'date_tri'          => $date_tri,
                        'date_depot'        => $active_date
                        //$local_date_time->format('d/m/Y') 
                    ];
    
                    $liste_documents_result[] = $document_indi_array;
                }
           } 
        }

        //Récupération des personne moral de l'individu dans perso_moral_individu
        $tab_pers_moral_indi = $obj_module->get_linked_beans('ops_individu_ops_personne_morale_individu', 'ops_personne_morale_individu', 'num_dossier DESC', 0, -1, 0, 'ops_personne_morale_individu.acces_usager = 1'); 
        foreach ($tab_pers_moral_indi as $key => $une_pers_moral_indi) {

            //$objet_personne_morale_individu = 'Documents';
            $id_pers_moral_indi = $une_pers_moral_indi->id;
        
            //Récupération des personne morale
            $obj_pers_moral_indi = $this->beanManager->getBeanSafe('OPS_personne_morale_individu',$id_pers_moral_indi);
            $tab_pers_moral = $obj_pers_moral_indi->get_linked_beans('ops_personne_morale_ops_personne_morale_individu', 'ops_personne_morale', 'date_entered DESC');
            
            
            foreach ($tab_pers_moral as $key => $une_pers_moral) {

            	$id_pers_moral = $une_pers_moral->id;

            	//récupération des documents lié a la personne morale
            	$obj_pers_moral = $this->beanManager->getBeanSafe('OPS_personne_morale',$id_pers_moral);
            	$tab_pers_moral_document = $obj_pers_moral->get_linked_beans('ops_personne_morale_documents', 'documents', 'date_entered DESC');

            	foreach ($tab_pers_moral_document as $key => $un_pers_moral_document) {
            		if ( !empty($un_pers_moral_document->id ) && $un_pers_moral_document->fetched_row['importable'] == 1 ){
            			$content_file = base64_encode(file_get_contents($sugar_config['upload_dir'] . $un_pers_moral_document->fetched_row['document_revision_id']));
						
						//Récupération du libelle usager du type tier
                        $sql = "SELECT libelle_usager FROM `ops_type_personne` WHERE `id` = '" . $obj_pers_moral->ops_type_personne_id ."'";
                        $result = $db->query($sql);
                        $row = "";
                        while ($row = $db->fetchByAssoc($result)) {
                            $name_profil = $row['libelle_usager'];
                        }  
            	        
            	        # Récupération du format de date provenant du user
                        $format = explode(' ',$GLOBALS['timedate']->get_date_time_format())[0];
                        if (empty($format))
                        {
                            require_once('modules/Configurator/Configurator.php');

                            $configuratorObj = new Configurator();

                            $format = $configuratorObj->config['default_date_format'];
                        }

                        $date_formate = DateTime::createFromFormat( $format, $un_pers_moral_document->active_date );
                        $active_date = $date_formate->format( 'd/m/Y' );

                        //formatage du format de la date (a utiliser dans le cas de probleme de format en Front).
                        //$local_date_time  = new DateTime($un_doc->active_date);
                        $dateTime = new DateTime('NOW');
                        $today = $dateTime->format('Y-m-d');
                        $date = date_create_from_format('d/m/Y', $active_date);
                        $date_key = date_format($date, 'd-m-Y H:i:s');
                        $date_tri = strtotime($date_key);
                        
                        if($this->checkDuplication($liste_documents_result, $un_pers_moral_document->id))
                        {

                            // Gestion des filtres
                            $type_document_id = $un_pers_moral_document->fetched_rel_row['ops_type_document_documents_id'];
                            $type_document_name = $un_pers_moral_document->fetched_rel_row['ops_type_document_documents_name'];

                            $retour_documents['filtres']['type_document'][$type_document_id]['name'] = $type_document_name ;
                            $retour_documents['filtres']['type_document'][$type_document_id]['nombre'] += 1;

                            $retour_documents['filtres']['profils'][$obj_pers_moral->id]['name'] = $obj_pers_moral->name; 
                            $retour_documents['filtres']['profils'][$obj_pers_moral->id]['nombre'] += 1;

                            //création du tableau qui sera retourné en front
                            $document_pers_moral_array = [
            
                                'id_pj'             => $un_pers_moral_document->id,
                                'content_file'		=> $content_file,
                                'type_mime'			=> $un_pers_moral_document->last_rev_mime_type,
                                'id_dossier'        => '',
                                'id_entite'         => $id_objet,
                                'id_dispositif'     => '',
                                'type_document'     => $un_pers_moral_document->fetched_rel_row['ops_type_document_documents_name'],
                                'profil'            => 'OPS_personne_morale',
                                'document'          => $un_pers_moral_document->document_name,
                                'num_dossier'       => '',
                                'provenance'        => 'personne_moral',
                                'id_profil'         => $obj_pers_moral->id,
                                'name_profil'       => $obj_pers_moral->name,
                                'date_tri'          => $date_tri,
                                'date_depot'        => $active_date
                                //$local_date_time->format('d/m/Y') 
                            ];
    
                            $liste_documents_result[] = $document_pers_moral_array;
                        }

           			} 
            	}

                # création d'un tableau avec les ID des entites afin de préparer la requete
                if( $une_pers_moral_indi->acces_usager == 1 ){
                    $traitement_id = '"' . $une_pers_moral->id . '"';
                    $liste_person_moral_id[] =  $traitement_id ;
                }
            	//récupération des dossiers lié a la personne moral

        	}
                
        }

        if ( !empty($liste_person_moral_id) ){
            $sql_in = implode(",", $liste_person_moral_id);
            $requete = 'SELECT * FROM ops_dossier WHERE ops_personne_morale IN ('.$sql_in.') AND deleted = 0';
            $result2 = $db->query($requete);
            $row2 = "";
            while ($row2 = $db->fetchByAssoc($result2)) {

                $dossier_id     = $row2['id'];
                $obj_dossier_perso_moral = $this->beanManager->getBeanSafe('OPS_dossier', $dossier_id);
                $obj_pers_moral = $this->beanManager->getBeanSafe('OPS_personne_morale', $obj_dossier_perso_moral->ops_personne_morale);
                $liste_documents = $obj_dossier_perso_moral->get_linked_beans('ops_dossier_documents', 'documents', 'date_entered DESC');
           
                foreach ($liste_documents as $doc_key => $un_doc) {
                            
                    if ( !empty($un_doc->id ) && $un_doc->fetched_row['importable'] == 1){
                        $content_file = base64_encode(file_get_contents($sugar_config['upload_dir'] . $un_doc->document_revision_id) );

                        $name_profil = $obj_pers_moral->name;

                        # Récupération du format de date provenant du user
                        $format = explode(' ',$GLOBALS['timedate']->get_date_time_format())[0];
                        if (empty($format))
                        {
                            require_once('modules/Configurator/Configurator.php');

                            $configuratorObj = new Configurator();

                            $format = $configuratorObj->config['default_date_format'];
                        }

                        $date_formate = DateTime::createFromFormat( $format, $un_doc->active_date );
                        $active_date = $date_formate->format( 'd/m/Y' );

                        //formatage du format de la date (a utiliser dans le cas de probleme de format en Front).
                        //$local_date_time  = new DateTime($un_doc->active_date);
                        $dateTime = new DateTime('NOW');
                        $today = $dateTime->format('Y-m-d');
                        $date = date_create_from_format('d/m/Y', $active_date);
                        $date_key = date_format($date, 'd-m-Y H:i:s');
                        $date_tri = strtotime($date_key);

                        if($this->checkDuplication($liste_documents_result, $un_doc->id))
                        {
                            //création du tableau qui sera retourné en front
                            $document_perso_morale_dossier_array = [
                                'id_pj'             => $un_doc->id,
                                'content_file'      => $content_file,
                                'type_mime'         => $un_doc->last_rev_mime_type,
                                'id_dossier'        => $dossier_id,
                                'id_entite'         => $id_pers_moral,
                                'id_dispositif'     => $obj_dossier_perso_moral->ops_dispositif_id,
                                'type_document'     => $un_doc->fetched_rel_row['ops_type_document_documents_name'],
                                'profil'            => $obj_dossier_perso_moral->type_tiers,
                                'document'          => $un_doc->document_name,
                                'num_dossier'       => $obj_dossier_perso_moral->num_dossier,
                                'provenance'        => 'dossier_personne_moral',
                                'id_profil'         => $obj_pers_moral->ops_type_personne_id,
                                'name_profil'       => $name_profil,
                                'date_tri'          => $date_tri,
                                'date_depot'        => $active_date                     
                            ];   
                            
                            $liste_documents_result[] = $document_perso_morale_dossier_array;
                        }
                    }
                }
            }    
        }

        array_multisort( array_column($liste_documents_result, "date_tri"), SORT_DESC, $liste_documents_result );

        $retour_documents['documents'] = $liste_documents_result;

        return $retour_documents;
    }

    /**
     * checkDuplication
     * 
     * Vérifie que l'ID donné n'éxiste pas dans le tableau+
     * 
     * @param array $document_list
     * @param string $document_id
     * 
     * @return bool
     */
    private function checkDuplication($document_list, $document_id)
    {
        foreach ($document_list as $document) 
        {
            if ($document['id_pj'] == $document_id) 
            {
                return false;
            } 
        }
        return true;
    }
	
	
	 /**
     * getDocument
     * @param DocumentTelechargerParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getDocument(DocumentTelechargerParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config;

        // On récupere l'id du document. 
        $document_id = $params->getId();
        $individu_id = $params->getIdIndividu();

        // On vérifie proprement que le document existe bien.
        try {
            $obj_document = $this->beanManager->getBeanSafe('Documents',  $document_id );
        } catch (\Exception $exception) {
            throw new Exception("Aucun document avec l'id = " . $document_id, 401);
        }
        
        $data = [
            'statut' => false,
            'base64' => '',
        ];
        
        if ( !empty($obj_document->id ) && $obj_document->fetched_row['importable'] == 1){
            $content_file = base64_encode(file_get_contents($sugar_config['upload_dir'] . $obj_document->document_revision_id) );
             
            if( isset( $content_file ) && !empty( $content_file ) ){
                $data['statut'] = true;
                $data['base64'] = $content_file;
            }
        }

        $response = new DocumentResponse();
        $response->setData($data);
        
        return $response;
    }
}
