<?php
namespace ODE_API\V8\Param\Options;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class Entite extends BaseOption
{
    const REGEX_ENTITE_PATTERN = '/^(\d|\W)|\W/';

    /**
     * @inheritdoc
     */
    public function add(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired('entite')
            ->setAllowedTypes('entite', 'string')
            ->setAllowedValues('entite', $this->validatorFactory->createClosure([
                new Assert\NotBlank(),
                new Assert\Regex([
                    'pattern' => self::REGEX_ENTITE_PATTERN,
                    'match' => false,
                ]),
            ]));
    }
}
