<?php

namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class DossierSuiviParams extends BaseParam
{


    /**
     * @return id
     */
    public function getId()
    {
        return $this->parameters['id'];
    }


    /**
     * @return id
     */
    public function getIdDossier()
    {
        return $this->parameters['dossierId'];
    }


    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\Id::class,
                ParamOption\DossierId::class
            ]
        );
    }
}
