<?php

namespace Custom_ODE_API\Controller;

use ODE_API\V8\Controller\BaseController;

use Custom_ODE_API\Service\OpenConversationService;
use Custom_ODE_API\Param\ListeConversationParams;

use Exception;
use Slim\Http\Request;
use Slim\Http\Response;


class OpenConversationController extends BaseController
{
    /**
     * @var OpenConversationService
     */
    private $OpenConversationService;

    /**
     * @param OpenConversationService $OpenConversationService
     */
    public function __construct(OpenConversationService $OpenConversationService)
    {
        $this->OpenConversationService = $OpenConversationService;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param accessConversation $params
     *
     * @return Response
     */
    public function accessConversation(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->OpenConversationService->accessConversation($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param fetchConversationState $params
     *
     * @return Response
     */
    public function fetchConversationState(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->OpenConversationService->fetchConversationState($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param fetchMessages $params
     *
     * @return Response
     */
    public function fetchMessages(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->OpenConversationService->fetchMessages($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param sendMessage $params
     *
     * @return Response
     */
    public function sendMessage(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->OpenConversationService->sendMessage($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param setMessageStatut $params
     *
     * @return Response
     */
    public function setMessageStatut(Request $request, Response $response, array $args, ListeConversationParams $params): Response
    {
        try {
            $jsonResponse = $this->OpenConversationService->setMessageStatut($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

}