<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Param\DocumentsListParams;
use ODE_API\V8\Param\DocumentsSetParams;
use ODE_API\V8\Param\DocumentTelechargerParams;

use ODE_API\V8\Service\DocumentsService;

use Slim\Http\Request;
use Slim\Http\Response;

/**
     * DocumentsController
*/
class DocumentsController extends BaseController
{
    /**
     * @var DocumentsController
     */
    protected $documentsService;

    /**
     * @param DocumentsService $documentsService
     */
    public function __construct(DocumentsService $documentsService)
    {
        $this->documentsService = $documentsService;
    }

    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param ListeDocumentsParams $params
     *
     * @return Response
     */
    public function getListDocuments(Request $request, Response $response, array $args, DocumentsListParams $params)
    {
        try {
            $jsonResponse = $this->documentsService->getListDocuments($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param createDocumentParams $params
     *
     * @return Response
     */
    public function setDocument(Request $request, Response $response, array $args, DocumentsSetParams $params)
    {
        try {
            $jsonResponse = $this->documentsService->setDocument($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }  


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param ListeDocumentsParams $params
     *
     * @return Response
     */
    public function getListDocumentsRecus(Request $request, Response $response, array $args, DocumentsListParams $params)
    {
        try {
            $jsonResponse = $this->documentsService->getListDocumentsRecus($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DocumentTelechargerParams $params
     *
     * @return Response
     */
    public function getDocument(Request $request, Response $response, array $args, DocumentTelechargerParams $params)
    {
        try {
            $jsonResponse = $this->documentsService->getDocument($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 	

}
