<?php

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\Helper\ModuleListProvider;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\Service;
use Psr\Container\ContainerInterface as Container;
use ODE_API\Core\Loader\CustomLoader;

return CustomLoader::mergeCustomArray([
    // CUSTOM
    Service\ConversationService::class => function (Container $container) {
        return new Service\ConversationService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\TiersService::class => function (Container $container) {
        return new Service\TiersService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\AppairageService::class => function (Container $container) {
        return new Service\AppairageService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\JustificatifService::class => function (Container $container) {
        return new Service\JustificatifService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
	Service\NotificationService::class => function (Container $container) {
        return new Service\NotificationService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\DossierService::class => function (Container $container) {
        return new Service\DossierService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\DossierJustificatifService::class => function (Container $container) {
        return new Service\DossierJustificatifService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\DocumentsService::class => function (Container $container) {
        return new Service\DocumentsService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\IndividuService::class => function (Container $container) {
        return new Service\IndividuService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\OAuthCRMService::class => function (Container $container) {
        return new Service\OAuthCRMService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\DispositifService::class => function (Container $container) {
        return new Service\DispositifService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\ListViewSearchService::class => function (Container $container) {
        return new Service\ListViewSearchService(
            $container->get(BeanManager::class)
        );
    },
    Service\UserPreferencesService::class => function (Container $container) {
        return new Service\UserPreferencesService(
            $container->get(BeanManager::class)
        );
    },
    Service\UserService::class => function (Container $container) {
        return new Service\UserService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class)
        );
    },
    Service\MetaService::class => function (Container $container) {
        return new Service\MetaService(
            $container->get(BeanManager::class),
            $container->get(ModuleListProvider::class)
        );
    },
    Service\ListViewService::class => function (Container $container) {
        return new Service\ListViewService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\ModuleService::class => function (Container $container) {
        return new Service\ModuleService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\LogoutService::class => function (Container $container) {
        return new Service\LogoutService(
            $container->get(BeanManager::class)
        );
    },
    Service\RelationshipService::class => function (Container $container) {
        return new Service\RelationshipService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class)
        );
    },
    Service\RepertoireEntrepriseService::class => function (Container $container) {
        return new Service\RepertoireEntrepriseService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\AjaxPointsService::class => function (Container $container) {
        return new Service\AjaxPointsService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
    Service\HorsCompteService::class => function (Container $container) {
        return new Service\HorsCompteService(
            $container->get(BeanManager::class),
            $container->get(AttributeObjectHelper::class),
            $container->get(RelationshipObjectHelper::class),
            $container->get(PaginationObjectHelper::class)
        );
    },
], basename(__FILE__));
