<?php

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\Helper;
use ODE_API\V8\JsonApi\Helper as ApiHelper;
use Psr\Container\ContainerInterface as Container;

use ODE_API\Core\Loader\CustomLoader;

return CustomLoader::mergeCustomArray([
    Helper\VarDefHelper::class => function () {
        return new Helper\VarDefHelper();
    },
    ApiHelper\AttributeObjectHelper::class => function (Container $container) {
        return new ApiHelper\AttributeObjectHelper(
            $container->get(BeanManager::class)
        );
    },
    ApiHelper\RelationshipObjectHelper::class => function (Container $container) {
        return new ApiHelper\RelationshipObjectHelper(
            $container->get(Helper\VarDefHelper::class)
        );
    },
    ApiHelper\PaginationObjectHelper::class => function (Container $container) {
        return new ApiHelper\PaginationObjectHelper();
    },
    Helper\ModuleListProvider::class => function (Container $container) {
        return new Helper\ModuleListProvider();
    },
], basename(__FILE__));
