<?php

use ODE_API\V8\Controller\LogoutController;
use ODE_API\V8\Factory\ParamsMiddlewareFactory;
use ODE_API\V8\Param;
use League\OAuth2\Server\AuthorizationServer;
use League\OAuth2\Server\Middleware\AuthorizationServerMiddleware;
use League\OAuth2\Server\Middleware\ResourceServerMiddleware;
use League\OAuth2\Server\ResourceServer;
use ODE_API\Core\Loader\CustomLoader;

use ODE_API\V8\Param\GetOAuthIdentityParams; # OAuthCRM
use ODE_API\V8\Param\GetOAuthIndividuParams; # OAuthCRM
use ODE_API\V8\Param\SetOAuthIndividuParams; # OAuthCRM


$app->group('', function () use ($app) {
    /**
     * OAuth2 access token
     */
    $app->post('/access_token', function () {
    })->add(new AuthorizationServerMiddleware($app->getContainer()->get(AuthorizationServer::class)));

    $app->group('/V8', function () use ($app) {
        /** @var ParamsMiddlewareFactory $paramsMiddlewareFactory */
        $paramsMiddlewareFactory = $app->getContainer()->get(ParamsMiddlewareFactory::class);

        /**
         * Logout
         */
        $app->post('/logout', LogoutController::class);

        $app
            ->get('/search-defs/module/{moduleName}', 'ODE_API\V8\Controller\ListViewSearchController:getModuleSearchDefs')
            ->add($paramsMiddlewareFactory->bind(Param\ListViewSearchParams::class));

        $app
            ->get('/listview/columns/{moduleName}', 'ODE_API\V8\Controller\ListViewController:getListViewColumns')
            ->add($paramsMiddlewareFactory->bind(Param\ListViewColumnsParams::class));

        $app->get('/current-user', 'ODE_API\V8\Controller\UserController:getCurrentUser');

        $app->get('/meta/modules', 'ODE_API\V8\Controller\MetaController:getModuleList');

        $app->get('/meta/fields/{moduleName}', 'ODE_API\V8\Controller\MetaController:getFieldList')
            ->add($paramsMiddlewareFactory->bind(Param\GetFieldListParams::class));

        $app
            ->get('/user-preferences/{id}', 'ODE_API\V8\Controller\UserPreferencesController:getUserPreferences')
            ->add($paramsMiddlewareFactory->bind(Param\GetUserPreferencesParams::class));

        /**
         * Get swagger schema
         */
        $app->get('/meta/swagger.json', 'ODE_API\V8\Controller\MetaController:getSwaggerSchema');

        /**
         * Get module records
         */
        $app
            ->get('/module/{moduleName}', 'ODE_API\V8\Controller\ModuleController:getModuleRecords')
            ->add($paramsMiddlewareFactory->bind(Param\GetModulesParams::class));

        /**
         * Get a module record
         */
        $app
            ->get('/module/{moduleName}/{id}', 'ODE_API\V8\Controller\ModuleController:getModuleRecord')
            ->add($paramsMiddlewareFactory->bind(Param\GetModuleParams::class));

        /**
         * Create a module record
         */
        $app
            ->post('/module', 'ODE_API\V8\Controller\ModuleController:createModuleRecord')
            ->add($paramsMiddlewareFactory->bind(Param\CreateModuleParams::class));

        /**
         * Update a module record
         */
        $app
            ->patch('/module', 'ODE_API\V8\Controller\ModuleController:updateModuleRecord')
            ->add($paramsMiddlewareFactory->bind(Param\UpdateModuleParams::class));

        /**
         * Delete a module record
         */
        $app
            ->delete('/module/{moduleName}/{id}', 'ODE_API\V8\Controller\ModuleController:deleteModuleRecord')
            ->add($paramsMiddlewareFactory->bind(Param\DeleteModuleParams::class));

        /**
         * Get relationships
         */
        $app
            ->get(
                '/module/{moduleName}/{id}/relationships/{linkFieldName}',
                'ODE_API\V8\Controller\RelationshipController:getRelationship'
            )
            ->add($paramsMiddlewareFactory->bind(Param\GetRelationshipParams::class));

        /**
         * Create relationship
         */
        $app
            ->post(
                '/module/{moduleName}/{id}/relationships',
                'ODE_API\V8\Controller\RelationshipController:createRelationship'
            )
            ->add($paramsMiddlewareFactory->bind(Param\CreateRelationshipParams::class));

        /**
         * Create relationship by link
         */
        $app
            ->post(
                '/module/{moduleName}/{id}/relationships/{linkFieldName}',
                'ODE_API\V8\Controller\RelationshipController:createRelationshipByLink'
            )
            ->add($paramsMiddlewareFactory->bind(Param\CreateRelationshipByLinkParams::class));

        /**
         * Delete relationship
         */
        $app
            ->delete(
                '/module/{moduleName}/{id}/relationships/{linkFieldName}/{relatedBeanId}',
                'ODE_API\V8\Controller\RelationshipController:deleteRelationship'
            )
            ->add($paramsMiddlewareFactory->bind(Param\DeleteRelationshipParams::class));



        /**
         * @package  Lanteas Custom
         * ***********************************************************************
         * Usage in front :
         * @see <WP Portail>/WP_Plugins/Open Socle/Lanteas Api tu use it.
         * @uses Lanteas_Api::send_request( $endpoint, $args=[] )
         *
         * @todo Refactor <Warning> route badformed !
         *
         * ***********************************************************************
         *  █████                             █████                             
         * ░░███                             ░░███                              
         *  ░███         ██████   ████████   ███████    ██████   ██████    █████
         *  ░███        ░░░░░███ ░░███░░███ ░░░███░    ███░░███ ░░░░░███  ███░░ 
         *  ░███         ███████  ░███ ░███   ░███    ░███████   ███████ ░░█████
         *  ░███      █ ███░░███  ░███ ░███   ░███ ███░███░░░   ███░░███  ░░░░██
         *  ███████████░░████████ ████ █████  ░░█████ ░░██████ ░░████████ ██████
         * ░░░░░░░░░░░  ░░░░░░░░ ░░░░ ░░░░░    ░░░░░   ░░░░░░   ░░░░░░░░ ░░░░░░ 
         * ***********************************************************************
         */



        /**
         * @category OAuthCRM
         * @internal Gestions de l'authentification via l'API Lanteas & API_OAuth.
         * @method   OAuthCRMController::getIdentity()
         */
        $app
            ->get('/oauthcrm/{email}', 'ODE_API\V8\Controller\OAuthCRMController:getIdentity')
            ->add($paramsMiddlewareFactory->bind(Param\GetOAuthIdentityParams::class));

        /**
         * @category OAuthCRM
         * @internal Gestions de l'authentification via l'API Lanteas & API_OAuth.
         * @method   OAuthCRMController::getIndividu()
         */
        $app
            ->get('/oauthcrm/individu/{id}', 'ODE_API\V8\Controller\OAuthCRMController:getIndividu')
            ->add($paramsMiddlewareFactory->bind(Param\GetOAuthIndividuParams::class));

        /**
         * @category OAuthCRM
         * @internal Gestions de l'authentification via l'API Lanteas & API_OAuth.
         * @method   OAuthCRMController::setIndividu()
         */
        $app
            ->post('/oauthcrm/individu/create', 'ODE_API\V8\Controller\OAuthCRMController:setIndividu')
            ->add($paramsMiddlewareFactory->bind(Param\SetOAuthIndividuParams::class));

        /**
         * @category OAuthCRM
         * @internal Gestions de l'authentification via l'API Lanteas & API_OAuth.
         * @method   OAuthCRMController::updateIndividu()
         */
        $app
            ->post('/oauthcrm/individu/update', 'ODE_API\V8\Controller\OAuthCRMController:updateIndividu')
            ->add($paramsMiddlewareFactory->bind(Param\SetOAuthIndividuParams::class));

        /**
         * @category OAuthCRM
         * @internal Permet de pousser des informations de connexion navigateur dans un hystorique de connexion usager sous forme de trace d'activité.
         * @method   OAuthCRMController::set()
         */
        $app
            ->post('/oauthcrm/history-cnx/update', 'ODE_API\V8\Controller\OAuthCRMController:updateHistoryConnexion')
            ->add($paramsMiddlewareFactory->bind(Param\SetOAuthHistoryCnxParams::class));





        /**
         * @category AjaxPoint
         * @internal Récupère les paramètres fiscaux via una API Gouv (https://particulier-test.api.gouv.fr/api/v2/avis-imposition).
         * @method   AjaxPointsController::getInfoFiscaleByNumRef()
         */
        $app
            ->get('/ajaxpoint/api-particulier/{numeroFiscal}/{referenceAvis}', 'ODE_API\V8\Controller\AjaxPointsController:getInfoFiscaleByNumRef')
            ->add($paramsMiddlewareFactory->bind(Param\AjaxPointsParams::class));






        /**
         * @category Appairage
         * @internal Récupérer les appairages d'un objet via l'API Lanteas & API_OAuth.
         * @method   AppairageController::getAppairageByObject()
         */
        $app
            ->post('/appairages', 'ODE_API\V8\Controller\AppairageController:getAppairageByObject')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Appairage
         * @internal Créer un appairage via l'API Lanteas & API_OAuth.
         * @method   AppairageController::createAppairage()
         */
        $app
            ->post('/appairage-create', 'ODE_API\V8\Controller\AppairageController:createAppairage')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));


        /**
         * @category Individu
         * @internal Récupère un individu par son UUID via l'API Lanteas & API_OAuth.
         * @method   IndividuController::getInfoIndividu()
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->get('/getIndividu/{moduleName}/{id}', 'ODE_API\V8\Controller\IndividuController:getInfoIndividu')
            ->add($paramsMiddlewareFactory->bind(Param\IndividuInfoParams::class));

        /**
         * @category Individu
         * @internal Récupère les messages d'un individu.
         * @method   IndividuController::getIndividuMessages()
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->get('/individu-messages-recus/{moduleName}/{id}', 'ODE_API\V8\Controller\IndividuController:getIndividuMessages')
            ->add($paramsMiddlewareFactory->bind(Param\IndividuInfoParams::class));

        /**
         * @category Individu
         * @internal Récupère le détail d'un message individu.
         * @method   IndividuController::getIndividuMessagesDetail()
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->get('/individu-messages-detail/{messageId}/{id}', 'ODE_API\V8\Controller\IndividuController:getIndividuMessagesDetail')
            ->add($paramsMiddlewareFactory->bind(Param\IndividuMessageDetailParams::class));

        /**
         * @category Individu
         * @internal Met à jour un individu via l'API Lanteas & API_OAuth.
         * @method   IndividuController::updateIndividu()
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->post('/updateIndividu', 'ODE_API\V8\Controller\IndividuController:updateIndividu')
            ->add($paramsMiddlewareFactory->bind(Param\UpdateIndividuParams::class));

        /**
         * @category Individu
         * @internal Envoie les champs pour l'edit & detail view de l'individu.
         * @method   IndividuController::getIndividuFields()
         * <Warning> @todo route must be in slug-format !
         */
        $app->get('/individu-field', 'ODE_API\V8\Controller\IndividuController:getIndividuFields');


        /**
         * @category Dispositif
         * @internal Liste des dispositifs via l'API Lanteas & API_OAuth.
         * @method   DispositifController::getListDispositif()
         */
        $app->get('/dispositif', 'ODE_API\V8\Controller\DispositifController:getListDispositif');

        /**
         * @category Dispositif
         * @internal Liste des dispositifs via l'API Lanteas & API_OAuth.
         * @method   DispositifController::getListDispositif()
         */
        $app
            ->get('/dispositif/{id}', 'ODE_API\V8\Controller\DispositifController:getDetailDispositif')
            ->add($paramsMiddlewareFactory->bind(Param\DispositifParams::class));

        /**
         * @category Dispositif
         * @internal Récupération du nouveau formulaire d'un dispositif pour une affichage en front via l'API Lanteas & API_OAuth.
         * @method   DispositifController::getNewFormulaire()
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->get('/getFormulaire/{entite}/{demandeurId}/{dispositifId}', 'ODE_API\V8\Controller\DispositifController:getNewFormulaire')
            ->add($paramsMiddlewareFactory->bind(Param\FormulaireListParams::class));





        /**
         * @category Dossier
         * @internal Liste des dossiers pour un individu par son UUID via l'API Lanteas & API_OAuth.
         * @method   DossierController::getListDossier()
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->get('/getListDossier/{id}', 'ODE_API\V8\Controller\DossierController:getListDossier')
            ->add($paramsMiddlewareFactory->bind(Param\DossierListParams::class));

        /**
         * @category Dossier
         * @internal Création d'un dossier par son UUID via l'API Lanteas & API_OAuth.
         * @method   DossierController::createDossier()
         */
        $app
            ->post('/dossier-create', 'ODE_API\V8\Controller\DossierController:createDossier')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Dossier
         * @internal Créer un dossier par étape via l'API Lanteas & API_OAuth.
         * @method   DossierController::createDossierByEtape()
         */
        $app
            ->post('/dossier-create-etape', 'ODE_API\V8\Controller\DossierController:createDossierByEtape')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Dossier
         * @internal Met à jour un dossier via l'API Lanteas & API_OAuth.
         * @method   DossierController::updateDossier()
         */
        $app
            ->post('/dossier-update', 'ODE_API\V8\Controller\DossierController:updateDossier')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Dossier
         * @internal Met à jour un dossier par étape via l'API Lanteas & API_OAuth.
         * @method   DossierController::updateDossierByEtape()
         */
        $app
            ->post('/dossier-update-etape', 'ODE_API\V8\Controller\DossierController:updateDossierByEtape')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Dossier
         * @internal Récupération d'un dossier par son UUID via l'API Lanteas & API_OAuth.
         * @method   DossierController::getDossierById()
         */
        $app
            ->get('/dossier-id/{id}', 'ODE_API\V8\Controller\DossierController:getDossierById')
            ->add($paramsMiddlewareFactory->bind(Param\DossierListParams::class));

        /**
         * @category Dossier
         * @internal Récupération d'un dossier par son #NUM via l'API Lanteas & API_OAuth.
         * @method   DossierController::getDossierByNum()
         */
        $app
            ->get('/dossier-num/{num}', 'ODE_API\V8\Controller\DossierController:getDossierByNum')
            ->add($paramsMiddlewareFactory->bind(Param\DossierNumParam::class));

        /**
         * @category Dossier
         * @internal Suppression d'un dossier par son UUID via l'API Lanteas & API_OAuth.
         * @method   DossierController::deleteDossier()
         */
        $app
            ->delete('/dossier-delete/{id}/{individuId}', 'ODE_API\V8\Controller\DossierController:deleteDossier')
            ->add($paramsMiddlewareFactory->bind(Param\DossierListParams::class));

        /**
         * @category Dossier
         * @internal Récupération d'un dossier par étape via l'API Lanteas & API_OAuth.
         * @method   DossierController::getFormByEtape()
         */
        $app
            ->post('/dossier-form', 'ODE_API\V8\Controller\DossierController:getFormByEtape')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Dossier
         * @internal Récupération d'un dossier au format PDF par son UUID via l'API Lanteas & API_OAuth.
         * @method   DossierController::getDossierFormatPdf()
         */
        $app
            ->get('/dossier-pdf/{id}/{individuId}', 'ODE_API\V8\Controller\DossierController:getDossierFormatPdf')
            ->add($paramsMiddlewareFactory->bind(Param\DossierListParams::class));

        /**
         * @category Dossier
         * @internal Récupération d'un dossier au format PDF par son UUID via l'API Lanteas & API_OAuth.
         * @method   DossierController::getDossierFormatPdf()
         */
        $app
            ->get('/dossier-data/{id}', 'ODE_API\V8\Controller\DossierController:getDossier')
            ->add($paramsMiddlewareFactory->bind(Param\DossierGetParams::class));

        /**
         * @category Dossier
         * @internal Liste des dossiers par Type et Demandeur UUID via l'API Lanteas & API_OAuth.
         * @method   DossierController::getListDossierByDemandeur()
         */
        $app
            ->post('/dossiers', 'ODE_API\V8\Controller\DossierController:getListDossierByDemandeur')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Dossier
         * @internal Récupération du suivi d'un dossier
         * @method   DossierController::getDossiersuivi()
         */
        $app
            ->get('/dossier-suivi/{dossierId}/{id}', 'ODE_API\V8\Controller\DossierController:getDossiersuivi')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSuiviParams::class));


        /**
         * @category Dossier
         * @internal Suppression d'un justificatif via un entrypoint WP
         * @method   DossierController::deleteDossier()
         */
        $app
            ->post('/dossier-justificatif-delete', 'ODE_API\V8\Controller\DossierJustificatifController:deleteJustificatif')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Dossier
         * @internal Création d'un justificatif via un entrypoint WP
         * @method   DossierController::createDossier()
         */
        $app
            ->post('/dossier-justificatif-create', 'ODE_API\V8\Controller\DossierJustificatifController:createJustificatif')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));



        /**
         * @category Documents
         * @internal Liste des documents via l'API Lanteas & API_OAuth.
         * @method   DocumentsController::getListDocuments()
         */
        $app
            ->get('/documents/{moduleName}/{id}', 'ODE_API\V8\Controller\DocumentsController:getListDocuments')
            ->add($paramsMiddlewareFactory->bind(Param\DocumentsListParams::class));


        /**
         * @category Documents
         * @internal retourne le base 64 d un document.
         * @method   DocumentsController::getDocuments()
         */
        $app
            ->get('/telecharger-document/{id}/{individuId}', 'ODE_API\V8\Controller\DocumentsController:getDocument')
            ->add($paramsMiddlewareFactory->bind(Param\DocumentTelechargerParams::class));


        /**
         * @category Documents
         * @internal Récupérations des documents recus des dossiers d'un individus.
         * @method   DocumentsController:getListDocumentsRecus
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->get('/documentsRecus/{moduleName}/{id}', 'ODE_API\V8\Controller\DocumentsController:getListDocumentsRecus')
            ->add($paramsMiddlewareFactory->bind(Param\DocumentsListParams::class));

        /**
         * @category Documents
         * @internal Création d'un document via l'API Lanteas & API_OAuth.
         * @method   DocumentsController::setDocument()
         */
        $app
            ->post('/document', 'ODE_API\V8\Controller\DocumentsController:setDocument')
            ->add($paramsMiddlewareFactory->bind(Param\DocumentsSetParams::class));


        /**
         * @category Tiers
         * @internal Liste des tiers via l'API Lanteas pour un individu par son UUID via l'API Lanteas & API_OAuth.
         * @method   TiersController::getListTiers()
         */
        $app
            ->get('/tiers/{id}', 'ODE_API\V8\Controller\TiersController:getListTiers')
            ->add($paramsMiddlewareFactory->bind(Param\TiersListParams::class));

          /**
         * @category Tiers
         * @internal Gestion des tiers (creation/modification)
         * @method   TiersController::setTiers()
         */
        $app
            ->post('/tiers/', 'ODE_API\V8\Controller\TiersController:setTiers')
            ->add($paramsMiddlewareFactory->bind(Param\TiersEditionParams::class));
       

        /**
         * @category Tiers
         * @internal Détail d'un profil pour un individu par son UUID via l'API Lanteas & API_OAuth.
         * @method   TiersController::getDetailTiers()
         */
        $app
            ->get('/tiers-detail/{id}/{individuId}', 'ODE_API\V8\Controller\TiersController:getDetailTiers')
            ->add($paramsMiddlewareFactory->bind(Param\TiersDetailParams::class));
        
        /**
         * @category Tiers
         * @internal Liste des type tiers
         * @method   TiersController::getTypeTiers()
         */
        $app
            ->get('/tiers-type/', 'ODE_API\V8\Controller\TiersController:getTypeTiers');

        /**
         * @category Tiers
         * @internal Liste des role tiers
         * @method   TiersController::getRoleTiers()
         */
        $app
            ->get('/tiers-role/', 'ODE_API\V8\Controller\TiersController:getRoleTiers');


        /**
         * @category Tiers
         * @internal Détail d'un type tiers
         * @method   TiersController::getTypeTiersInfos()
         */
        $app
            ->get('/tiers-type/{id}', 'ODE_API\V8\Controller\TiersController:getTypeTiersInfos')
            ->add($paramsMiddlewareFactory->bind(Param\TiersTypeInfosParams::class));

        /**
         * @category Tiers
         * @internal Liste des individus via l'API Lanteas pour un individu par son UUID via l'API Lanteas & API_OAuth.
         * @method   TiersController::getListIndividuByTiers()
         */
        $app
            ->get('/tiers-individus/{id}/{individuId}', 'ODE_API\V8\Controller\TiersController:getListIndividuByTiers')
            ->add($paramsMiddlewareFactory->bind(Param\TiersListIndividusParams::class));

        
        /**
         * @category Tiers
         * @internal Liste des individus via l'API Lanteas pour un individu par son UUID via l'API Lanteas & API_OAuth.
         * @method   TiersController::getListIndividuByTiers()
         */
        $app
            ->post('/tiers-update-role', 'ODE_API\V8\Controller\TiersController:UpdateRoleTier')
            ->add($paramsMiddlewareFactory->bind(Param\TiersRoleUpdateParams::class));


        /**
         * @category Tiers
         * @internal Récupération des informations d'un individu
         * @method   TiersController::getListIndividuByTiers()
         */
        $app
            ->get('/tiers-individu/{id}/{individuId}', 'ODE_API\V8\Controller\TiersController:getIndividu')
            ->add($paramsMiddlewareFactory->bind(Param\TiersIndividuDetailParams::class));
        
        /**
         * @category Tiers
         * @internal Gestion des individus (creation/modification)
         * @method   TiersController::setTiers()
         */
        $app
            ->post('/tiers-individu', 'ODE_API\V8\Controller\TiersController:setIndividu')
            ->add($paramsMiddlewareFactory->bind(Param\TiersIndividuEditionParams::class));
       

        /**
         * @category Tiers
         * @internal Gestion des codes de partage (creation/modification)
         * @method   TiersController::setTiers()
         */
        $app
            ->post('/tiers-partage-genere', 'ODE_API\V8\Controller\TiersController:setCode')
            ->add($paramsMiddlewareFactory->bind(Param\TiersIndividuEditionParams::class));


        /**
         * @category Tiers
         * @internal Gestion des codes de partage (creation/modification)
         * @method   TiersController::setTiers()
         */
        $app
            ->post('/tiers-partage-liaison', 'ODE_API\V8\Controller\TiersController:rattacherProfil')
            ->add($paramsMiddlewareFactory->bind(Param\TiersIndividuEditionParams::class));

        /**
         * @category Tiers
         * @internal Gestion des codes de partage (creation/modification)
         * @method   TiersController::setTiers()
         */
        $app
            ->delete('/tiers-partage/{id}', 'ODE_API\V8\Controller\TiersController:deleteCode')
            ->add($paramsMiddlewareFactory->bind(Param\TiersPartageDeleteParams::class));


        /**
         * @category Tiers
         * @internal Liste des codes partagés
         * @method   TiersController::getCodes()
         */
        $app
            ->get('/tiers-partage/{id}/{individuId}', 'ODE_API\V8\Controller\TiersController:getCodes')
            ->add($paramsMiddlewareFactory->bind(Param\TiersListIndividusParams::class));

        /**
         * @category Justificatif
         * @internal Liste des pièces justificatives
         * @method   JusticativeController::getListeJustificatives()
         */
        $app
            ->get('/justificatif-liste/{id}/{dossierId}/{entite}', 'ODE_API\V8\Controller\JustificatifController:getListeJustificatifs')
            ->add($paramsMiddlewareFactory->bind(Param\JustificatifListeParams::class));

        /**
         * @category Justificatif
         * @internal Update des pièces justificatives
         * @method   JustificatifController::updateJustificatifs()
         * <Warning> @todo route must be in slug-format !
         */
        $app
            ->post('/justificatif-update', 'ODE_API\V8\Controller\JustificatifController:updateJustificatifs')
            ->add($paramsMiddlewareFactory->bind(Param\JustificatifUpdateParams::class));

         /**
         * @category Justificatif
         * @internal retourne le base 64 d une piece justificative.
         * @method   DocumentsController::telechargerJustificatif()
         */
        $app
            ->get('/telecharger-piece-justificative/{id}/{dossierId}/{entite}/{individuId}', 'ODE_API\V8\Controller\JustificatifController:telechargerJustificatif')
            ->add($paramsMiddlewareFactory->bind(Param\JustificatifTelechargerParams::class));


        /**
         * @category Notification
         * @internal retourne liste des notifications pour le shortcode type page.
         * @method   NotificationController::getListNotifications()
         */
        $app
            ->get('/notifications-liste/{id}', 'ODE_API\V8\Controller\NotificationController:getListNotifications')
            ->add($paramsMiddlewareFactory->bind(Param\NotificationListParams::class));
        
        /**
         * @category Indicateurs
         * @internal retourne liste des indicateurs pour la page mon compte.
         * @method   NotificationController::getListIndicateurs()
         */
        $app
            ->get('/tuiles-incateurs-liste/{id}', 'ODE_API\V8\Controller\NotificationController:getListIndicateurs')
            ->add($paramsMiddlewareFactory->bind(Param\NotificationListParams::class));
        
        /*
         * Get repertoire entreprise 
         */
        $app
            ->get('/repertoire/{num}', 'ODE_API\V8\Controller\RepertoireEntrepriseController:getEntreprise')
            ->add($paramsMiddlewareFactory->bind(Param\RepertoireEntrepriseParams::class));
        

        /*
         * Hors-Compte : liste des routes pour le Hors-Compte
         */

        /**
         * @category Hors-compte
         * @internal Récupération des dispositifs disponibles en hors-compte
         * @method   HorsCompteController::getListDispositif()
         */
        $app->get('/dispositif-hc', 'ODE_API\V8\Controller\HorsCompteController:getListDispositif');

        /**
         * @category Hors-compte
         * @internal Récupération d'un dossier hors-compte par l"'étape
         * @method   HorsCompteController::getFormByEtape()
         */
        $app
            ->post('/dossier-hc-form', 'ODE_API\V8\Controller\HorsCompteController:getFormByEtape')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Hors-compte
         * @internal Met à jour un dossier hors-compte par l'étape
         * @method   HorsCompteController::updateDossierByEtape()
         */
        $app
            ->post('/dossier-hc-update-etape', 'ODE_API\V8\Controller\HorsCompteController:updateDossierByEtape')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Hors-compte
         * @internal Fonction de création et d'envoi mail d'un code de validation 
         * @method   HorsCompteController::sendCodeValidationHc()
         */
        $app
            ->post('/dossier-hc-code-validation', 'ODE_API\V8\Controller\HorsCompteController:sendCodeValidationHc')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Hors-compte
         * @internal Fonction de vérification de validité du code de validation
         * @method   HorsCompteController::verifCodeValidationHc()
         */
        $app
            ->post('/dossier-hc-verif-code-validation', 'ODE_API\V8\Controller\HorsCompteController:verifCodeValidationHc')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Hors-compte
         * @internal Récupération du détail d'un dossier Hors-compte
         * @method   HorsCompteController::getInfosDossierHc()
         */
        $app
            ->post('/dossier-hc-infos', 'ODE_API\V8\Controller\HorsCompteController:getInfosDossierHc')
            ->add($paramsMiddlewareFactory->bind(Param\DossierSetParams::class));

        /**
         * @category Individu
         * @internal Récupération des masks de saisie de la plateforme
         * @method   IndividuController::getMasking()
         */
        $app
        ->get('/getMasking', 'ODE_API\V8\Controller\IndividuController:getMasking'); 

        /**
         * @category Custom 
         * @internal Groupe l'ensemble de custom routes disponible via <custom/application/Ext/Api/V8/>.
         * @method   CustomLoader::loadCustomRoutes()
         */
        $app->group('/custom', function () use ($app) {
            $app = CustomLoader::loadCustomRoutes($app);
        });

        /***
        * ROUTES POUR LE ADDON FIL DE CONVERSATION
        * */

        /**
         * @category Dossier
         * @internal Récupération des informations d'état d'une conversation
         * @method   ConversationController::fetchConversationState()
         */
        $app
        ->post('/access-conversation/{individuId}', 'ODE_API\V8\Controller\ConversationController:accessConversation')
        ->add($paramsMiddlewareFactory->bind(Param\ListeConversationParams::class));

        /**
        * @category Dossier
        * @internal Récupération des informations d'état d'une conversation
        * @method   ConversationController::fetchConversationState()
        */
        $app
        ->post('/fetch-conversation-state/{individuId}', 'ODE_API\V8\Controller\ConversationController:fetchConversationState')
        ->add($paramsMiddlewareFactory->bind(Param\ListeConversationParams::class));

        /**
        * @category Dossier
        * @internal Récupération des messages d'une conversation
        * @method   ConversationController::fetchMessages()
        */
        $app
        ->post('/fetch-messages/{individuId}', 'ODE_API\V8\Controller\ConversationController:fetchMessages')
        ->add($paramsMiddlewareFactory->bind(Param\ListeConversationParams::class));



        /**
        * @category Dossier
        * @internal Envoi d'un message vers une conversation
        * @method   ConversationController::sendMessage()
        * @routing  /custom/send-message/{individuId}
        * @uses     Normalyzed posted data
        */
        $app
        ->post('/send-message/{individuId}', 'ODE_API\V8\Controller\ConversationController:sendMessage')
        ->add($paramsMiddlewareFactory->bind(Param\ListeConversationParams::class));



        /**
        * @category Dossier
        * @internal Envoi d'un message vers une conversation
        * @method   ConversationController::setMessageStatut()
        * @routing  /custom/set-message-statut/{individuId}
        * @uses     Normalyzed posted data
        */
        $app
        ->post('/set-message-statut/{individuId}', 'ODE_API\V8\Controller\ConversationController:setMessageStatut')
        ->add($paramsMiddlewareFactory->bind(Param\ListeConversationParams::class));




    })->add(new ResourceServerMiddleware($app->getContainer()->get(ResourceServer::class)));
});
