<?php
namespace ODE_API\Core\Loader;

use ODE_API\Core\Config\ApiConfig;
use ODE_API\Core\Resolver\ConfigResolver;
use Slim\App;

class RouteLoader
{
    /**
     * Load all app routes
     *
     * @param App $app
     */
    public function configureRoutes(App $app)
    {
        $routes = ApiConfig::getRoutes();

        foreach ($routes as $route) {
            if (ConfigResolver::isFileExist($route)) {
                require $route;
            }
        }
    }
}
