<?php

/*
 * Positionnement des modules installés en interface non-AJAX
 */
require_once('modules/Configurator/Configurator.php');
$cfg = new Configurator();

// Assurez-vous que les fichiers de langue sont chargés et mis à jour
global $sugar_config, $current_language, $app_list_strings;

// Charger les chaînes de langue pour le langage courant
$app_list_strings = return_app_list_strings_language($current_language);

foreach ($app_list_strings['moduleList'] as $key => $value) {
    // Utiliser strpos pour vérifier si "OPS_" est au début de la clé
    if (strpos($key, 'OPS_') === 0) {
        if (!in_array($key, $cfg->config['addAjaxBannedModules'])){
            $cfg->config['addAjaxBannedModules'][] = $key;
        }
    }
}

if (!in_array('ACLRoles', $cfg->config['addAjaxBannedModules']))
    $cfg->config['addAjaxBannedModules'][] = 'ACLRoles';
if (!in_array('Employees', $cfg->config['addAjaxBannedModules']))
    $cfg->config['addAjaxBannedModules'][] = 'Employees';
if (!in_array('Users', $cfg->config['addAjaxBannedModules']))
    $cfg->config['addAjaxBannedModules'][] = 'Users';
$cfg->handleOverride();

/*
 * Suppression des Dashlets de SuiteCRM
 */
$dashlet_files_array = array(
    "Accounts",  "Connectors",   "Favorites",   "Leads",   "TemplateSectionLine",   "AOW_Processed",   "Contacts",   "FP_Event_Locations",   "LoginAttempts",   "Releases",   "Trackers",   "AOR_Conditions",   "AOW_WorkFlow",   "Currencies",   "FP_events",   "MailMerge",   "Reminders",   "ACLRoles",   "AOR_Fields",   "Audit",   "Delegates",   "Groups",   "Meetings",   "Reminders_Invitees",   "UserPreferences",   "Activities",   "Help",   "MergeRecords",   "ResourceCalendar",   "Users",   "Administration",   "AOR_Scheduled_Reports",   "Bugs",   "History",   "ModuleBuilder",   "Roles",   "Alerts",   "AOS_Contracts",   "Calendar",   "DynamicFields",   "MySettings",   "SavedSearch",   "AOS_Invoices",   "Calls",   "EAPM",   "iCals",   "Notes",   "Schedulers",   "AM_TaskTemplates",   "AOS_Line_Item_Groups",   "Calls_Reschedule",   "EmailAddresses",   "Import",   "OAuthKeys",   "SchedulersJobs",   "AOBH_BusinessHours",   "AOS_PDF_Templates",   "CampaignLog",   "EmailMan",   "InboundEmail",   "OAuthTokens",   "OptimisticLock",   "SecurityGroups",   "AOD_Index",   "AOS_Product_Categories",   "Campaigns",   "EmailMarketing",   "jjwg_Address_Cache",   "Opportunities",   "OutboundEmailAccounts",   "Spots",   "AOD_IndexEvent",   "AOS_Products",   "CampaignTrackers",   "Emails",   "jjwg_Areas",   "Project",   "AOK_KnowledgeBase",   "AOS_Products_Quotes",   "Cases",   "EmailTemplates",   "jjwg_Maps",   "ProjectTask",   "AOK_Knowledge_Base_Categories",   "AOS_Quotes",   "Charts",   "EmailText",   "jjwg_Markers",   "ProspectLists",   "AOP_Case_Events",   "AOW_Actions",   "Configurator",   "Employees",   "LabelEditor",   "Prospects",   "Tasks",   "AM_ProjectTemplates",   "Documents"
);
foreach ($dashlet_files_array as $module_name) {
    if (file_exists('modules/' . $module_name . '/Dashlets')) {
        if (file_exists('modules/' . $module_name . '/_Dashlets')) {
            $dashlet_dir = opendir('modules/' . $module_name . '/Dashlets');
            while (($file = readdir($dashlet_dir)) !== false) {
                if (($file != '.') && ($file != '..'))
                    rename('modules/' . $module_name . '/Dashlets/' . $file, 'modules/' . $module_name . '/_Dashlets/' . $file);
            }
            unlink('modules/' . $module_name . '/Dashlets');
        } else {
            rename('modules/' . $module_name . '/Dashlets', 'modules/' . $module_name . '/_Dashlets');
        }
    }
}

/*
 * Suppression du Studio des modules SuiteCRM
 */
$studio_files_array = array(
    "Accounts",  "Connectors",  "Favorites",  "Leads",  "TemplateSectionLine",  "AOW_Processed",  "Contacts",  "FP_Event_Locations",  "LoginAttempts",  "Releases",  "Trackers",  "AOR_Conditions",  "AOW_WorkFlow",  "Currencies",  "FP_events",  "MailMerge",  "Reminders",  "ACLRoles",  "AOR_Fields",  "Audit",  "Delegates",  "Groups",  "Meetings",  "Reminders_Invitees",  "UserPreferences",  "Activities",  "AOR_Reports",  "Help",  "MergeRecords",  "ResourceCalendar",  "Users",  "Administration",  "AOR_Scheduled_Reports",  "Bugs",  "History",  "ModuleBuilder",  "Roles",  "Alerts",  "AOS_Contracts",  "Calendar",  "DynamicFields",  "Home",  "MySettings",  "SavedSearch",  "AOS_Invoices",  "Calls",  "EAPM",  "iCals",  "Notes",  "Schedulers",  "AM_TaskTemplates",  "AOS_Line_Item_Groups",  "Calls_Reschedule",  "EmailAddresses",  "Import",  "OAuthKeys",  "SchedulersJobs",  "AOBH_BusinessHours",  "AOS_PDF_Templates",  "CampaignLog",  "EmailMan",  "InboundEmail",  "OAuthTokens",  "OptimisticLock",  "SecurityGroups",  "AOD_Index",  "AOS_Product_Categories",  "Campaigns",  "EmailMarketing",  "jjwg_Address_Cache",  "Opportunities",  "OutboundEmailAccounts",  "Spots",  "AOD_IndexEvent",  "AOS_Products",  "CampaignTrackers",  "Emails",  "jjwg_Areas",  "Project",  "AOK_KnowledgeBase",  "AOS_Products_Quotes",  "Cases",  "EmailTemplates",  "jjwg_Maps",  "ProjectTask",  "AOK_Knowledge_Base_Categories", "AOS_Quotes", "Charts", "EmailText", "jjwg_Markers", "ProspectLists", "AOP_Case_Events", "AOW_Actions", "Configurator", "Employees", "LabelEditor", "Prospects", "Documents", "Tasks", "ProjectTemplates"
);
foreach ($studio_files_array as $module_name) {
    if (file_exists('modules/' . $module_name . '/metadata/studio.php')) {
        if (file_exists('modules/' . $module_name . '/metadata/_studio.php'))
            unlink('modules/' . $module_name . '/metadata/_studio.php');
        rename('modules/' . $module_name . '/metadata/studio.php', 'modules/' . $module_name . '/metadata/_studio.php');
    }
}


#1856 : Correctif de la suppression des rôles
global $db;

$query = "UPDATE `acl_actions` SET `deleted` = '0' WHERE `date_modified` BETWEEN ( NOW()-INTERVAL 1 DAY) AND NOW() ORDER BY `date_modified` DESC ;";
$result = $db->query($query);
$query2 = "UPDATE `acl_roles_actions` SET `deleted` = '0' WHERE `date_modified` BETWEEN ( NOW()-INTERVAL 1 DAY) AND NOW() ORDER BY `date_modified` DESC ;";
$result = $db->query($query2);


?>
<br />
<h1>ODE - Open Socle</h1>
<p>
    Installation terminée...
</p>
<p></p>
<h2>Licence</h2>
<pre>
    </pre>
<br /><br />