<?php
/*
 * Gestion des actions retardées
 *
 */

$job_strings[] = 'execution_retarde';

use ODE\ActionStatut\OdeActionStatut;

function execution_retarde()
{
    global $db, $sugar_config, $beanFiles;
    
    $requete = $db->query(
        "SELECT id, ops_action_id, ops_dossier_id, ops_statut_id
        FROM ops_action_retarde
        WHERE deleted = 0
        AND date_declenchement < UTC_TIMESTAMP()
        LIMIT 50"
    );

    $rowResults = array();
    while ($row = $db->fetchRow($requete)) {
        $listeActionRetarde[$row['id']] = $row; 
    }

    foreach ($listeActionRetarde as $actionRetarde) {

        $objDossier = BeanFactory::getBean('OPS_dossier',$actionRetarde['ops_dossier_id']);
        if($actionRetarde['ops_statut_id'] == $objDossier->ops_statut_id){
            $objAction = BeanFactory::getBean('OPS_action_statut',$actionRetarde['ops_action_id']);
            $action_statut = new OdeActionStatut($objAction, $objDossier);
            $action_statut->execute();
            $objActionRetarde = BeanFactory::getBean('OPS_action_retarde',$actionRetarde['id']);
            $objActionRetarde->mark_deleted($actionRetarde['id']);
            $objActionRetarde->save();
        }
        else
        {
            $objStatut = BeanFactory::getBean('OPS_statut', $objDossier->ops_statut_id);
            $objAction = BeanFactory::getBean('OPS_action_statut',$actionRetarde['ops_action_id']);

            $GLOBALS['log']->fatal('Instruction - exécution retardée => statut différent' . PHP_EOL . print_r(array(
                'Num_dossier' => $objDossier->num_dossier,
                'statut' => $objStatut->name,
                'action' => $objAction->name,
            ), true));

            $objActionRetarde = BeanFactory::getBean('OPS_action_retarde',$actionRetarde['id']);
            $objActionRetarde->mark_deleted($actionRetarde['id']);
            $objActionRetarde->save();
        }
    }

    return true;
} 