<?php

$job_strings[] = 'anonymisation_dossier_cloture';

function anonymisation_dossier_cloture(){

    global $db;


    $GLOBALS['log']->fatal(print_r("## LANCEMENT DE LA TÂCHE PLANIFIÉ D'ANONYMISATION DES DOSSIERS",true));

    // fonction anonyme pour factoriser la recherche + creation du profil/individu anonyme
    $recuperationOuCreationAnonyme = function($table, $champ) use ($db) {
        $sql = "SELECT id FROM ops_$table WHERE $champ LIKE '%Anonyme%' AND deleted = 0";
        $res = $db->query($sql);
        $id = $db->fetchRow($res)['id'] ?? false;
    
        if (!$id) {
            $bean = BeanFactory::newBean("OPS_$table");
            $bean->$champ = "ANONYME";
            $bean->save();
            $id = $bean->id;
        }
        return $id;
    };

    // recherche et creation des anonymes
    $idIndividuAnonyme = $recuperationOuCreationAnonyme("individu", "last_name");
    $idProfilAnonyme = $recuperationOuCreationAnonyme("personne_morale", "name");

    /* Recuperation des dossier qui cloturé qui ont dépassé le delai et qui n'ont pas deja été anonymisé */
    /* DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_suppression DAY) < CURDATE() renvoi null si le delai de suppression est a null */
    $sqlDossier = "SELECT 
                ops_dossier_id AS dossierId
            FROM   ops_dispositif_ops_dossier
            INNER JOIN ops_dispositif
                ON ops_dispositif_id = ops_dispositif.id
            INNER JOIN ops_dossier
                ON ops_dossier.id = ops_dossier_id
            WHERE  ops_dispositif_ops_dossier.deleted = 0
            AND ops_dispositif.deleted = 0
            AND ops_dossier.cloture = 1
            AND ops_dossier.flag_anonymise = 0
            AND DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_anonymisation_cloture DAY) < CURDATE()";

    $res = $db->query($sqlDossier);
    
    while ($dossier = $db->fetchByAssoc($res, false)) {
        $GLOBALS['log']->fatal(print_r("# Anonymisation du dossier d'id : " . $dossier['dossierId'],true));

        // recupereation du bean Dossier
        $beanDossier = BeanFactory::getBean("OPS_dossier", $dossier['dossierId']);

        // anonymisation profil et beneficiaire
        if(!empty($beanDossier->ops_personne_morale)) $beanDossier->ops_personne_morale = $idProfilAnonyme;
        if(!empty($beanDossier->beneficiaire_id)) $beanDossier->beneficiaire_id = $idIndividuAnonyme;

        // recuperation de la derniere date de modification avec formatage datetime => cloture du dossier
        $derniereDateModifie = date('Y-m-d H:i:s', strtotime($beanDossier->date_modified));

        $beanDossier->save();

        // anonymisation demandeur
        $beanDossier->load_relationship("ops_individu_ops_dossier");
        $demandeurBean = reset($beanDossier->ops_individu_ops_dossier->getBeans()); // premier bean 
        $beanDossier->ops_individu_ops_dossier->delete($dossier['dossierId'], $demandeurBean); // suppression ancienne relation
        $beanDossier->ops_individu_ops_dossier->add($idIndividuAnonyme); // ajout relation avec anonyme

        // requête pour remettre la derniere date de modification (sans passer par le bean) du dossier sinon on perd la date de cloture du dossier
        $sqlChangementDeDate = "update ops_dossier set flag_anonymise = 1, date_modified = '$derniereDateModifie' where id='" . $dossier['dossierId'] . "'";
        $db->query($sqlChangementDeDate);

    }

    $GLOBALS['log']->fatal(print_r("## FIN DE LA TÂCHE PLANIFIÉ D'ANONYMISATION DES DOSSIERS",true));

    return true;
}