<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/Dashlets/DashletGeneric.php');
require_once('modules/Favorites/Favorites.php');

class MesFavorisDashlet extends DashletGeneric
{

	function __construct($id, $def = null)
	{
		global $app_list_strings;

		$this->seedBean = new Favorites();

		require('modules/Favorites/Dashlets/MesFavorisDashlet/MesFavorisDashlet.data.php');

		parent::__construct($id, $def);

		if (empty($def['title'])) $this->title = translate('LBL_HOMEPAGE_TITLE', 'Favorites');

		$this->searchFields = $dashletData['MesFavorisDashlet']['searchFields'];
		$this->columns = $dashletData['MesFavorisDashlet']['columns'];

		$this->myItemsOnly = true;
		$this->showMyItemsOnly = false;
		$this->displayTpl = 'modules/Favorites/Dashlets/MesFavorisDashlet/MesFavorisDisplay.tpl';

		// On ajoute les informations dans l'infobulle si le module embarque un fichier additionalDetails dans les metadata
		foreach ($app_list_strings['moduleList'] as $module => $label) {
			if (file_exists('custom/modules/' . $module . '/metadata/additionalDetails.php')) {
				$this->with_additional_details[] = $module;
			} else if (file_exists('modules/' . $module . '/metadata/additionalDetails.php')) {
				$this->with_additional_details[] = $module;
			}
		}
	}

	function process($lvsParams = array(), $id = null)
	{
		global $app_list_strings, $app_strings;


		parent::process($lvsParams, $id);

		foreach ($this->lvs->data['data'] as $row => $data) {
			$fav_name_explode = explode(' ', $data['NAME']); // On explose le name du favori qui contient le parent_type et le parent_id séparé par un espace

			$rel_bean = BeanFactory::getBean($fav_name_explode[0], $fav_name_explode[1]);
			$this->lvs->data['data'][$row]['NAME'] = $rel_bean->name;
			$this->lvs->data['data'][$row]['PARENT_TYPE'] = $app_list_strings['moduleList'][$fav_name_explode[0]];
			$this->lvs->data['data'][$row]['PARENT_FOR_LINK'] = $fav_name_explode[0];
			$this->lvs->data['data'][$row]['PARENT_ID'] = $fav_name_explode[1];
			$this->lvs->data['data'][$row]['ID'] = $fav_name_explode[1];
			$this->lvs->data['data'][$row]['span_id'] = $this->id . $rel_bean->id;
			$this->lvs->data['data'][$row]['with_additional_details'] = in_array($data['PARENT_TYPE'], $this->with_additional_details);
		}

		$this->lvs->ss->assign('MoreInfo', $app_strings['LBL_ADDITIONAL_DETAILS']);
	}
}
