var SubPanelQuickActionsDocuments = SubPanelQuickActionsDocuments || {};

SubPanelQuickActionsDocuments = (function ($) {

    const ModalDiffusionParameters = {};
    return {

        /**
        * Fonction qui englobe l'initialisation - nettoyage de la modale et son appel
        *  => Nattoie le contenu de la modale
        *  => Lance son appel (ouverture)
        * 
        * @return @return {void}
        */
        modal_show: function( modal_selector ) {

            ModalDiffusionParameters.modal = $( modal_selector );
            (ModalDiffusionParameters.modal).find( '[role="modal-document-succes"]' ).html( '' );
            (ModalDiffusionParameters.modal).find( '[role="modal-document-error"]' ).html( '' );
            $( ModalDiffusionParameters.modal ).modal();

        },


        /**
        * Fonction de rappel sur le bouton « Continuer » (continuer_diffusion)
        *  => Récupèrer les paramètres de la modale « input[type][data-rel] »
        *  => Lance un Ajax vers une action du controller (swap 'importable' value)
        *  => Récupère le retour d'action pour afficher le statut dans la modale et le refèrme si ok.
        * 
        * @return @return {void}
        */
        modal_continuer_diffusion: function( btn ) {

            ModalDiffusionParameters.modal = $(btn).closest('[role="dialog"]');
            
            (ModalDiffusionParameters.modal).find( 'input[type][data-rel]' ).each( function(i,input){
                param_name = $(input).attr('data-rel');
                param_value = $(input).val();
                ModalDiffusionParameters[ param_name ] = param_value;
            } );

            (ModalDiffusionParameters.modal).find( '[role="modal-document-succes"]' ).html( '' );
            (ModalDiffusionParameters.modal).find( '[role="modal-document-error"]' ).html( '' );

            var data = {};
                data.id           = ModalDiffusionParameters[ 'record' ];
            var url = '/index.php?module=Documents&action=change_diffusion_state';

            window.setTimeout( function(){

                jQuery.post( url, 
                    data
                    ).done(function(dataReturned) {

                        var result = JSON.parse( dataReturned );

                        if( typeof result == 'object' ){

                            switch( result.statut ) {
                                case 'ok':
                                    (ModalDiffusionParameters.modal).find( '[role="modal-document-succes"]' ).html( result.data );

                                    window.setTimeout( function(){
                                    
                                        let sp = window.ModuleSubPanels.Documents[0];
                                        showSubPanel(sp,null,true);
                                        console.warn('Héritage module pour dynamiser « showSubPanel(<module>_documents) »')

                                        $(ModalDiffusionParameters.modal).modal('hide');
                                        $('.modal-backdrop.in').remove(); // The Chery for multi modal instances (;}
                                        $('body').removeClass('modal-open');

                                    } , 1500 );

                                    break;
                                case 'ko':
                                    (ModalDiffusionParameters.modal).find( '[role="modal-document-error"]' ).html( result.data );
                                    break;
                                default:
                                    console.log( data.id , result );
                            }



                        }else{
                            // controller error (string)
                            (ModalDiffusionParameters.modal).find( '[role="modal-document-error"]' ).html("Erreur interne - contacter votre administrateur.");
                            console.warn( result );
                        }

                    }).fail(function(x) {
                        console.log( x );
                        (ModalDiffusionParameters.modal).find( '[role="modal-document-error"]' ).html("Une erreur s'est produite !");
                        return;

                    }).always(function() {
                        

                    });

            } , 250 );



        },

    }

})(jQuery);

