<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


require_once 'modules/Documents/controller.php';
require_once('custom/modules/Documents/Documents_editiques.php');
require_once('custom/modules/Documents/App/tpls/containers/viewer_pdf.php');

class CustomDocumentsController extends DocumentsController
{


    /**
     * Bean that is being handled by the Calendar's current action.
     * @var SugarBean $currentBean
     */
    protected $currentBean = null;


    protected function action_visualisation( )
    {
        $this->view = "visualisation";
    }

    protected function action_create()
    {
        # Création | Modification d'un document éditable.

        // Récuprération si un record id est passé.
        if( isset( $_REQUEST['record'] ) && !empty($_REQUEST['record'])  ){
            
            // Contrôle d'intégrité.
            $record = trim($_REQUEST['record']);

            preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $record, $output_array);

            if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

                $obj_document = BeanFactory::getBean( 'Documents' , $record );
               
                // Navigation Sugar view...
                $this->bean = $obj_document;
                $this->view = "create";

            }

        }
        // Dans le cas contraire, génération du bean Documents.
        else{

            $obj_document = BeanFactory::newBean('Documents');

            // Initialisation...
            $obj_document->corps         = '';
            $obj_document->document_name = "Document";
            $obj_document->origine       = "editique";
            $obj_document->status_id     = "brouillon"; // Warning /!\ (status_id vs status)
            $obj_document->save();

            // On crée en même temps la relation avec le module de référence.
            $name_module = trim( $_REQUEST['name_module'] );
            $id_bean     = trim( $_REQUEST['id_bean'] );
            preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id_bean, $output_array);
            
            if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 
             && !empty($name_module) ){
            
                // Bean module référence (relationship)
                $obj_bean_ref = BeanFactory::getBean( $name_module , $id_bean );
                $obj_document->{strtolower( $name_module ).'_documents'}->add($obj_bean_ref);

                // Navigation Sugar view...
                $this->bean = $obj_document;
                $this->view = "create";

            }


        }

    }

    public function action_cancel_create( )
    {
        
        $data = false;

        // Récupération d'un document éditable
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id'])  ){

            $id = trim( $_REQUEST['id'] );
            preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id, $output_array);

            if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
            
                $obj_document = BeanFactory::getBean( 'Documents' , $id );

                # Épurateur document brouillon ainsi que sa relation avec le module référence (Dossier/Profil/...)

                if( ($obj_document->status_id == "brouillon" || $obj_document->status_id == "") 
                 && $obj_document->origine == "editique" 
                 && $obj_document->corps == "" ){

                    // Tentative de suppression d'un document éditique fraichement créé, si il n'a pas été enregistré (on vient de clicker ANNULER)
                    $data = true;

                    // Suppression de la relation avec le document.
                    try {

                        $module_origin = trim( $_REQUEST['module_origin'] );
                        $record_origin = trim( $_REQUEST['record_origin'] );

                        preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $record_origin, $output_array);
                        
                        if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 
                         && !empty($module_origin) ){

                            // Bean module référence (relationship)
                            $obj_bean_ref = BeanFactory::getBean( $module_origin , $record_origin );

                            $obj_document->load_relationship( strtolower( $module_origin ).'_documents' );
                            $obj_document->{strtolower( $module_origin ).'_documents'}->delete( $obj_bean_ref );

                            // Suppression du document.
                            $obj_document->mark_deleted($id);
                            //$obj_document->save();

                            $data = array( 'statut' => 'ok', 'data' => 'Suppression du Document et de sa relation' );

                        }else{
                            $data = array( 
                                'statut' => 'ko', 
                                'data' => 'Les références au module d\'origine semblent incorrectes. (id: '.$record_origin.', module: '.$module_origin.')' 
                            );
                            CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
                        }

                    } catch (Exception $e) {

                        $data = array( 
                            'statut' => 'ko', 
                            'data' => 'Échec suppression Document et de sa relation' 
                        );
                        CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );

                        ob_clean();
                        echo json_encode($data);
                        sugar_cleanup(true);

                    }

                }

            }else{
                $data = array( 
                    'statut' => 'ko', 
                    'data' => 'L\'id Document « '.$id.' » est incorrect.' 
                );
                CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
            }

        }

        // Used in Ajax call to cutoff the HTTP flow.
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);

    }


## Deprecated !
    /*
    public function action_change_diffusion_state( )
    {
        
        $data = false;

        // Récupération d'un document éditable
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id'])  ){

            $id = trim( $_REQUEST['id'] );
            preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id, $output_array);

            if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){
            
                $obj_document = BeanFactory::getBean( 'Documents' , $id );

                if( $obj_document->origine == "editique" ){

                    $data = true;
                    
                    if( $obj_document->corps != "" ){
                        // Tentative de changement du « importable »
                        $importable = intval( $obj_document->importable );
                        $obj_document->importable = (1 - $importable);
                        $obj_document->save();

                        CustomDocumentsController::_genere_soap_pdf( $obj_document );

                        $data = array( 
                            'statut' => 'ok', 
                            'data' => 'Modification effectuée, génération du document Éditique PDF usager' 
                        );

                    }else{
                        $data = array( 
                            'statut' => 'ko', 
                            'data' => 'Oups! Attention ce document est vide !' 
                        );
                        CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
                    }

                }else{
                    $data = array( 
                        'statut' => 'ko', 
                        'data' => 'Ce Document n\'est pas un document Éditique.'. ' » '.$obj_document->origine 
                    );
                    CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
                }

            }else{
                $data = array( 
                    'statut' => 'ko', 
                    'data' => 'L\'id Document « '.$id.' » est incorrect.' 
                );
                CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
            }

        }

        // Used in Ajax call to cutoff the HTTP flow.
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);

    }
    /**/
## Deprecated !


    public function action_sauvegarde($output = false)
    {
        # Enregistrement du document.

        $data = false;

        // Contrôle d'intégrité...
        if( isset($_REQUEST['id']) && !empty($_REQUEST['id']) && isset($_REQUEST['html_pdf_b64']) ) {

            if( isset($_REQUEST['type_doc_id']) && !empty($_REQUEST['type_doc_id']) ) {

                $id           = trim( $_REQUEST['id'] );
                $html_pdf_b64 = trim( $_REQUEST['html_pdf_b64'] );
                $type_doc_id  = trim( $_REQUEST['type_doc_id'] );

                preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id, $output_array);
                
                // Normalement le type doit être fourni, il a été contrôlé dans la vue avec alerte.
                if( !empty($type_doc_id) ){

                    if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

                        $obj_document = BeanFactory::getBean( 'Documents' , $id );

                        // enregistrement avec peuplement.
                        $obj_document->corps         = ( !empty( $html_pdf_b64 ) )? base64_decode( trim($html_pdf_b64) ) : "<h1>Document Éditique vide lors de l'enregistrement</h1>";
                        // $obj_document->document_name = "Document Éditique"." ".date('Y-m-d')." ".date('His');
                        $obj_document->document_name = "Document_Editique_".date('Y-m-d')."_".date('His').".pdf";

                        $obj_document->status_id     = "nouveau"; // Warning /!\ (On fait attention : 'status_id' vs 'status')
                        $obj_document->ops_type_document_id = $type_doc_id; 

                        $obj_document->corps = html_entity_decode($obj_document->corps);

                        $id = $obj_document->save();

                        CustomDocumentsController::_genere_soap_pdf( $obj_document );
                        
                        $data = array( 'statut' => 'ok', 'data' => 'Enregistrement du Document « '.$id.' » avec succès.' );

                        // Doit-on générer une sortie à la volée après sauvegarde (aperçu par exemple) ?
                        if( $output === true ){

                            $base64 = $obj_document->genere_pdf($id);

                            ob_clean();
                            echo $base64;
                            sugar_cleanup(true);

                        }

                    }else{
                        $data = array( 
                            'statut' => 'ko', 
                            'data' => 'L\'id Document « '.$id.' » passé lors de la sauvegarde est incorrect.' 
                        );
                        CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
                    }

                }else{
                    $data = array( 
                        'statut' => 'ko', 
                        'data' => 'Attention, aucun type de document a été sélectionné. Abandon de la sauvegarde.' 
                    );
                    CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
                }


            }else{
                $data = array( 
                    'statut' => 'ko', 
                    'data' => 'L\'id du Type de document « '.$id.' » passé lors de la sauvegarde est manquant.' 
                );
                CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
            }


        }else{
            $data = array( 
                'statut' => 'ko', 
                'data' => 'L\'id Document « '.$id.' » passé ou le contenu base64 lors de la sauvegarde est manquant.' 
            );
            CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
        }

        // Used in Ajax call to cutoff the HTTP flow.
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);

    }


    public function action_export_format()
    {

        $data = false;

        // Contrôle d'intégrité...
        if( isset($_REQUEST['id']) && !empty($_REQUEST['id']) ){

            $id           = trim( $_REQUEST['id'] );
            $html_pdf_b64 = trim( $_REQUEST['html_pdf_b64'] );
            $format       = trim( $_REQUEST['format'] );

            preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $id, $output_array);
            if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

                $obj_document = BeanFactory::getBean( 'Documents' , $id );

                $allowed_format = array('odt','docx','pdf');
                if( in_array($format, $allowed_format) ){

                    $html_pdf_plain = ( !empty( $html_pdf_b64 ) )? base64_decode( trim($html_pdf_b64) ) : "<h1>Document Éditique vide pour son export</h1>";
                    
                    $_SESSION['editique_html_b64_content'] = base64_encode( $html_pdf_plain );
                    $MAX_FUNC_PARAM_LEN = 1024 * 4; // 4Mo
                    $html_b64_content = (strlen($_SESSION['editique_html_b64_content']) > $MAX_FUNC_PARAM_LEN)? '' : $_SESSION['editique_html_b64_content'];


                    if( class_exists( 'Documents_editiques' ) ){

                        $export = new \stdClass();
                        $export->content   = "";
                        $export->filename  = "";
                        $export->mime      = "";
                        $export->length    = 0;

                        try {

                            $obj_document_editique = new Documents_editiques();
                            $export = $obj_document_editique->export_to_format( $id, $format, $html_b64_content );
                        
                            $data = array( 'statut' => 'ok', 'data' => 'Le Document Éditique au format '.$format.' est exporté.', 'export' => $export ,'format'=>$format);
                            
                        } catch (Exception $e) {
                            
                            $export->error = $e;
                            $data = array( 
                                'statut' => 'ko', 
                                'data'   => 'L\'export du Document Éditique au format '.$format.' a échoué !', 
                                'reason' => 'Il est possible qu\'une incohérence dans la structure ou le formatage du contenu se soit glissée. Vous pouvez peut-être essayer de sauvegarder ce formatage et relancer l\'export au format '.$format.' pour tenter de corriger cette erreur !',
                                'export' => $export,
                                'format'=>$format
                            );
                            CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );

                        }

                    }else{
                        $data = array( 
                            'statut' => 'ko', 
                            'data' => 'La classe maitre « Documents_editiques » n\'est pas disponible pour ce traitement d\'export !' 
                        );
                        CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
                    }

                }else{
                    $data = array( 
                        'statut' => 'ko', 
                        'data' => 'Le format demandé (« '.$format.' ») ne correspond pas au format attendu disponible parmis ['. implode(',', $allowed_format) .'].' 
                    );
                    CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
                }

            }else{
                $data = array( 
                    'statut' => 'ko', 
                    'data' => 'Oups, l\'identification du document Éditique transmis semble invalide « '.$id.' ».' 
                );
                CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
            }

        }else{
            $data = array( 
                'statut' => 'ko', 
                'data' => 'Problème lors de l\'identification du document Éditique par son id non transmis.' 
            );
            CustomDocumentsController::_trace_error( __CLASS__, __LINE__, $data );
        }

        // Used in Ajax call to cutoff the HTTP flow.
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);

    }



    // Explain... Only SOAP generating...
    static private function _genere_soap_pdf( $obj_document ){


        // Génération du document du PDF pour le rendre disponible et téléchargeable par l'usager.
        $pdf = new ViewerPDF(PDF_PAGE_ORIENTATION, 'mm', 'A4', true, 'UTF-8', false);

        $pdf->setFooterFont(array(
            PDF_FONT_NAME_DATA,
            '',
            PDF_FONT_SIZE_DATA
        ));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins(15, 15, 15);
        $pdf->SetFooterMargin(10);
        $pdf->SetAutoPageBreak(true, 10);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setLanguageArray($l);
        $pdf->setCellHeightRatio(1.05);
        $core_fonts = array(
            'courier',
            'helvetica',
            'arial',
            'times',
            'symbol',
            'zapfdingbats'
        );
        $pdf->AddPage();

        # Mini Cleanup.
        # Prepare a properly parsed html input without exotic characters....
        $cleanup_corps = $obj_document->corps;
        $cleanup_corps = preg_replace('/ /', ' ', $cleanup_corps); // ULTRA IMPORTANT

        $cleanup_corps = !empty($cleanup_corps)? $cleanup_corps : "<h1>Document Éditique vide pour sa sauvegarde</h1>";
        $cleanup_corps = trim( $cleanup_corps );

        $cleanup_corps = html_entity_decode( $cleanup_corps );
        
        // Must replace vars in $obj_document->corps ?
        $obj_document_editique = new Documents_editiques();

        # Remplacement via le dictionnaire de champs.
        $cleanup_corps = $obj_document_editique->replace_variable_champs( $obj_document->id, $cleanup_corps );

        // Variables du dictionnaire de champs non traitées.
        $cleanup_corps = $obj_document_editique->replace_unknow_champs( $obj_document->id, $cleanup_corps );

        $cleanup_corps = html_entity_decode( $cleanup_corps );

        $cleanup_corps = mb_convert_encoding($cleanup_corps, 'HTML-ENTITIES', 'UTF-8');

        # Convertir les caractères spéciaux
        $special_char = array(
            '&#769;' => 'acute;', 
            '&#770;' => 'circ;',
            '&#768;' => 'grave;',
        );

        foreach($special_char as $encoded_char => $decoded_char)
        {
            $pattern = '/[aeiouyAEIOUY]' . $encoded_char . '/u';

            if(preg_match_all($pattern, $cleanup_corps, $matches))
            {
                foreach($matches[0] as $matche)
                {
                    $char = $matche[0];
                    $cleanup_corps = str_replace($char . $encoded_char, '&' . $char . $decoded_char, $cleanup_corps);
                }
            }
        }
        
        $pdf->writeHTML($cleanup_corps, true, false, true, false, '');
        $file_location = $_SERVER['DOCUMENT_ROOT'] . '/upload/tmp-editique-' . $obj_document->id;
        $pdf->Output($file_location, 'F');

        $encodedFile = file_get_contents($file_location);
        $decodedFile = base64_encode(file_get_contents($file_location));

        unlink($file_location);

        // Création de la révision et de l'association du document au compte l'usager...
        require_once('modules/Documents/DocumentSoap.php');
        $obj_document_soap = new DocumentSoap();

        $filename = "Document_Editique_".date('Y-m-d')."_".date('His').".pdf";

        // Correctif set_for_soap doit recevoir un source code de type original et non encodé base64 !
        $obj_document_soap->upload_file->set_for_soap($filename, $encodedFile);
        // $GLOBALS['log']->fatal("action_change_diffusion_state - [DocumentSoap] (upload_file) \n". print_r( $obj_document_soap->upload_file ,true) );

        $obj_document_soap->upload_file->file_ext = pathinfo( $obj_document_soap->upload_file->stored_file_name , PATHINFO_EXTENSION);
        // $GLOBALS['log']->fatal("action_change_diffusion_state - [DocumentSoap] (upload_file) ". "passed" );

        $revision                 = new DocumentRevision();
        $revision->filename       = $obj_document_soap->upload_file->get_stored_file_name();
        $revision->file_mime_type = $obj_document_soap->upload_file->getMimeSoap($revision->filename);
        $revision->file_ext       = $obj_document_soap->upload_file->file_ext;
        //$revision->document_name = ;
        $revision->revision       = '1';
        $revision->document_id    = $obj_document->id;
        $revision->save();

        $obj_document->document_revision_id = $revision->id;
        $obj_document->save();

        // $GLOBALS['log']->fatal("action_change_diffusion_state - [DocumentRevision] (revision) \n". print_r( $revision->id ,true) );
        $obj_document_soap->upload_file->final_move($revision->id);

    }



    // Trace les erreurs de traitement ou de génération sur le document.
    static private function _trace_error( $class_name, $error_line, $error ){

        $GLOBALS['log']->fatal("« Éditique » [". $class_name ." (L.".$error_line.")]\n" . print_r([
            "statut" => $error['statut'],
            "data"   => $error['data'],
        ], true));

    }




// TODO : Remove this old deprecated function...
    public function action_genere_doc()
    {

        $obj_document = new Document();

        if (isset($_REQUEST['record']) && !empty($_REQUEST['record'])) {
            $obj_document->retrieve($_REQUEST['record']);
            
            $obj_document->corps = "";
            if( isset( $_REQUEST['html_pdf_b64'] ) && !empty( $_REQUEST['html_pdf_b64'] ) ){
                $obj_document->corps =  base64_decode( trim($_REQUEST['html_pdf_b64']) );
            }

            $id = $obj_document->save();
        }

        if (isset($_REQUEST['type']) && !empty($_REQUEST['type']) && $_REQUEST['type'] === "doc") {
            $obj_document->genere_doc_word($id);
        } else {
            $obj_document->genere_doc($id);
        }
    }



}
