var RoutingView = RoutingView || {};

RoutingView = (function ($) {
  var resultat; 
  var history = [];
  const root = "/";

  return {

    ui_message:'',

    /**
     * Fonction d'initialisation du RoutingView 
     *  => Initialise le click sur les boutons
     *  => Redirige vers la page home "/"
     * 
     * @return @return {void}
     */
    start: function() {
      void this.buildNavigationSide( '[role="page"][data-route="/"]  [id="list-generic-container"]' );
      void this.fillSelectFilter( '[role="page"][data-route="/"]  #filter-generic' );
      void this.bindSelectFilter( '[role="page"][data-route="/"]  #filter-generic' );
      void this.bindButtonProcess( '[role="page"]  [role="navigation"][rel]' );
      void this.applyRelatedTypeDocument();
      void this.navigate(root);
    },


    /**
     * Fonction qui initialise le volet de navigation et peuple la page racine.
     *
     * @return @return {void}
     */
    buildNavigationSide: function( _controler_path ) {
      const self = this;

      let Navigation = JSON.parse( $('#navigation_items' ).val() || '[]' );

      $( Navigation ).each(function( i, item ) {

        // 'id'        => $modele['id'],
        // 'slug'      => $this->slugify( $modele['name'] ),
        // 'label'     => $modele['name'],
        // 'type'      => $modele['type'],
        // 'icon'      => $modele['icone'],
        // 'type_id'   => $modele['type_id'],
        // 'type_name' => $modele['type_name'],
        // 'content'   => $modele['description'],

        $nav_button = $(`<button role="navigation" type="button" data-caption="${item.label}">
          <div class="caption">
            <span>${item.label}</span>
            <span class="desc">
              <i class="fa fa-${item.icon}" style="float: left;margin-right: 6%;margin-top: 1%;"></i>
              <span class="desc">${item.type_name}</span>
            </span>
          </div>
          </button>`);

        $nav_button.attr('data-route', '/'+item.route );
        $nav_button.attr('bean-id', item.id );
        $nav_button.attr('rel', item.type_id );
        $nav_button.addClass( 'btn btn-outline-primary btn-lg btn-block g-page-btn' );
        $nav_button.css( {'text-align':'left'} );

        $( _controler_path ).append( $nav_button );


      });

    },



    /**
     * Fonction qui initialise le volet de navigation et peuple la page racine.
     *
     * @return @return {void}
     */
    fillSelectFilter: function( _controler_path ) {
      const self = this;

      let Filtres = JSON.parse( $('#filtres_items' ).val() || '[]' );
      let FiltresOptions = {};

      $( Filtres ).each(function( i, item ) {

        // 'id'      => $filtre['id'],
        // 'label'   => $filtre['name'],

        $filter_option = $(`<option> ${item.label}</option>`);

        $filter_option.attr('value', item.id );
        $filter_option.val( item.id );

        $( _controler_path ).append( $filter_option );

      });

    },



    /**
     * Fonction qui initialise le onclick sur les boutons de navigation
     *
     * @return @return {void}
     */
    bindSelectFilter: function( _controler_path ) {
      const self = this;

      $( _controler_path ).each(function() {
        $(this).off().on( 'click change', function(e){ 

          // Apply sub-filtering on Modèle...
          let precision = String($('#filter-model-precision').val()).trim();
          let relation  = String($(e.currentTarget).val()).trim();
          //console.info( {'precision':precision, 'relation':relation} );

          $('[role="no-result"]').hide();

          if( relation == '*' ){

            if( precision != '' ){

              $('#list-generic-container').find('button[role="navigation"][rel]').each( function(i,o) {

                if( new RegExp('' + precision, 'gi').test( $(o).attr('data-caption') ) ){
                  $(o).fadeIn(120);
                }else{
                  $(o).hide();
                }

              } );

            }else{
              $('#list-generic-container').find('button[role="navigation"][rel]').fadeIn(120);
            }


          }else{

            if( precision != '' ){

              $('#list-generic-container').find('button[role="navigation"][rel]').each( function(i,o) {

                if( $(o).attr('rel') == relation && new RegExp('' + precision, 'gi').test( $(o).attr('data-caption') ) ){
                  $(o).fadeIn(120);
                }else{
                  $(o).hide();
                }

              } );

            }else{

              $('#list-generic-container').find('button[role="navigation"][rel]').each( function(i,o) {

                if( $(o).attr('rel') == relation ){
                  $(o).fadeIn(120);
                }else{
                  $(o).hide();
                }

              } );

            }


          }


          // On notifie si aucun modèle n'est disponible.
          if( $('#list-generic-container').find('button[role="navigation"][rel]').filter(':visible').length == 0 ){
            $('[role="no-result"]').fadeIn(120);
            $('[role="label-models"] em').html( "" );
          }
          else{
            let nb_models = $('#list-generic-container').find('button[role="navigation"][rel]').filter(':visible').length
            let nb_s = (nb_models>1)? 's':'';
            $('[role="label-models"] em').html( `(${nb_models} filtré${nb_s})` );

          }
          
        });
      });

      // Precision filtering action.
      $('#filter-model-precision').off().on( 'keyup click change', function(e){ $( _controler_path ).trigger('click'); } );

      // Precision filtering clearing.
      $('#clear-filter-model-precision').off().on( 'click', function(e){ $('#filter-model-precision').val(''); $( _controler_path ).trigger('click'); } );

      $( _controler_path ).trigger('click');

    },



    /**
     * Fonction qui initialise le onclick sur les boutons de navigation
     *
     * @return @return {void}
     */
    bindButtonProcess: function( _controler_path ) {
      
      const self = this;
      
      $( _controler_path ).each(function() {

        $(this).off().on( 'click', function(){ 
        
          var rel_bean_id = $(this).attr('bean-id');
          ContentManager.insertDescription( rel_bean_id );

          var rel_type_id = $(this).attr('rel');
          RoutingView.setRelatedTypeDocument( rel_type_id );

        });

      });

    },



    /**
     * Fonction qui défini quel type de document rattaché au modèle est utilisé.
     *
     * @return @return {void}
     */
    setRelatedTypeDocument: function( rel_type_id ) {
      
      const self = this;

      $('#rel_type').val( rel_type_id );
      void RoutingView.applyRelatedTypeDocument();

    },



    /**
     * Fonction qui défini quel type de document rattaché au modèle est utilisé.
     *
     * @return @return {void}
     */
    applyRelatedTypeDocument: function() {
      
      const self = this;

      const SelectFilter = $( '[role="page"][data-route="/"]  #filter-generic' );
      var rel_type_id = $('#rel_type').val();

      if( SelectFilter.find('option[value="'+rel_type_id+'"]').length == 1 ){
      
        $('[role="related-type-document"]').html( SelectFilter.find('option[value="'+rel_type_id+'"]').html() );

      }else{

          // Le type en rrlation avec ce Document Éditique n'a pas été trouvé dans la liste du filtre..
          // Le type a éventuellement été supprimé / désactivé ou n'était pas encore disponible car modifié par la vue meta.
          $('[role="related-type-document"]').html( $('#rel_type_label').val() );

          alert_message = "";
          if( $('#rel_type_statut').val() == 0 ){
            alert_message += "• Le type de document associé à ce Document Éditique a été désactivé entre-temps.\n";
          }
          if( $('#rel_type_deleted').val() == 1 ){
            alert_message += "• Le type de document associé à ce Document Éditique a été marqué supprimé entre-temps.\n";
          }

          if(alert_message){
            self.ui_message += "Attention !\n" + alert_message +"\n";
          }

      }

    },


    /**
     * Fonction de navigation entre les differentes pages
     *
     * @param {string} route La route de destination
     * @return {void} 
     */
    navigate: function(route) {

      const self = this;

      if( route != "parametre" && route != "/" ){

          Loading.addSpinner();

          var param =  route.replace('/', '');

          $("[role=page]").each(function() {
            $( this ).hide();
          });
          $('[role=page][rel="generic"]').fadeIn(400);

          Loading.removeSpinner();

      }else{

        $("[role=page]").each(function() {
          ( $( this ).attr( "data-route" ) === route ) ? $( this ).fadeIn(400) : $( this ).hide(); 
        });
        
      }


      // Alerte l'agent si préalablement un message a été renseigné.
      // Ce message arrive ici et non pendant le binding afin de laisser la vue s'afficher proprement (easing/fade/peuplement).
      if( self.ui_message != "" ){
        setTimeout( function(){ alert(self.ui_message); } , 750 );
      }



    },

  }

})(jQuery, ContentManager);


