<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty = new Sugar_Smarty();
$errors = array();

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    // DOCUMENTS
    if (isset($_REQUEST['notif_usager_document_profil'])) {
        $configuratorObj->config['opensocle']['notif_usager_document_profil'] = $_REQUEST['notif_usager_document_profil'];
    }
    if (isset($_REQUEST['notif_usager_document_individu'])) {
        $configuratorObj->config['opensocle']['notif_usager_document_individu'] = $_REQUEST['notif_usager_document_individu'];
    }
    if (isset($_REQUEST['notif_usager_document_dossier'])) {
        $configuratorObj->config['opensocle']['notif_usager_document_dossier'] = $_REQUEST['notif_usager_document_dossier'];
    }

    // DOSSIERS
    if (isset($_REQUEST['notif_usager_dossier_creation'])) {
        $configuratorObj->config['opensocle']['notif_usager_dossier_creation'] = $_REQUEST['notif_usager_dossier_creation'];
    }
    if (isset($_REQUEST['notif_usager_dossier_hc_creation'])) {
        $configuratorObj->config['opensocle']['notif_usager_dossier_hc_creation'] = $_REQUEST['notif_usager_dossier_hc_creation'];
    }
    if (isset($_REQUEST['notif_usager_dossier_suppression'])) {
        $configuratorObj->config['opensocle']['notif_usager_dossier_suppression'] = $_REQUEST['notif_usager_dossier_suppression'];
    }
    if (isset($_REQUEST['notif_usager_dossier_avant_suppression'])) {
        $configuratorObj->config['opensocle']['notif_usager_dossier_avant_suppression'] = $_REQUEST['notif_usager_dossier_avant_suppression'];
    }
    if (isset($_REQUEST['notif_usager_dossier_nouveau_msg_conversation'])) {
        $configuratorObj->config['opensocle']['notif_usager_dossier_nouveau_msg_conversation'] = $_REQUEST['notif_usager_dossier_nouveau_msg_conversation'];
    }


    // JUSTIFICATIFS
    if (isset($_REQUEST['notif_usager_justificatif_dossier_nouveau'])) {
        $configuratorObj->config['opensocle']['notif_usager_justificatif_dossier_nouveau'] = $_REQUEST['notif_usager_justificatif_dossier_nouveau'];
    }
    if (isset($_REQUEST['notif_usager_justificatif_dossier_rejet'])) {
        $configuratorObj->config['opensocle']['notif_usager_justificatif_dossier_rejet'] = $_REQUEST['notif_usager_justificatif_dossier_rejet'];
    }
    if (isset($_REQUEST['notif_usager_justificatif_profil_nouveau'])) {
        $configuratorObj->config['opensocle']['notif_usager_justificatif_profil_nouveau'] = $_REQUEST['notif_usager_justificatif_profil_nouveau'];
    }
    if (isset($_REQUEST['notif_usager_justificatif_profil_rejet'])) {
        $configuratorObj->config['opensocle']['notif_usager_justificatif_profil_rejet'] = $_REQUEST['notif_usager_justificatif_profil_rejet'];
    }

    // PARTAGE
    if (isset($_REQUEST['notif_usager_partage_activation'])) {
        $configuratorObj->config['opensocle']['notif_usager_partage_activation'] = $_REQUEST['notif_usager_partage_activation'];
    }
    if (isset($_REQUEST['notif_usager_partage_revocation'])) {
        $configuratorObj->config['opensocle']['notif_usager_partage_revocation'] = $_REQUEST['notif_usager_partage_revocation'];
    }

    // PROFILS
    if (isset($_REQUEST['notif_usager_profil_creation'])) {
        $configuratorObj->config['opensocle']['notif_usager_profil_creation'] = $_REQUEST['notif_usager_profil_creation'];
    }
    if (isset($_REQUEST['notif_usager_profil_modification'])) {
        $configuratorObj->config['opensocle']['notif_usager_profil_modification'] = $_REQUEST['notif_usager_profil_modification'];
    }

    // COMPTE USAGER
    if (isset($_REQUEST['notif_non_utilisation_compte'])) {
        $configuratorObj->config['opensocle']['notif_non_utilisation_compte'] = $_REQUEST['notif_non_utilisation_compte'];
    }
    if (isset($_REQUEST['notif_usager_connexion'])) {
        $configuratorObj->config['opensocle']['notif_usager_connexion'] = $_REQUEST['notif_usager_connexion'];
    }

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index');

}

// Récupération des modèles d'email
$email_templates_arr = get_bean_select_array(true, 'EmailTemplate', 'name', '', 'name', true);

// DOCUMENTS
$SELECT_NOTIF_USAGER_DOCUMENT_PROFIL = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_document_profil']);
$sugar_smarty->assign("NOTIF_USAGER_DOCUMENT_PROFIL", $SELECT_NOTIF_USAGER_DOCUMENT_PROFIL);
$SELECT_NOTIF_USAGER_DOCUMENT_INDIVIDU = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_document_individu']);
$sugar_smarty->assign("NOTIF_USAGER_DOCUMENT_INDIVIDU", $SELECT_NOTIF_USAGER_DOCUMENT_INDIVIDU);
$SELECT_NOTIF_USAGER_DOCUMENT_DOSSIER = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_document_dossier']);
$sugar_smarty->assign("NOTIF_USAGER_DOCUMENT_DOSSIER", $SELECT_NOTIF_USAGER_DOCUMENT_DOSSIER);

// DOSSIERS
$SELECT_NOTIF_USAGER_DOSSIER_CREATION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_dossier_creation']);
$sugar_smarty->assign("NOTIF_USAGER_DOSSIER_CREATION", $SELECT_NOTIF_USAGER_DOSSIER_CREATION);
$SELECT_NOTIF_USAGER_DOSSIER_HC_CREATION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_dossier_hc_creation']);
$sugar_smarty->assign("NOTIF_USAGER_DOSSIER_HC_CREATION", $SELECT_NOTIF_USAGER_DOSSIER_HC_CREATION);
$SELECT_NOTIF_USAGER_DOSSIER_SUPPRESSION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_dossier_suppression']);
$sugar_smarty->assign("NOTIF_USAGER_DOSSIER_SUPPRESSION", $SELECT_NOTIF_USAGER_DOSSIER_SUPPRESSION);
$SELECT_NOTIF_USAGER_DOSSIER_AVANT_SUPPRESSION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_dossier_avant_suppression']);
$sugar_smarty->assign("NOTIF_USAGER_DOSSIER_AVANT_SUPPRESSION", $SELECT_NOTIF_USAGER_DOSSIER_AVANT_SUPPRESSION);
$NOTIF_USAGER_DOSSIER_NOUVEAU_MSG_CONVERSATION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_dossier_nouveau_msg_conversation']);
$sugar_smarty->assign("NOTIF_USAGER_DOSSIER_NOUVEAU_MSG_CONVERSATION", $NOTIF_USAGER_DOSSIER_NOUVEAU_MSG_CONVERSATION);

// JUSTIFICATIFS
$SELECT_NOTIF_USAGER_JUSTIFICATIF_DOSSIER_NOUVEAU = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_justificatif_dossier_nouveau']);
$sugar_smarty->assign("NOTIF_USAGER_JUSTIFICATIF_DOSSIER_NOUVEAU", $SELECT_NOTIF_USAGER_JUSTIFICATIF_DOSSIER_NOUVEAU);
$SELECT_NOTIF_USAGER_JUSTIFICATIF_DOSSIER_REJET = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_justificatif_dossier_rejet']);
$sugar_smarty->assign("NOTIF_USAGER_JUSTIFICATIF_DOSSIER_REJET", $SELECT_NOTIF_USAGER_JUSTIFICATIF_DOSSIER_REJET);
$SELECT_NOTIF_USAGER_JUSTIFICATIF_PROFIL_NOUVEAU = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_justificatif_profil_nouveau']);
$sugar_smarty->assign("NOTIF_USAGER_JUSTIFICATIF_PROFIL_NOUVEAU", $SELECT_NOTIF_USAGER_JUSTIFICATIF_PROFIL_NOUVEAU);
$SELECT_NOTIF_USAGER_JUSTIFICATIF_PROFIL_REJET = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_justificatif_profil_rejet']);
$sugar_smarty->assign("NOTIF_USAGER_JUSTIFICATIF_PROFIL_REJET", $SELECT_NOTIF_USAGER_JUSTIFICATIF_PROFIL_REJET);

// PARTAGE
$SELECT_NOTIF_USAGER_PARTAGE_ACTIVATION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_partage_activation']);
$sugar_smarty->assign("NOTIF_USAGER_PARTAGE_ACTIVATION", $SELECT_NOTIF_USAGER_PARTAGE_ACTIVATION);
$SELECT_NOTIF_USAGER_PARTAGE_REVOCATION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_partage_revocation']);
$sugar_smarty->assign("NOTIF_USAGER_PARTAGE_REVOCATION", $SELECT_NOTIF_USAGER_PARTAGE_REVOCATION);

// PROFILS
$SELECT_NOTIF_USAGER_PROFIL_CREATION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_profil_creation']);
$sugar_smarty->assign("NOTIF_USAGER_PROFIL_CREATION", $SELECT_NOTIF_USAGER_PROFIL_CREATION);
$SELECT_NOTIF_USAGER_PROFIL_MODIFICATION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_profil_modification']);
$sugar_smarty->assign("NOTIF_USAGER_PROFIL_MODIFICATION", $SELECT_NOTIF_USAGER_PROFIL_MODIFICATION);

$SELECT_NOTIF_NON_UTILISATION_COMPTE = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_non_utilisation_compte']);
$sugar_smarty->assign("NOTIF_NON_UTILISATION_COMPTE", $SELECT_NOTIF_NON_UTILISATION_COMPTE);

$SELECT_NOTIF_USAGER_CONNEXION = get_select_options_with_id($email_templates_arr, $configuratorObj->config['opensocle']['notif_usager_connexion']);
$sugar_smarty->assign("NOTIF_USAGER_CONNEXION", $SELECT_NOTIF_USAGER_CONNEXION);


$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);

$sugar_smarty->clearCache('custom/modules/Administration/ops_notifications_usagers.tpl');
$sugar_smarty->display('custom/modules/Administration/ops_notifications_usagers.tpl');