<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user))
    sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty = new Sugar_Smarty();
$errors = array();

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {
    # CODE DE SUIVI
    $configuratorObj->config['ops_hors_compte']['longueur_code'] = $_REQUEST['hors_compte_longueur_code'];
    if ($_REQUEST['hors_compte_code_chiffres']) {
        $configuratorObj->config['ops_hors_compte']['code_chiffres'] = 1;
    } else {
        $configuratorObj->config['ops_hors_compte']['code_chiffres'] = 0;
    }

    if ($_REQUEST['hors_compte_code_minuscules']) {
        $configuratorObj->config['ops_hors_compte']['code_minuscules'] = 1;
    } else {
        $configuratorObj->config['ops_hors_compte']['code_minuscules'] = 0;
    }

    if ($_REQUEST['hors_compte_code_majuscules']) {
        $configuratorObj->config['ops_hors_compte']['code_majuscules'] = 1;
    } else {
        $configuratorObj->config['ops_hors_compte']['code_majuscules'] = 0;
    }

    if ($_REQUEST['hors_compte_code_special_char']) {
        $configuratorObj->config['ops_hors_compte']['special_char'] = 1;
    } else {
        $configuratorObj->config['ops_hors_compte']['special_char'] = 0;
    }

    if ($_REQUEST['hors_compte_code_eviter_char_ambigus']) {
        $configuratorObj->config['ops_hors_compte']['eviter_char_ambigus'] = 1;
    } else {
        $configuratorObj->config['ops_hors_compte']['eviter_char_ambigus'] = 0;
    }

    # CODE DE VALIDATION
    $configuratorObj->config['ops_hors_compte']['temps_expiration_code_validation'] = $_REQUEST['temps_expiration_code_validation'];

    if (isset($_REQUEST['modele_mail_validation'])) {
        $configuratorObj->config['ops_hors_compte']['modele_mail_validation'] = $_REQUEST['modele_mail_validation'];
    }
    $configuratorObj->config['ops_hors_compte']['longueur_code_validation'] = $_REQUEST['hors_compte_longueur_code_validation'];

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index');
}

# CODE DE SUIVI
$sugar_smarty->assign('LONGUEUR_CODE_SUIVI', get_select_options_with_id($app_list_strings['hc_longueur_code_suivi'], $configuratorObj->config['ops_hors_compte']['longueur_code']));
$sugar_smarty->assign('CODE_CHIFFRES', $configuratorObj->config['ops_hors_compte']['code_chiffres']);
$sugar_smarty->assign('CODE_MINUSCULES', $configuratorObj->config['ops_hors_compte']['code_minuscules']);
$sugar_smarty->assign('CODE_MAJUSCULES', $configuratorObj->config['ops_hors_compte']['code_majuscules']);
$sugar_smarty->assign('SPECIAL_CHAR', $configuratorObj->config['ops_hors_compte']['special_char']);
$sugar_smarty->assign('EVITER_CHAR_AMBIGUS', $configuratorObj->config['ops_hors_compte']['eviter_char_ambigus']);

# CODE DE VALIDATION
$sugar_smarty->assign("TEMPS_EXPIRATION_VALIDATION", $configuratorObj->config['ops_hors_compte']['temps_expiration_code_validation']);
$email_templates_arr = get_bean_select_array(true, 'EmailTemplate', 'name', '', 'name', true);
$select_notif_code_validation = get_select_options_with_id($email_templates_arr, $configuratorObj->config['ops_hors_compte']['modele_mail_validation']);
$sugar_smarty->assign("NOTIF_VALIDATION", $select_notif_code_validation);
$sugar_smarty->assign('LONGUEUR_CODE_VALIDATION', get_select_options_with_id($app_list_strings['hc_longueur_code_validation'], $configuratorObj->config['ops_hors_compte']['longueur_code_validation']));

$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("JAVASCRIPT", get_set_focus_js());
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clearCache('custom/modules/Administration/ops_hors_compte.tpl');
$sugar_smarty->display('custom/modules/Administration/ops_hors_compte.tpl');
