<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ExerciceModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe ExerciceModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du exercice en tableau
     *
     *  @return array               - $exercice: exercice
     */
    public function getBean()
    {

        global $db;
        $exercices = array();

        $sql = "SELECT * FROM `ops_exercice` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $exercices[] = $row;
        }
        return (!empty($exercices) && count($exercices) === 1) ? $exercices[0] : array();
    }

    /**
     * @access public
     * @name getName()
     * Fonction qui retourne le nom de l'exercice
     *
     *  @return array               - $exercice_name: le nom de la exercice
     */
    public function getName()
    {
        $exercice = $this->getBean();
        return ( is_array($exercice) && count($exercice) > 0 && !empty($exercice["name"]) ) ? $exercice['name'] : "";
    }
    
}
