<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class EluModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe EluModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du elu en tableau
     *
     *  @return array               - $elu: elu
     */
    public function getBean()
    {

        global $db;
        $elus = array();

        $sql = "SELECT * FROM `ops_elu` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $elus[] = $row;
        }
        return (!empty($elus) && count($elus) === 1) ? $elus[0] : array();
    }

    /**
     * @access public
     * @name getNomComplet()
     * Fonction qui retourne le type de demandeur du dossier
     *
     *  @return array               - $demandeur_type : le type de demandeur "Individu" ou "Personne Morale"
     */
    public function getNomComplet()
    {

        $elu = $this->getBean();
        return (!empty($elu) && count($elu) > 0 && !empty($elu['first_name']) && !empty($elu['last_name']))
            ? $elu['salutation'] . " " . $elu['first_name'] . " " . $elu['last_name']
            : "";
    }
}
