<?php

namespace ODE\Model;

use ODE\Model\DossierModel;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DemandeurModel
{

    private $id;
    private $type;

    /**
     * Constructeur de la classe DemandeurModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id = null, $type = null)
    {

        $this->id = $id;
        $this->type = $type;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du individu en tableau
     *
     *  @return array               - $individu: individu
     */
    public static function getName($id, $type)
    {
        global $db;
        $demandeurs = [];

        if ($type === "OPS_personne_morale") {
            $sql = " SELECT `name` FROM `ops_personne_morale` WHERE `id` = '" . $id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $demandeurs[] = $row;
            }
            return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['name'] : "";
        }

        if ($type === "OPS_individu") {
            $sql = " SELECT * FROM `ops_individu` WHERE `id` = '" . $id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $demandeurs[] = $row;
            }
            return (!empty($demandeurs) && count($demandeurs) === 1) ? $demandeurs[0]['salutation'] . " " . $demandeurs[0]['first_name'] . " " . $demandeurs[0]['last_name'] : "";
        }

        return "";
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du individu en tableau
     *
     *  @return array               - $individu: individu
     */
    public static function getDossiers($id, $type)
    {

        global $db;
        $dossiers = [];

        if ($type === "OPS_personne_morale") {
            $sql = "SELECT * FROM `ops_dossier` WHERE `id` IN ( SELECT `ops_personne_morale` FROM `ops_dossier` WHERE `ops_personne_morale` = '" . $id . "' AND `deleted` = '0' ) AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $dossiers[] = $row;
            }
        }

        if ($type === "OPS_individu") {
            $sql = "SELECT * FROM `ops_dossier` WHERE `id` IN ( SELECT `ops_dossier_id` FROM `ops_individu_ops_dossier` WHERE `ops_individu_id` = '" . $id . "' AND `deleted` = '0' ) AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $dossiers[] = $row;
            }
        }

        if (count($dossiers) > 0) {
            foreach ($dossiers as $key => $dossier) {
                if (isset($dossier["champs_custom"])) {
                    // On recupere les champs custom decodé
                    $dossierModel = new DossierModel($dossier["id"]);
                    $champs_custom = $dossierModel->getCustomChamps();
                    if (is_array($champs_custom) && count($champs_custom) > 0) {
                        $dossier = array_merge($dossier, $champs_custom);
                    }
                    unset($dossier["champs_custom"]);
                    $dossiers[$key] = $dossier;
                }
            }
        }

        return (!empty($dossiers) && count($dossiers) > 0) ? $dossiers : [];
    }
}
