var Base64 = {
 
	// private property
	_keyStr : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
 
	// public method for encoding
	encode : function (input) {
		var output = "";
		var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
		var i = 0;
 
		input = Base64._utf8_encode(input);
 
		while (i < input.length) {
 
			chr1 = input.charCodeAt(i++);
			chr2 = input.charCodeAt(i++);
			chr3 = input.charCodeAt(i++);
 
			enc1 = chr1 >> 2;
			enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
			enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
			enc4 = chr3 & 63;
 
			if (isNaN(chr2)) {
				enc3 = enc4 = 64;
			} else if (isNaN(chr3)) {
				enc4 = 64;
			}
 
			output = output +
			this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
			this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
 
		}
 
		return output;
	},
 
	// public method for decoding
	decode : function (input) {
		var output = "";
		var chr1, chr2, chr3;
		var enc1, enc2, enc3, enc4;
		var i = 0;
 
		input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
 
		while (i < input.length) {
 
			enc1 = this._keyStr.indexOf(input.charAt(i++));
			enc2 = this._keyStr.indexOf(input.charAt(i++));
			enc3 = this._keyStr.indexOf(input.charAt(i++));
			enc4 = this._keyStr.indexOf(input.charAt(i++));
 
			chr1 = (enc1 << 2) | (enc2 >> 4);
			chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
			chr3 = ((enc3 & 3) << 6) | enc4;
 
			output = output + String.fromCharCode(chr1);
 
			if (enc3 != 64) {
				output = output + String.fromCharCode(chr2);
			}
			if (enc4 != 64) {
				output = output + String.fromCharCode(chr3);
			}
 
		}
 
		output = Base64._utf8_decode(output);
 
		return output;
 
	},
 
	// private method for UTF-8 encoding
	_utf8_encode : function (string) {
		string = string.replace(/\r\n/g,"\n");
		var utftext = "";
 
		for (var n = 0; n < string.length; n++) {
 
			var c = string.charCodeAt(n);
 
			if (c < 128) {
				utftext += String.fromCharCode(c);
			}
			else if((c > 127) && (c < 2048)) {
				utftext += String.fromCharCode((c >> 6) | 192);
				utftext += String.fromCharCode((c & 63) | 128);
			}
			else {
				utftext += String.fromCharCode((c >> 12) | 224);
				utftext += String.fromCharCode(((c >> 6) & 63) | 128);
				utftext += String.fromCharCode((c & 63) | 128);
			}
 
		}
 
		return utftext;
	},
 
	// private method for UTF-8 decoding
	_utf8_decode : function (utftext) {
		var string = "";
		var i = 0;
		var c = c1 = c2 = 0;
 
		while ( i < utftext.length ) {
 
			c = utftext.charCodeAt(i);
 
			if (c < 128) {
				string += String.fromCharCode(c);
				i++;
			}
			else if((c > 191) && (c < 224)) {
				c2 = utftext.charCodeAt(i+1);
				string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
				i += 2;
			}
			else {
				c2 = utftext.charCodeAt(i+1);
				c3 = utftext.charCodeAt(i+2);
				string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
				i += 3;
			}
 
		}
 
		return string;
	}
 
}


var OdeModulePopup = { 

    setClickOpenPopup: function( bouton_id, module_name, multi = false, callback){           
        var type = ( multi === true ) ? "MultiSelect" : "";
        if ( $(`#${bouton_id}`).length > 0 && module_name !== "" ){
            window['callBackModulePopup'] = OdeModulePopup.callback;
            $(`#${bouton_id}`).off().on('click', function () {
                var json_data = {
                    "call_back_function": 'callBackModulePopup',
                    "form_name": "DetailView",
                    "field_to_name_array": {
                        "id": "subpanel_id"
                    },
                    "passthru_data": {
                        'callback': callback
                    }
                }
                open_popup(module_name, 600, 400, "", true, true, json_data, type, true);
            });
        }
    },

    addCallBackFunction: function( callback_name, callback_function ){
        window[callback_name] = callback_function;
    },

    callback: function( data ){
        var data_formated = {};
        do {
            if ( data.selection_list !== undefined && Object.getLength(data.selection_list) !== 0 ){
                data_formated = data.selection_list;
                break;
            } 
    
            if ( data.name_to_value_array !== undefined && data.name_to_value_array.subpanel_id !== "" ){
                data_formated = { 0: data.name_to_value_array.subpanel_id};
            }
            
        } while (0);
        window[data.passthru_data.callback](data_formated);
    }         

};


var OdeModeleMail = { 

    loaded: false, 

    init: function(){             
        window["open_email_template_form"] = OdeModeleMail.createModele;
        window["edit_email_template_form"] = OdeModeleMail.editModele;
        window["refresh_email_template_list"] = OdeModeleMail.returnPopupHandler; 
        OdeModeleMail.loaded = true;
    },

    createModele: function( fieldToSet ){ 
        fieldToSetValue = fieldToSet;
        URL="index.php?module=EmailTemplates&action=EditView&inboundEmail=true&show_js=1";
        windowName = 'email_template';
        windowFeatures = 'width=800' + ',height=600'    + ',resizable=1,scrollbars=1';
        win = window.open(URL, windowName, windowFeatures);
        if(window.focus)
        {
            // put the focus on the popup if the browser supports the focus() method
            win.focus();
        }
    },

    editModele: function( templateField ){ 
        fieldToSetValue = templateField;
        var field=document.getElementById(templateField);
        URL="index.php?module=EmailTemplates&action=EditView&inboundEmail=true&show_js=1";
        if (field.options[field.selectedIndex].value != 'undefined') {
            URL+="&record="+field.options[field.selectedIndex].value;
        }
        windowName = 'email_template';
        windowFeatures = 'width=800' + ',height=600'    + ',resizable=1,scrollbars=1';
    
        win = window.open(URL, windowName, windowFeatures);
        if(window.focus)
        {
            // put the focus on the popup if the browser supports the focus() method
            win.focus();
        }
    },

    editModele: function( template_id, template_name ){

        var field=document.getElementById(fieldToSetValue);
        var bfound=0;
        for (var i=0; i < field.options.length; i++) {
                if (field.options[i].value == template_id) {
                    if (field.options[i].selected==false) {
                        field.options[i].selected=true;
                    }
                    field.options[i].text = template_name;
                    bfound=1;
                }
        }
        //add item to selection list.
        if (bfound == 0) {
            var newElement=document.createElement('option');
            newElement.text=template_name;
            newElement.value=template_id;
            field.options.add(newElement);
            newElement.selected=true;
        }
    
    
        var field1=document.getElementById('edit_modele_mail');
        field1.style.visibility="visible";
    
        var applyListToTemplateField = 'modele_mail';
        if (fieldToSetValue == 'edit_modele_mail') {
                applyListToTemplateField = 'edit_modele_mail';
        } 
        var field=document.getElementById(applyListToTemplateField);
    
        if (bfound == 1) {
            for (var i=0; i < field.options.length; i++) {
                if (field.options[i].value == template_id) {
                    field.options[i].text = template_name;
                } 
            } 
    
        } else {
            var newElement=document.createElement('option');
            newElement.text=template_name;
            newElement.value=template_id;
            field.options.add(newElement);
        } 
    }
};