var OdeTextLong = {
    /**
     * Initialise la taill des textarea
     */
    initTextarea: function() {

        var getTextareaHeight = function( textarea, scanAmount ) {
            var origHeight = $(textarea).css('height'),
                height = $(textarea).outerHeight(true),
                scrollHeight = $(textarea).prop("scrollHeight"),
                overflow = $(textarea).css('overflow');

            if ( height >= scrollHeight ) 
            {
                /// because the scrollbar can cause calculation problems
                $(textarea).css('overflow', 'hidden');
                $(textarea).css('height', (height + scanAmount) + 'px');
                scrollHeight = $(textarea).prop("scrollHeight");

                /// by checking that scrollHeight has updated
                if ( scrollHeight < $(textarea).prop("scrollHeight") ) {
                    /// until scrollHeight becomes larger than height
                    while ($(textarea).outerHeight(true) >= $(textarea).prop("scrollHeight")) {
                        $(textarea).css('height', (height -= scanAmount)+'px');
                    }
                    /// be more specific to get the exact height
                    while ($(textarea).outerHeight(true) < $(textarea).prop("scrollHeight")) {
                        $(textarea).css('height',(height++)+'px');
                    }
                    /// reset the ta back to it's original height
                    $(textarea).css('height',origHeight);
                    /// put the overflow back
                    $(textarea).css('overflow', overflow);
                    return height;
                }
            } 
            else 
            {
                return scrollHeight;
            }
        }

        var getNumberLines = function( textarea ) {
            lineHeight = $(textarea).css('line-height');
            lineHeight = parseInt(lineHeight, 10);
            height = getTextareaHeight(textarea, lineHeight);
            lines = Math.ceil(height / lineHeight);
            return (lines - 1);
        }

        var setHeightTextarea = function ( textarea, lines ) {
            lineHeight = $(textarea).css('line-height');
            lineHeight = parseInt(lineHeight, 10);

            $(textarea).css('height', lineHeight * lines);
        }

        var params = (new URLS(document.location)).searchParams;

        var action = params.get('action');

        if(action == "DetailView")
        {
            $('textarea').each(function() {
                lines = getNumberLines(this);

                if (lines >= 11 )
                {
                    lines = 11;
                }
                else if (lines <= 3)
                {
                    lines = 3;
                }
                setHeightTextarea( this, lines);
            });
        }
        else if (action == 'EditView')
        {
            $('textarea').each(function() {
                lines = 7;
                setHeightTextarea( this, lines);
            });
        }
    },
};

OdeTextLong.initialisation = function(){
    this.initTextarea();
}

OdeTextLong.isValid = function( field ){ return true;}

OdeTextLong.getValue = function( field ){
    if( typeof $(field).val() === 'string' ) 
    {
        value = String($(field).val());
        value = OdeDossier.escapeHTML(value);
        
        let output = '';
        for (let i = 0; i < value.length; i++) {
            let charCode = value.charCodeAt(i);
            if (charCode > 127) {
                output += '\\u' + charCode.toString(16).padStart(4, '0');
            } else {
                output += value[i];
            }
        }

        value = output.replaceAll("\n",'&#13;');

        return value.trim();
    }
    return '';
} 

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['text_long'] = OdeTextLong;
    }
});
