var OdeNir = {};

OdeNir.initialisation = function(){
    $("[data-type-field=nir]").each(function() {
        $(this).inputmask({
          mask: "(9 99 99 99 999 999 99)|(9 99 99 2A 999 999 99)|(9 99 99 2B 999 999 99)"
        });
    });
}

OdeNir.isValid = function( field ){

    var isCorrect = true;
    if(field.val().length != 21 && field.val() != '') isCorrect = false;
    else if(field.val() != '' && field.val().length == 21){
        var nir = field.val().replaceAll(' ', '');
        nir = nir.replaceAll(' ', '');
        var validateNir = OdeNir.validateNir(nir);
        if(!validateNir){
            isCorrect = false;
        }
    }

    if(isCorrect){
        OdeValidator.hideErreur(field);
        return true;
    }else{
        OdeValidator.showErreur(field , 'Le numéro NIR est incorrect');  
    }
    return false;
}

OdeNir.getValue = function( field ){
    if( typeof $(field).val() === 'string' ) {
        value = OdeDossier.escapeHTML($(field).val());
        return value.trim();
    }
    return '';
}

OdeNir.validateNir = function(nir){
    var numSecu = nir.substring(0, 13);
    var cle = nir.substring(13);
    numSecu = numSecu.replace('2A','19');
    numSecu = numSecu.replace('2B','18');

    check = 97 - ( numSecu%97 );

    return check == cle;
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['nir'] = OdeNir;
    }
});
