<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;

class OdeNote extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean			    $bean: Bean du module OPS_dossier
     * @param boolean			$editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        // On récupere la valeur à afficher
        $value = $this->getFieldDefautValue($champ["defaut"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $autre = ' rel="as-input-note"';

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $style = ' class="input-text"';
        }else{
            $style = ' style="width: 100%; padding: 5px;min-height: 47px;"';
        }
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", $autre);
        $smarty->assign("style", $style);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/note.tpl");

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        
        // On récupere la valeur à afficher
        $value = $this->getFieldDefautValue($champ["defaut"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $autre = ' rel="as-input-note"';

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $style = ' class="input-text"';
        }else{
            $style = ' style="width: 100%; padding: 5px;min-height: 47px;"';
        }
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", $autre);
        $smarty->assign("style", $style);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/note.tpl");

        return $field_label . $field_html;
    }

    public function getFieldValue($value_bdd)
    {
        return (!empty($value_bdd)) ? base64_decode($value_bdd) : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
        return (!empty($value_defaut)) ? base64_decode($value_defaut) : "";
    }
    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        return (!empty($champ["defaut"])) ? base64_decode($champ["defaut"]) : "";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public static function getLibelle()
    {
        return "Note";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeNote::getLibelle(),
            'icon' => 'fas fa-sticky-note',
            'route' => '/champs/?type=note',
            'attributes' => '',
        ];
    }
}
