<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;
use ODE\Helper\OdeStringHelper;
use Configurator;

class OdeNombre extends OdeField
{


    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }


    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();
        
        $params = json_decode( base64_decode( $champ['params'] ) );
        $decimal = ($params->decimal == 1)?'0.01':'0';

        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd,$params->decimal);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $autre = ' data-decimal="'.( ($params->decimal == 1)?'1':'0' ).'" data-separateur="'.$configuratorObj->config['default_number_grouping_seperator'].'" data-separateur-decimal="'.$configuratorObj->config['default_decimal_seperator'].'"';

        /*if(!empty($value)){
            $value = number_format(floatval($value), ($decimal == '0')?0:2, $configuratorObj->config['default_decimal_seperator'], $configuratorObj->config['default_number_grouping_seperator']);
        }*/

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", ' data-type="number"'.$autre);
        $smarty->assign("view", "detail");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_number.tpl");

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();
        $isDefaut = '';
        // On récupere la valeur à afficher
        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $params = json_decode( base64_decode( $champ['params'] ) );

        $minimum = (!empty($params->minimum))?$params->minimum:'0';
        $maximum = (!empty($params->maximum) && $params->maximum > $minimum )?$params->maximum:'999999999';
        $step = ($params->decimal == 1)?'0.01':'1';
        $autre = ' data-decimal="'.( ($params->decimal == 1)?'1':'0' ).'" data-separateur="'.$configuratorObj->config['default_number_grouping_seperator'].'" data-separateur-decimal="'.$configuratorObj->config['default_decimal_seperator'].'"';

        if (empty($value_bdd) && $value_bdd !== "0") {
            $value = $this->getFieldDefautValue($champ["defaut"],$params->decimal,$isDefaut);
        } else {
            $value = $this->getFieldValue($value_bdd,$params->decimal);
        }

        //$value = str_replace(',', '.', $value);

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("minimum", $minimum);
        $smarty->assign("maximum", $maximum);
        $smarty->assign("step", $step);
        $smarty->assign("autre", $autre);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("view", "edit");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("isDefaut", $isDefaut);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_number.tpl");

        return $field_label . $field_html;
    }

    public function getFieldValue($value_bdd,$decimal)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();
        if(empty($value_defaut)){
            $value_formated = '';
        }
        if(empty($decimal) || $decimal == '0'){
            $value_formated = (!empty($value_bdd) || $value_bdd == "0") ? number_format((integer)$value_bdd, 0, $configuratorObj->config['default_decimal_seperator'], $configuratorObj->config['default_number_grouping_seperator']) : '';
        }else{
            $value_formated = (!empty($value_bdd) || $value_bdd == "0") ? number_format(floatval($value_bdd), 2, $configuratorObj->config['default_decimal_seperator'], $configuratorObj->config['default_number_grouping_seperator']) : '';
        }

        return ( ( $value_formated >= 0 && !empty($value_formated) ) || $value_formated == 0) ? $value_formated : '';
    }

    public function getFieldDefautValue($value_defaut,$decimal=null,&$isDefaut = null)
    {
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();
        $defautTab = json_decode( base64_decode($value_defaut), true);
        
        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value']; 
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab);
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }

        }

        if(empty($value_defaut) && $value_defaut != 0){
            return '';
        }
        if(empty($decimal) || $decimal == '0'){
            $value_formated = (!empty($value_defaut) || $value_defaut == "0") ? number_format((integer)$value_defaut, 0, $configuratorObj->config['default_decimal_seperator'], $configuratorObj->config['default_number_grouping_seperator']) : '';
        }else{
            $value_formated = (!empty($value_defaut) || $value_defaut == "0") ? number_format(floatval($value_defaut), 2, $configuratorObj->config['default_decimal_seperator'], '') : '';
            $value_formated = (float) $value_formated;
        }
        return ($value_formated >= 0 && $value_formated !== "") ? $value_formated : '';
    }

    private function getIdField($champ_name, $champ_duplicate)
    {
        return (!empty($champ_duplicate) && $champ_duplicate > 0) ? $champ_name . '_' . $champ_duplicate : $champ_name;
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        $params = json_decode( base64_decode( $champ['params'] ) );
        $decimal = ($params->decimal == 1)?'0.01':'0';
        $value_display = $this->getFieldValue($value,$params->decimal);
        return (!empty($value_display)) ? html_entity_decode($value_display) : "";
    }

    public static function getLibelle()
    {
        return "Nombre";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeNombre::getLibelle(),
            'icon' => 'fas fa-sort-numeric-up',
            'route' => '/champs/?type=nombre',
            'attributes' => '',
        ];
    }
}