<?php

namespace ODE\Generateur\Field;

use ODE\Helper\OdeArrayHelper;
use Sugar_Smarty;

class OdeLien extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        
        $href = "#";
        $libelle_lien = "Cliquez ici pour visualiser";
        $value_formated = (strpos($value_bdd, "http") === false && strpos($value_bdd, "//") === false) ? "//" . $value_bdd : $value_bdd;
        $value = (!empty($value_formated)) ? $value_formated : "";
        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);

        if (!empty($champ["name"])) {
            $json_formated = base64_decode($champ['params']);
            $retour_json_to_array = OdeArrayHelper::jsonToArray($json_formated);
            if ($retour_json_to_array['statut'] == "ok") {
                $params = $retour_json_to_array['data'];
                if (!empty($params['libelle_lien'])) {
                    $libelle_lien = $params['libelle_lien'];
                }
            }
            if (!empty($value) && $value !== "//") {
                $href = html_entity_decode(htmlspecialchars_decode(html_entity_decode($value)), ENT_QUOTES);
            }
        }
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("libelle_lien", $libelle_lien);
        $smarty->assign("href", $href);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $smarty->assign("required", '');
            $smarty->assign("disabled", ' disabled="disabled" ');
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/lien_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/lien.tpl");
        }

        return $field_label . $field_html;

    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("is_editable", 'non_editable');
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("isDefaut", $isDefaut);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_lien.tpl");

        return $field_label . $field_html;
    }

    public function getFieldValue($value_bdd)
    {
        return (!empty($value_bdd)) ? str_replace('"', '&quot;',  html_entity_decode($value_bdd) ) : "";
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $defautTab = json_decode( base64_decode($value_defaut), true);

        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value']; 
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab);
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        
        return (!empty($value_defaut)) ? str_replace('"', '&quot;',  html_entity_decode($value_defaut) ) : "";
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        return (!empty($value)) ? html_entity_decode($value) : "";
    }

    public static function getLibelle()
    {
        return "Lien";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeLien::getLibelle(),
            'icon' => 'fas fa-link',
            'route' => '/champs/?type=lien',
            'attributes' => '',
        ];
    }
}
