<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;
use BeanFactory;

class OdeAdresse extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $sugar_config, $app_list_strings;

        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", "");
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("name_numero", "name_numero");
        $smarty->assign("name_rue", "name_rue");
        $smarty->assign("name_complement_batiment", "name_complement_batiment");
        $smarty->assign("name_complement_lieu", "name_complement_lieu");
        $smarty->assign("name_code_postal", "name_code_postal");
        $smarty->assign("name_ville", "name_ville");
        $smarty->assign("name_latitude", "name_latitude");
        $smarty->assign("name_longitude", "name_longitude");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        if(isset($value["numero"]))
        {
            $smarty->assign("value_numero", $value["numero"]);
        }

        if(isset($value["rue"]))
        {
            $smarty->assign("value_rue", $value["rue"]);
        }

        if(isset($value["complement_batiment"]))
        {
            $smarty->assign("value_complement_batiment", $value["complement_batiment"]);
        }

        if(isset($value["complement_lieu"]))
        {
            $smarty->assign("value_complement_lieu", $value["complement_lieu"]);
        }

        if(isset($value["postcode"]))
        {
            $smarty->assign("value_code_postal", $value["postcode"]);
        }

        if(isset($value["city"]))
        {
            $smarty->assign("value_ville", $value["city"]);
        }

        if(isset($value["coordonnees_x"]))
        {
            $smarty->assign("value_latitude", $value["coordonnees_x"]);
        }

        if(isset($value["coordonnees_y"]))
        {
            $smarty->assign("value_longitude", $value["coordonnees_y"]);
        }

        // Assignation des libellés de chaque champ (Dynamique selon la config client)
        $smarty->assign("label_num_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_num_rue'] : 'N°');
        $smarty->assign("label_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_rue'] : 'Rue');
        $smarty->assign("label_lieu_dit", isset($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit'] : 'Lieu dit');
        $smarty->assign("label_bat_etage", isset($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage'] : 'Bât. / Étage');
        $smarty->assign("label_code_postal", isset($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_code_postal'] : 'Code postal');
        $smarty->assign("label_ville", isset($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_ville'] : 'Ville');

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse.tpl");
        }


        return $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $sugar_config, $app_list_strings;

        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"]);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $data_required = ( $required != '' ) ? ' data-required="true" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("adresse", "adresse");
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("data_required", $data_required);
        $smarty->assign("disabled", $disabled);

        if(isset($value["value"]))
        {
            $smarty->assign("value", $value["value"]);
        }
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("name_numero", "name_numero");
        $smarty->assign("name_rue", "name_rue");
        $smarty->assign("name_complement_batiment", "name_complement_batiment");
        $smarty->assign("name_complement_lieu", "name_complement_lieu");
        $smarty->assign("name_code_postal", "name_code_postal");
        $smarty->assign("name_ville", "name_ville");
        $smarty->assign("name_latitude", "name_latitude");
        $smarty->assign("name_longitude", "name_longitude");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        if(isset($value["numero"]))
        {
            $smarty->assign("value_numero", $value["numero"]);
        }

        if(isset($value["rue"]))
        {
            $smarty->assign("value_rue", $value["rue"]);
        }

        if(isset($value["complement_batiment"]))
        {
            $smarty->assign("value_complement_batiment", $value["complement_batiment"]);
        }

        if(isset($value["complement_lieu"]))
        {
            $smarty->assign("value_complement_lieu", $value["complement_lieu"]);
        }

        if(isset($value["postcode"]))
        {
            $smarty->assign("value_code_postal", $value["postcode"]);
        }

        if(isset($value["city"]))
        {
            $smarty->assign("value_ville", $value["city"]);
        }

        if(isset($value["coordonnees_x"]))
        {
            $smarty->assign("value_latitude", $value["coordonnees_x"]);
        }

        if(isset($value["coordonnees_y"]))
        {
            $smarty->assign("value_longitude", $value["coordonnees_y"]);
        }

        // Assignation des libellés de chaque champ (Dynamique selon la config client)
        $smarty->assign("label_num_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_num_rue'] : 'N°');
        $smarty->assign("label_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_rue'] : 'Rue');
        $smarty->assign("label_lieu_dit", isset($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit'] : 'Lieu dit');
        $smarty->assign("label_bat_etage", isset($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage'] : 'Bât. / Étage');
        $smarty->assign("label_code_postal", isset($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_code_postal'] : 'Code postal');
        $smarty->assign("label_ville", isset($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_ville'] : 'Ville');

        // Vérification d'activation de l'API BAN
        $smarty->assign("disable_api_ban", isset($sugar_config['opensocle']['disable_api_ban']) && !empty($sugar_config['opensocle']['disable_api_ban']) ? $sugar_config['opensocle']['disable_api_ban'] : 0);

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse.tpl");
        }
    
        return $field_html;
    }

    public function getFieldValue($value_bdd)
    {   
        if(!empty($value_bdd)){
            $value_bdd = str_replace('&amp;#x3D;','=',$value_bdd);
            $value = ($this->isUTF8(base64_decode($value_bdd)))?json_decode( base64_decode($value_bdd),true):json_decode( mb_convert_encoding(base64_decode($value_bdd), "UTF-8", "auto"),true );
            $value['value'] = $value_bdd;
        }
        return (!empty($value)) ? $value : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
        global $app_list_strings;
        
        $defautTab = json_decode( base64_decode($value_defaut), true);
        $defautValue = '';
        if($defautTab['defaut'] == 'demandeur'){
            $individuObj = BeanFactory::getBean('OPS_individu',$this->donnees['demandeur']['id']);
            $defautValue = [];
            if($defautTab['defaut_value'] == 'adresse_domiciliation'){
                $defautValue['numero'] = $individuObj->primary_address_number;
                $defautValue['rue'] = $individuObj->primary_address_street;
                $defautValue['city'] = $individuObj->primary_address_city;
                $defautValue['postcode'] = $individuObj->primary_address_postalcode;
                $defautValue['coordonnees_x'] = '';
                $defautValue['coordonnees_y'] = '';
                $defautValue['complement_batiment'] = $individuObj->primary_address_complement_batiment;
                $defautValue['complement_lieu'] = $individuObj->primary_address_complement_lieu;
            }
            else if($defautTab['defaut_value'] == 'adresse_employeur'){
                $defautValue['numero'] = $individuObj->adresse_num;
                $defautValue['rue'] = $individuObj->adresse_voie;
                $defautValue['city'] = $individuObj->address_city;
                $defautValue['postcode'] = $individuObj->address_postalcode;
                $defautValue['coordonnees_x'] = '';
                $defautValue['coordonnees_y'] = '';
                $defautValue['complement_batiment'] = $individuObj->adresse_complement_batiment;
                $defautValue['complement_lieu'] = $individuObj->adresse_complement_lieu;
            }
        }else if($defautTab['defaut'] == 'beneficiaire' && !empty($this->donnees['beneficiaire_id'])){
            $individuObj = BeanFactory::getBean('OPS_individu',$this->donnees['beneficiaire_id']);
            $defautValue = [];
            if($defautTab['defaut_value'] == 'adresse_domiciliation'){
                $defautValue['numero'] = $individuObj->primary_address_number;
                $defautValue['rue'] = $individuObj->primary_address_street;
                $defautValue['city'] = $individuObj->primary_address_city;
                $defautValue['postcode'] = $individuObj->primary_address_postalcode;
                $defautValue['coordonnees_x'] = '';
                $defautValue['coordonnees_y'] = '';
                $defautValue['complement_batiment'] = $individuObj->primary_address_complement_batiment;
                $defautValue['complement_lieu'] = $individuObj->primary_address_complement_lieu;
            }
            else if($defautTab['defaut_value'] == 'adresse_employeur'){
                $defautValue['numero'] = $individuObj->adresse_num;
                $defautValue['rue'] = $individuObj->adresse_voie;
                $defautValue['city'] = $individuObj->address_city;
                $defautValue['postcode'] = $individuObj->address_postalcode;
                $defautValue['coordonnees_x'] = '';
                $defautValue['coordonnees_y'] = '';
                $defautValue['complement_batiment'] = $individuObj->adresse_complement_batiment;
                $defautValue['complement_lieu'] = $individuObj->adresse_complement_lieu;
            }
        }else if($defautTab['defaut'] == 'profil' && (!empty($this->donnees['personne_morale']) || !empty($this->donnees['ops_personne_morale']))){
            $personneMoraleId = $this->donnees['personne_morale'];
            if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                $personneMoraleId = $this->donnees['ops_personne_morale'];
            }
            $profilObj = BeanFactory::getBean('OPS_personne_morale',$personneMoraleId);

            $defautValue = [];
            if($defautTab['defaut_value'] == 'adresse_domiciliation'){
                $defautValue['numero'] = $profilObj->billing_address_number;
                $defautValue['rue'] = $profilObj->billing_address_street;
                $defautValue['city'] = $profilObj->billing_address_city;
                $defautValue['postcode'] = $profilObj->billing_address_postalcode;
                $defautValue['coordonnees_x'] = $profilObj->billing_coordonnees_x;
                $defautValue['coordonnees_y'] = $profilObj->billing_coordonnees_y;
                $defautValue['complement_batiment'] = $profilObj->billing_address_complement;
                $defautValue['complement_lieu'] = $profilObj->billing_address_complement_lieu;
            }
            else if($defautTab['defaut_value'] == 'adresse_facturation'){
                $defautValue['numero'] = $profilObj->shipping_address_number;
                $defautValue['rue'] = $profilObj->shipping_address_street;
                $defautValue['city'] = $profilObj->shipping_address_city;
                $defautValue['postcode'] = $profilObj->shipping_address_postalcode;
                $defautValue['coordonnees_x'] = $profilObj->shipping_address_coordonnees_x;
                $defautValue['coordonnees_y'] = $profilObj->shipping_address_coordonnees_y;
                $defautValue['complement_batiment'] = $profilObj->shipping_address_complement;
                $defautValue['complement_lieu'] = $profilObj->shipping_address_complement_lieu;
            }
        }
        if(is_array($defautValue)){
            $defautValue['id'] = '';
            $defautValue['citycode'] = '';
            $defautValue['value'] = base64_encode(urldecode(rawurlencode(json_encode($defautValue))));
        }
        return $defautValue;
    }
    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        if(!empty($value)){
            $value = $this->getFieldValue($value);
            $value = $value["numero"] .' '. $value["rue"] .' '.  $value["complement_batiment"] .' '. $value["complement_lieu"] .' '. $value["postcode"] .' '. $value["city"];
        }
        return (!empty($value)) ? html_entity_decode($value) : "";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public function isUTF8($string) { 
        return (utf8_encode(utf8_decode($string)) == $string); 
    }

    public static function getLibelle()
    {
        return "Adresse";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeAdresse::getLibelle(),
            'icon' => 'fas fa-address-book',
            'route' => '/champs/?type=adresse',
            'attributes' => '',
        ];
    }
}
