var Section = (function($,champ) {

    return {
        
        /**
         * Fonction qui retourne le template d'une section ( Format HTML )
         *
         * @return {string} section_html
        */
        getHtml: function(){
            var id = champ.getUniqueId();
            let section_html =  `<div role="onglet-ligne" data-layout="section" class="row g-tab-onglet-section section-dropped" style="border: 1px solid rgb(211, 211, 211); font-weight: normal; border-radius: 3px;background: #f9f9f9;">`;
            section_html    +=      '<div role="ligne-move-handle">';
            section_html    +=           '<i class="fas fa-arrows-alt ligne-move-handle" title="Déplacer la section"></i>';
            section_html    +=      '</div>';
            section_html    +=      `<div style="padding: 7px;width: 99%;margin: 8px;border-bottom: 2px solid #534d64;" >`;
            section_html    +=          `<div style="color: #534d64;font-weight: bold;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;font-size: 14px;" class="row">`;
            section_html    +=              `<div role="section-title" class="col-md-10" style="text-overflow: ellipsis; white-space: nowrap; overflow: hidden;" id="${id}" data-conditions="">`;
            section_html    +=                  `Titre section`;
            section_html    +=              `</div>`;  
            section_html    +=              `<div role="section-input" class="col-md-10" style="display: none;">`;
            section_html    +=                  `<input type="text" value="Titre section" style="width: 90%; background: transparent;border: 1px solid #e3dfdf;outline: none;" />`;
            section_html    +=              `</div>`;  
            section_html    +=              `<div class="col-md-1 section-champ-edit">`;
            section_html    +=                  `<i class="far fa-edit" title="Editer le titre de la section" style="color: #32A6CF;cursor: pointer;" role="section-edit" ></i>`;
            section_html    +=                  `<i class="far fa-clipboard" title="Ajouter condition de la section" style="color: #32A6CF;cursor: pointer;" role="navigation" data-route="/section/?id=${id}"></i>`;
            section_html    +=              `</div>`;
            section_html    +=          `</div>`;
            section_html    +=      `</div>`;
            section_html    +=      '<div role="ligne-delete-handle" onclick="suppLigne(this)">';
            section_html    +=          '<i class="fas fa-trash-alt" title="Supprimer la section" ></i>';
            section_html    +=      '</div>';
            section_html    +=  `</div>`;
            return section_html;
        },

        /**
         * Fonction qui initialise l'event click sur les boutons "éditer une section"
         *
         * @return {void} 
        */
        setEditableOnClick: function(){
            $("[role=section-edit]").each(function() {  
                $(this).off().click(function() {

                    // Quand on click sur le bouton "éditer" => on cache le titre 
                    if ( $(this).attr("class") === "far fa-edit" ) {

                        var section_title_container = $(this).parent().parent().find( $("[role=section-title]") );
                        var section_input_container = $(this).parent().parent().find( $("[role=section-input]") ) ;
                        var section_input = section_input_container.children();

                        // => on affiche le mode édition ( input affiché, titre caché )
                        section_input_container.show();
                        section_title_container.hide();

                        // On initialise les évents sur l'input 
                        $(section_input)
                        .off()
                        .focus()
                        .focusout(function() {

                            // A la perte du focus sur l'input, on synchronise les deux valeurs et on quitte le mode édition
                            if($.trim(section_input.val()) != $.trim(section_title_container.text())){
                                //Flag modification
                                var vue = $(this).closest('[role=vue]');
                                Section.flagModification($(vue).attr('id'));
                            }

                            section_title_container.text(section_input.val());
                            section_title_container.show();
                            section_input_container.hide();

                        })
                        .keypress(function(event) {

                            // On actualise la valeur du titre à chaque modification de la valeur de l'input  
                            section_title_container.text(section_input.val());

                            // On quitte le mode édition au clic de la touche "Entrée" et on synchronise les deux valeurs
                            if (event.keyCode == '13') {

                                section_title_container.text(section_input.val());
                                section_title_container.show();
                                section_input_container.hide();
                            
                            }

                        });
                    }
                });
            });
            Router.setClickRoutes();
        },

        /**
         * Fonction qui initialise l'event draggable des sections
         *
         * @return {void} 
        */
        setDraggable: function() {
            $(".section-draggable").draggable({
                  cursor: 'move',
                  revert: 'invalid',
                  appendTo: "body",
                  helper: function () { 
                      var cloned = $(this).clone();
                      cloned.addClass("section-in-drag");
                      return cloned;
                  },
                  distance: 20
              });
        },

        update: function( id, data ){
            this.setData( id, data );
            setTimeout(function(){ 
                OdeLoadingHelper.removeSpinnerMenu();
                $("[role=champ-formulaire]").each(function() {
                    Champ.hideVerification( $(this) );
                });
                OdeAlertHelper.set( $(`#g-champ-form-message`) , "success",`Modifications sauvegardées`);
                Router.navigate("/");
            }, 1000);
            
        },

        setData: function( id, data ){
            const element = $(`#${id}`);
            if ( element.length === 0 || this.isDataValid(data) === false ) return false;
            element.attr(`data-conditions`, data['conditions']);
            return true;
        },

        isDataValid: function( data ){
            if ( typeof data !== 'object' || data === null || Object.getLength(data) === 0 ) return false;
            if ( data["conditions"] === undefined ) return false;
            return true; 
        },

        flagModification: function(id){

            var vue = $('#'+id);

            if($(vue).attr('data-modified') != 'true'){
                $(vue).attr('data-modified','true');
                var element = $($('#app-container').find('[aria-controls=' + $(vue).attr('id') + ']'));
                var existingStyle = element.attr('style');
                var newStyle = existingStyle + ' color: #f20000 !important';

                element.attr('style', newStyle);
            }
        }, 

    }
})(jQuery,Champ);
