<?php 

namespace ODE\CustomBlock\modules\OPS_dossier;
use ODE\CustomBlock\modules\BlockGeneric;

if (!defined('sugarEntry')) define('sugarEntry', true);

/**
 * Classe FiltreSimple
 * - Définition du block FiltreSimple 
 * dans le module OPS_dossier
 * pour l'action GestionView
 * sera affiché en 1er cas son ordre est 1
 * 
 * - le tpl du block est la variable tpl_container
 * - la variable php_controllers défini les controllers des elements 
 * qui seront à l'interieur des blocks dans le dossier 'modules/OPS_dossier/viewsUtils/viewGestionDossier/filtres_simples'
 * 
 */
class FiltreSimple extends BlockGeneric {


    public function __construct(){
        $this->infos = array(
            'module_name' => 'OPS_dossier',
            'action_name' => 'GestionView',
            'ordre' => 1,
            'tpl_container' => 'modules/OPS_dossier/tpls/gestion_dossier/filtres_simples.tpl',
            'php_controllers' => $this->getControllersObjects('modules/OPS_dossier/viewsUtils/viewGestionDossier/filtres_simples'),
            'css' => array_merge([ "custom/include/libs/css/fontawesome/all.min.css"],$this->getCssPath("modules/OPS_dossier/css/gestion_dossier")),
            'js' => array_merge(['custom/include/Ode/Helper/OdeQueriesHelper.js','custom/include/Ode/Helper/OdeAjaxHelper.js'],
                                 $this->getJsPath("modules/OPS_dossier/js/gestion_dossier"))
        );

    }

    public function getInfos() {
        return  $this->infos;
    }

}