<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DetecterDoublonDossierAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Détection de doublon "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Détection de doublon "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Détection de doublon";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Détection de doublon "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Détection de doublon de dossier";
    }

    /**
     * @access public
     * @name getForm()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        // Recherche depis le : - ext_valeur_1 
        $selectIndividu =  '<select name="ext_valeur_1" id="ext_valeur_1" data-selected="'.$this->action->ext_valeur_1.'" style="width: 75%">
                                <option value="beneficiaire">Bénéficiaire</option>
                                <option value="beneficiaire_demandeur">Bénéficiaire et demandeur</option>
                                <option value="beneficiaire_ou_demandeur">Bénéficiaire ou demandeur</option>
                                <option value="demandeur">Demandeur</option>
                                <option value="profil">Profil</option>
                            </select>';

        // Etape & statut - ext_valeur_2 & ext_valeur_3
        $objEtape = BeanFactory::getBean('OPS_etape');
        $listEtape = $objEtape->get_full_list();

        foreach ($listEtape as $etape) {

            $etape->load_relationship('ops_guide_instruction_ops_etape');
            $guide = $etape->ops_guide_instruction_ops_etape->get();

            $selectedEtape = ($etape->id == $this->action->ext_valeur_3)?'selected':'';
            $etape_liste .= '<option id="'.$etape->id.'" value="'.$etape->id.'" data-guide="'.$guide[0].'"'.$selectedEtape.'>'.$etape->name.'</option>';

            $etape->load_relationship('ops_etape_ops_statut');
            $listeStatut = $etape->ops_etape_ops_statut->get();

            foreach ($listeStatut as $statut) {

                $objStatut = BeanFactory::getBean('OPS_statut', $statut);
                $selectedStatut = ($objStatut->id == $this->action->ext_valeur_4)?'selected':'';
                $statut_liste .= '<option id="'.$objStatut->id.'" value="'.$objStatut->id.'" data-etape="'.$etape->id.'"'.$selectedStatut.'>'.$objStatut->name.'</option>';
            }        
        }

        $listeAnteriorite  = $app_list_strings['ops_anteriorite_list'];
        $selectAnteriorite = "";

        foreach ($listeAnteriorite as $key => $value) {
            if($key == $this->action->ext_valeur_5){
                $selectAnteriorite .= '<option id="'.$key.'" value="'.$key.'" selected="selected">'.$value.'</option>';
            }else{
                $selectAnteriorite .= '<option id="'.$key.'" value="'.$key.'">'.$value.'</option>';
            }
        }

        $data['ext_valeur_1']['type']  = 'enum';
        $data['ext_valeur_1']['label'] = 'Recherche depuis le';
        $data['ext_valeur_1']['form']  = $selectIndividu;

        $data['ext_valeur_3']['type']  = 'enum';
        $data['ext_valeur_3']['label'] = 'Etape';
        $data['ext_valeur_3']['form']  = '<select name="ext_valeur_3" id="ext_valeur_3" style="width: 75%;">' . $etape_liste . '</select>';

        $data['ext_valeur_4']['type']  = 'enum';
        $data['ext_valeur_4']['label'] = 'Statut';
        $data['ext_valeur_4']['form']  = '<select name="ext_valeur_4" id="ext_valeur_4" style="width: 75%;">' . $statut_liste . '</select>';

        $data['ext_valeur_5']['type']  = 'enum';
        $data['ext_valeur_5']['label'] = 'Type d\'antériorité';
        $data['ext_valeur_5']['form']  = '<select name="ext_valeur_5" id="ext_valeur_5" style="width: 75%;">' . $selectAnteriorite . '</select>';

        $data['ext_valeur_6']['type']  = 'int';
        $data['ext_valeur_6']['label'] = 'Antériorité (en mois)';
        $data['ext_valeur_6']['form']  = '<input style="margin-right: 10px; width: 70%;" type="text" name="ext_valeur_6" id="ext_valeur_6" value="' . $this->action->ext_valeur_6 . '">';

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings;

        $data = [];

        $recherche = '';
        if($this->action->ext_valeur_1 == 'demandeur')
        {
            $recherche = 'Demandeur';
        }
        else if ($this->action->ext_valeur_1 == 'beneficiaire')
        {
            $recherche = 'Bénéficiaire';
        }
        else if ($this->action->ext_valeur_1 == 'beneficiaire_demandeur')
        {
            $recherche = 'Bénéficiaire et demandeur';
        }
        else if ($this->action->ext_valeur_1 == 'beneficiaire_ou_demandeur')
        {
            $recherche = 'Bénéficiaire ou demandeur';
        }
        else if ($this->action->ext_valeur_1 == 'profil')
        {
            $recherche = 'Profil';
        }

        $obj_statut = (!empty($this->action->ext_valeur_4)) ? BeanFactory::getBean('OPS_statut', $this->action->ext_valeur_4) : null;
        $statut_name = ($obj_statut !== null && !empty($obj_statut->name)) ? $obj_statut->name : "";

        $obj_etape = (!empty($this->action->ext_valeur_3)) ? BeanFactory::getBean('OPS_etape', $this->action->ext_valeur_3) : null;
        $etape_name = ($obj_etape !== null && !empty($obj_etape->name)) ? $obj_etape->name : "";

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Recherche depuis le';
        $data['ext_valeur_1']['valeur']  = $recherche;

        $data['ext_valeur_3']['type']  = 'text';
        $data['ext_valeur_3']['label'] = 'Etape';
        $data['ext_valeur_3']['valeur']  = $etape_name;

        $data['ext_valeur_4']['type']  = 'text';
        $data['ext_valeur_4']['label'] = 'Statut';
        $data['ext_valeur_4']['valeur']  = $statut_name;

        $data['ext_valeur_5']['type']  = 'text';
        $data['ext_valeur_5']['label'] = 'Type d\'antériorité';
        $data['ext_valeur_5']['valeur']  = $app_list_strings['ops_anteriorite_list'][$this->action->ext_valeur_5];

        $data['ext_valeur_6']['type']  = 'text';
        $data['ext_valeur_6']['label'] = 'Antériorité (en mois)';
        $data['ext_valeur_6']['valeur']  = $this->action->ext_valeur_6;

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if( !empty($this->dossier) && !empty($this->action->ext_valeur_1) && in_array($this->action->ext_valeur_1, ['demandeur', 'beneficiaire', 'beneficiaire_demandeur', 'beneficiaire_ou_demandeur', 'profil']) && !empty($this->action->ext_valeur_3) && !empty($this->action->ext_valeur_4) )
        {
            if(empty($this->dossier->ops_individu_id))
            {
                return;
            }

            global $db;

            // Dispositif
            $objDossier = BeanFactory::getBean('OPS_dossier',$this->dossier->id);
            $objDossier->load_relationship('ops_dispositif_ops_dossier');
            $dispositif_id = $objDossier->ops_dispositif_ops_dossier->get()[0];

            if($this->action->ext_valeur_5 == 'annee_revolue'){
                $date = date('Y-m-d', strtotime(date('Y-m-d') . '- ' . $this->action->ext_valeur_6 . ' months'));
                $anterioriteTab = explode('-', $date);
                $anteriorite = $anterioriteTab[0].'-01-01';
            }else{
                $anteriorite = date('Y-m-d', strtotime(date('Y-m-d') . '- ' . $this->action->ext_valeur_6 . ' months'));
            }

            // Partie Demandeur
            $demandeur = BeanFactory::getBean('OPS_individu', $this->dossier->ops_individu_id);

            $query_demandeur = 'SELECT ops_dossier.id
                                FROM ops_dossier 
                                INNER JOIN ops_dispositif_ops_dossier ON ops_dispositif_ops_dossier.ops_dossier_id = ops_dossier.id
                                INNER JOIN ops_individu_ops_dossier ON ops_individu_ops_dossier.ops_dossier_id = ops_dossier.id
                                INNER JOIN ops_individu ON ops_individu.id = ops_individu_ops_dossier.ops_individu_id
                                WHERE '.$this->getSqlClauseLikeFormated('ops_individu.first_name', $demandeur->first_name).' 
                                AND '.$this->getSqlClauseLikeFormated('ops_individu.last_name', $demandeur->last_name).'
                                AND ops_dispositif_ops_dossier.ops_dispositif_id = "' . $dispositif_id . '" AND ops_dossier.brouillon = "non" 
                                AND ops_dossier.date_entered >= "' . $anteriorite . '" AND ops_dossier.id <> "' . $this->dossier->id .'" AND ops_dossier.deleted = 0 AND ops_dossier.cloture = 0';
            
            if ($this->action->ext_valeur_1 == 'demandeur')
            {
                $query = $query_demandeur;
            }
            // Partie beneficiaire
            else
            {
                // S'il y a un profil associé, alors le beneficiaire est dans beneficiaire_id sinon dans ops_individu_id (Demandeur)
                if(!empty($this->dossier->ops_personne_morale))
                {
                    $beneficiaire = BeanFactory::getBean('OPS_individu', $this->dossier->beneficiaire_id);

                }
                // Si le dossier n'est pas rattaché à un profil (Beneficiare = demandeur)
                else
                {
                    $beneficiaire = BeanFactory::getBean('OPS_individu', $this->dossier->ops_individu_id);
                }

                $query_beneficiaire_avec_profil = 'SELECT ops_dossier.id
                                                   FROM ops_dossier 
                                                   INNER JOIN ops_dispositif_ops_dossier ON ops_dispositif_ops_dossier.ops_dossier_id = ops_dossier.id
                                                   INNER JOIN ops_individu ON ops_individu.id = ops_dossier.beneficiaire_id
                                                   WHERE '.$this->getSqlClauseLikeFormated('ops_individu.first_name', $beneficiaire->first_name).' 
                                                    AND  '.$this->getSqlClauseLikeFormated('ops_individu.last_name', $beneficiaire->last_name).'
                                                   AND ops_dispositif_ops_dossier.ops_dispositif_id = "' . $dispositif_id . '" AND ops_dossier.brouillon = "non" AND ops_dossier.date_entered >= "' . $anteriorite . '" AND ops_dossier.id <> "' . $this->dossier->id .'" AND ops_dossier.deleted = 0 AND ops_dossier.ops_personne_morale IS NOT NULL AND ops_dossier.cloture = 0';

                $query_beneficiaire_sans_profil = 'SELECT ops_dossier.id
                                                   FROM ops_dossier 
                                                   INNER JOIN ops_dispositif_ops_dossier ON ops_dispositif_ops_dossier.ops_dossier_id = ops_dossier.id
                                                   INNER JOIN ops_individu_ops_dossier ON ops_individu_ops_dossier.ops_dossier_id = ops_dossier.id
                                                   INNER JOIN ops_individu ON ops_individu.id = ops_individu_ops_dossier.ops_individu_id
                                                   WHERE '.$this->getSqlClauseLikeFormated('ops_individu.first_name', $beneficiaire->first_name).' 
                                                    AND  '.$this->getSqlClauseLikeFormated('ops_individu.last_name', $beneficiaire->last_name).'
                                                   AND ops_dispositif_ops_dossier.ops_dispositif_id = "' . $dispositif_id . '" AND ops_dossier.brouillon = "non" AND ops_dossier.date_entered >= "' . $anteriorite . '" AND ops_dossier.id <> "' . $this->dossier->id .'" AND ops_dossier.deleted = 0 AND ops_dossier.ops_personne_morale = "" AND ops_dossier.cloture = 0';

                $query_beneficiaire = $query_beneficiaire_avec_profil . ' UNION ' . $query_beneficiaire_sans_profil;

                if ($this->action->ext_valeur_1 == 'beneficiaire')
                {
                    $query = $query_beneficiaire;
                }
                // Partie demandeur & beneficiaire
                else if ($this->action->ext_valeur_1 == 'beneficiaire_demandeur')
                {
                    $query = $query_demandeur . ' INTERSECT ' . $query_beneficiaire;
                }
                else if ($this->action->ext_valeur_1 == 'beneficiaire_ou_demandeur')
                {
                    $query = $query_demandeur . ' UNION ' . $query_beneficiaire;
                }
            }

            // Détection de doublon sur le profil
            if ($this->action->ext_valeur_1 == 'profil')
            {
                $query = 'SELECT ops_dossier.id
                          FROM ops_dossier 
                          INNER JOIN ops_dispositif_ops_dossier ON ops_dispositif_ops_dossier.ops_dossier_id = ops_dossier.id
                          WHERE ops_dispositif_ops_dossier.ops_dispositif_id = "' . $dispositif_id . '" AND ops_dossier.brouillon = "non" AND ops_dossier.date_entered >= "' . $anteriorite . '" AND ops_dossier.id <> "' . $this->dossier->id .'" AND ops_dossier.deleted = 0 AND ops_dossier.ops_personne_morale = "' . $this->dossier->ops_personne_morale . '" AND ops_dossier.cloture = 0';
            }

            $result = $db->query($query);
            if($result->num_rows > 0)
            {
                $objDossier->updateStatut( $this->action->ext_valeur_4, null, 'action_statut');
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "DetecterDoublonDossierAction";
    }

    /**
     * @access private
     * @name getSqlClauseLikeFormated()
     * Fonction qui retourne la condition SQL Like formaté : On enleve l'ensemble des caracteres spéciaux  
     * @param string       $field_name
     * @param string       $field_value
     * 
     * @return string       $sql_clause
     */
    private function getSqlClauseLikeFormated($field_name = "", $field_value = "")
    {
        # On intialise l'object de condition
        $sql_clause = (object) [
            'start_clause_name' => 'UPPER(TRIM(',
            'clause_name' => $field_name,
            'end_clause_name' => '))',
            'start_clause_value' => 'UPPER(TRIM(',
            'clause_value' => '"'.html_entity_decode($field_value,ENT_QUOTES,'UTF-8').'"',
            'end_clause_value' => '))'
        ];

        # On récupere la liste des caracteres spéciaux à remplacer et on boucle sur la liste pour les remplacer dans les deux parties de la condition LIKE 
        $caractere_speciaux = $this->getSpecialCharListe();
        foreach ($caractere_speciaux as $char_to_replace => $char_replace_by) {
            $sql_clause->clause_name = 'REPLACE('.$sql_clause->clause_name.', "'.$char_to_replace.'", "'.$char_replace_by.'")';
            $sql_clause->clause_value = 'REPLACE('.$sql_clause->clause_value.', "'.$char_to_replace.'", "'.$char_replace_by.'")';
        }

        # On concatene les elements de l'object pour construire notre condition
        return $sql_clause->start_clause_name . $sql_clause->clause_name . $sql_clause->end_clause_name . ' LIKE ' . $sql_clause->start_clause_value . $sql_clause->clause_value . $sql_clause->end_clause_value;
    }
    
    /**
     * @access private
     * @name getSqlClauseLikeFormated()
     * Fonction qui retourne la liste des caracteres spéciaux ainsi que les valeurs de remplacement 
     * 
     * @return array       $caractere_speciaux
     */
    private function getSpecialCharListe()
    {
        return [
            'à' => 'a',
            'á' => 'a',
            'â' => 'a',
            'ã' => 'a',
            'ä' => 'a',
            'ç' => 'c',
            'è' => 'e',
            'é' => 'e',
            'ê' => 'e',
            'ë' => 'e',
            'ì' => 'i',
            'í' => 'i',
            'î' => 'i',
            'ï' => 'i',
            'ñ' => 'n',
            'ò' => 'o',
            'ó' => 'o',
            'ô' => 'o',
            'õ' => 'o',
            'ö' => 'o',
            'ù' => 'u',
            'ú' => 'u',
            'û' => 'u',
            'ü' => 'u',
            'ý' => 'y',
            'ÿ' => 'y',
            'À' => 'A',
            'Á' => 'A',
            'Â' => 'A',
            'Ã' => 'A',
            'Ä' => 'A',
            'Ç' => 'C',
            'È' => 'E',
            'É' => 'E',
            'Ê' => 'E',
            'Ë' => 'E',
            'Ì' => 'I',
            'Í' => 'I',
            'Î' => 'I',
            'Ï' => 'I',
            'Ñ' => 'N',
            'Ò' => 'O',
            'Ó' => 'O',
            'Ô' => 'O',
            'Õ' => 'O',
            'Ö' => 'O',
            'Ù' => 'U',
            'Ú' => 'U',
            'Û' => 'U',
            'Ü' => 'U',
            'Ý' => 'Y',
            'Å' => 'A',
            'Ø' => 'O',
            'Ÿ' => 'Y',
            '_' => '',
            '(' => '',
            ')' => '',
            '/' => '',
            '-' => '',
            '+' => '',
            '!' => '',
            ',' => '',
            ':' => '',
            '\''=> '',
            ' '  => '',
        ];
    }
}