<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DeclencherFluxAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Déclencher un Flux "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Déclencher un Flux "
     * 
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Déclencher un flux";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     * 
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Déclenchement d'un flux";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];
        // Construction du tableau de flux  'id' => 'name'  
        $flux_array = get_bean_select_array(false, 'OPS_flux', "name", "", 'name');
        // Construction des options 
        $flux_liste = get_select_options_with_id($flux_array, $this->action->ext_valeur_1);
        $data['ext_valeur_1']['type']  = 'enum';
        $data['ext_valeur_1']['label'] = 'Flux';
        $data['ext_valeur_1']['form']  = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">' . $flux_liste . '</select>';
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     * 
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $obj_flux = (!empty($this->action->ext_valeur_1)) ? BeanFactory::getBean('OPS_flux', $this->action->ext_valeur_1) : null;
        $flux_name = ($obj_flux !== null && !empty($obj_flux->name)) ? $obj_flux->name : "";

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Flux';
        $data['ext_valeur_1']['valeur']  = $flux_name;

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     * 
     *  @return void    
     */
    public function execute()
    {

        if(!empty($this->dossier) && !empty($this->action->ext_valeur_1)){

            $obj_flux = BeanFactory::getBean('OPS_flux', $this->action->ext_valeur_1);
            $donnees_flux = $obj_flux->get_donnees_bean($this->dossier);

            if (!empty($donnees_flux['statut']) && $donnees_flux['statut'] === "ok") {

                // On vérifie si le flux doit etre envoyer en [{JSON}] ou {JSON}
                $donnees_flux['data'] = ($obj_flux->action_lot == 'groupe' && $obj_flux->methode == 'post') ? "[" . $donnees_flux['data'] . "]" : $donnees_flux['data'];

                // On déclenche le flux et on retourne le résultat
                $retour_declencher_flux = $obj_flux->declencher_flux($donnees_flux['data']);

                $GLOBALS['log']->fatal("DeclencherFluxAction :: execute() =>  ".print_r($retour_declencher_flux,true));


            } else {
                $GLOBALS['log']->fatal("DeclencherFluxAction :: erreur des données");
            }
        
        }


    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }

}
