<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class CreerSuiviDossierAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Ajouter une ligne "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'suivi';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Ajouter une ligne "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Ajouter une ligne";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Ajouter une ligne "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Ajout d'une ligne de suivi";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        $data['hidden'] = '<script src="custom/include/SugarFields/Fields/Icone/js/viewIcone.js" type="text/javascript" charset="utf-8"></script>
        <script src="https://kit.fontawesome.com/a076d05399.js" type="text/javascript" charset="utf-8"></script>';

        $checked_val_5 = 'checked';
        $checked_val_6 = 'checked';
        if($this->action->ext_valeur_5 == 'off' ){
            $checked_val_5 = '';
        }
        if($this->action->ext_valeur_6 == 'off' ){
            $checked_val_6 = '';
        }

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Nom';
        $data['ext_valeur_1']['form']  = '<input style="margin-right: 10px; width: 70%;" type="text" name="ext_valeur_1" id="ext_valeur_1" value="'.$this->action->ext_valeur_1.'">';

        $data['ext_valeur_2']['type'] = 'int';
        $data['ext_valeur_2']['label'] = 'Ordre';
        $data['ext_valeur_2']['form'] = '<input style="margin-right: 10px; width: 70%;" type="text" name="ext_valeur_2" id="ext_valeur_2" value="'.$this->action->ext_valeur_2.'">';

        $data['ext_valeur_3']['type'] = 'text';
        $data['ext_valeur_3']['label'] = 'Nom du champ du dossier';
        $data['ext_valeur_3']['form'] = '<input style="margin-right: 10px; width: 70%;" type="text" name="ext_valeur_3" id="ext_valeur_3" value="'.$this->action->ext_valeur_3.'">';

        $data['ext_valeur_4']['type'] = 'text';
        $data['ext_valeur_4']['label'] = 'Icone';
        $data['ext_valeur_4']['form'] = '<input style="margin-right: 10px; width: 70%;" type="text" name="ext_valeur_4" id="ext_valeur_4" size="30" maxlength="255" value="'.$this->action->ext_valeur_4.'" title="" onchange="showIcone(\'ext_valeur_text\')"><p style="float: right;margin-right: 13%;" id="ext_valeur_text_preview"><i class="fa fa-'.$this->action->ext_valeur_4.'" style="font-size:50px" aria-hidden="true"></i></p>';

        $data['ext_valeur_5']['type'] = 'bool';
        $data['ext_valeur_5']['label'] = 'Visible CRM';
        $data['ext_valeur_5']['form'] = '<input type="hidden"  name="ext_valeur_5" value = "off" >';
        $data['ext_valeur_5']['form'] .= '<input type="checkbox" class="checkbox" value = "on" name="ext_valeur_5" id="ext_valeur_5" '.$checked_val_5.' >';

        $data['ext_valeur_6']['type'] = 'bool';
        $data['ext_valeur_6']['label'] = 'Visible internet';
        $data['ext_valeur_6']['form'] = '<input type="hidden"  name="ext_valeur_6" value = "off" >';
        $data['ext_valeur_6']['form'] .= '<input type="checkbox" class="checkbox" value = "on" name="ext_valeur_6" id="ext_valeur_6" '.$checked_val_6.' >';



        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $checked_val_5 = '';
        $checked_val_6 = '';
        if($this->action->ext_valeur_5 == 1 || $this->action->ext_valeur_5 == 'on'){
            $checked_val_5 = 'checked';
        }
        if($this->action->ext_valeur_6 == 1 || $this->action->ext_valeur_6 == 'on'){
            $checked_val_6 = 'checked';
        }

        $data['ext_valeur_1']['label'] = 'Nom';
        $data['ext_valeur_1']['type'] = 'text';
        $data['ext_valeur_1']['valeur'] = $this->action->ext_valeur_1;

        $data['ext_valeur_2']['label'] = 'Ordre';
        $data['ext_valeur_2']['type'] = 'text';
        $data['ext_valeur_2']['valeur'] = $this->action->ext_valeur_2;

        $data['ext_valeur_3']['label'] = 'Nom du champ du dossier';
        $data['ext_valeur_3']['type'] = 'text';
        $data['ext_valeur_3']['valeur'] = $this->action->ext_valeur_3;

        $data['ext_valeur_4']['label'] = 'Icone';
        $data['ext_valeur_4']['type'] = 'text';
        $data['ext_valeur_4']['valeur'] = '<script src="custom/include/SugarFields/Fields/Icone/js/viewIcone.js" type="text/javascript" charset="utf-8"></script>
                                   <script src="https://kit.fontawesome.com/a076d05399.js" type="text/javascript" charset="utf-8"></script><p style="margin-right: 13%;" id="ext_valeur_4"><i class="fa fa-'.$this->action->ext_valeur_4.'" style="font-size:50px" aria-hidden="true"></i></p>';

        $data['ext_valeur_5']['label'] = 'Visible CRM';
        $data['ext_valeur_5']['type'] = 'bool';
        $data['ext_valeur_5']['valeur'] = '<input type="checkbox" class="checkbox" name="ext_valeur_5" id="ext_valeur_5" disabled '.$checked_val_5.' >';

        $data['ext_valeur_6']['label'] = 'Visible internet';
        $data['ext_valeur_6']['type'] = 'bool';
        $data['ext_valeur_6']['valeur'] = '<input type="checkbox" class="checkbox" name="ext_valeur_6" id="ext_valeur_6" disabled '.$checked_val_6.' >';

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier)){

            $nom = $this->action->ext_valeur_1;
            $ordre = $this->action->ext_valeur_2;
            $libelleChamp = $this->action->ext_valeur_3;
            $icone = $this->action->ext_valeur_4;
            $visibleBack = $this->action->ext_valeur_5;
            $visibleFront = $this->action->ext_valeur_6;
            $champ = '';

            $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel');
            $where = 'ops_generateur_referentiel.name = "'.$libelleChamp.'"';
            $objChamps = $objReferentiel->get_full_list('name',$where);
            $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

            if(!empty($objChamps)){
                if($objChamps[0]->type == 'relation'){
                    $champRelationParams = json_decode( base64_decode( $objChamps[0]->params),true );
                    $relationName = $champRelationParams['relation_name'];
                    $this->dossier->load_relationship($relationName);
                    $relation = $this->dossier->{$relationName}->get();
                    $objBean = BeanFactory::getBean($champRelationParams['module_name'],$relation[0]);
                    $champ = $objBean->name;
                }else{
                    if($objChamps[0]->description == 'custom'){
                        $champ = $customChamp->{$libelleChamp};
                    }else{
                        $champ = $this->dossier->{$libelleChamp};
                    }
                }

                if(strstr($libelleChamp, 'date')){
                    $champ = date('d/m/Y', strtotime($champ));
                }

                $objSuivi = BeanFactory::getBean('OPS_suivi_dossier');

                $objSuivi->name = trim($nom);
                $objSuivi->num_ordre = $ordre;
                $objSuivi->description = $champ;
                $objSuivi->nom_information = $libelleChamp;
                $objSuivi->visible_back = $visibleBack;
                $objSuivi->visible_front = $visibleFront;
                $objSuivi->icone = $icone;
                $suivi = $objSuivi->save();

                $this->dossier->load_relationship('ops_dossier_ops_suivi_dossier');
                $this->dossier->ops_dossier_ops_suivi_dossier->add($suivi);
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }
}
