<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

class OPS_traitementViewEdit extends ViewEdit {
    
    public function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }
    
    function display()
    {
        global $app_list_strings,$mod_strings;

        // On récupere le type_traitement initial 
        $type_traitement_initial_id = ( !empty($this->bean->ops_type_traitement_id) ) ? $this->bean->ops_type_traitement_id : "";

        $type_traitement_etape_initial_id = ( !empty($this->bean->ops_type_traitement_etapes_id) ) ? $this->bean->ops_type_traitement_etapes_id : "";

        // On récupere la liste des type_traitements
        $type_traitements = array();
        $typeTraitementsObject = BeanFactory::getBean("OPS_type_traitement");
        $liste_type_traitements = $typeTraitementsObject->get_full_list("name");
        if ( is_array($liste_type_traitements) && count($liste_type_traitements) > 0 ) {
            foreach ( $liste_type_traitements as $typeTraitements ) {
                $type_traitements[$typeTraitements->id] = array(
                   'name' => $typeTraitements->name,
                );
            }
        }

        // On construit le select type_traitements
        $select_type_traitement_initial = '<select id="select_type_traitement_initial" style="width: 50%;margin-right: 5%;">';
        $select_type_traitement_initial .= '<option label="" value=""></option>';
        if( is_array($type_traitements) && count($type_traitements) > 0 ){
            foreach ( $type_traitements as $type_traitements_id => $typeTraitements ) {
                $select_type_traitement_initial .= ( $type_traitements_id === $type_traitement_initial_id ) ? '<option selected="selected" ' : '<option ';
                $select_type_traitement_initial .= ' label="' . $typeTraitements['name'] . '" value="' . $type_traitements_id . '" ></option>';
            }
        }
        $select_type_traitement_initial .='</select> ';
        
        $type_traitement_initial =  $select_type_traitement_initial;
        $type_traitement_initial .= '<input type="hidden" name="ops_type_traitement_id" id="ops_type_traitement_id" value="' . $type_traitement_initial_id . '">';
        $this->ss->assign("type_traitement_initial", $type_traitement_initial);

        // On récupere la liste des type_traitement_etapes
        $type_traitement_etapes = array();
        $typeTraitementEtapesObject = BeanFactory::getBean("OPS_type_traitement_etapes");
        $liste_type_traitement_etapes = $typeTraitementEtapesObject->get_full_list("etape");
        if ( is_array($liste_type_traitement_etapes) && count($liste_type_traitement_etapes) > 0 ) {
            foreach ( $liste_type_traitement_etapes as $typeTraitementEtapes ) {
                $obj = BeanFactory::getBean("OPS_type_traitement_etapes",$typeTraitementEtapes->id);
                $type_traitement_etapes[$obj->ops_type_traitement_id][$obj->id] = array(
                    'etape' => $obj->etape,
                    'name' => $obj->etape.' - '.$obj->name,
                );
            }
        }

        $select_type_traitement_etapes_initial = '<select id="select_type_traitement_etapes_initial" style="width: 50%;margin-right: 5%;">';
        $select_type_traitement_etapes_initial .= '<option label="" value=""></option>';
        if ( is_array($liste_type_traitement_etapes) && count($liste_type_traitement_etapes) > 0 ) {
            foreach ( $type_traitement_etapes as $key => $type_traitement ) {
                foreach ($type_traitement as $id => $etape) {
                    $select_type_traitement_etapes_initial .= ( $type_traitement_etape_initial_id === $id ) ? '<option selected="selected" ' : '<option ';
                    $select_type_traitement_etapes_initial .='label="'.$etape['name'].'" value="'.$id.'" data-traitement="'.$key.'"></option>';
                }
            }
        }
        $select_type_traitement_etapes_initial .='</select> ';
        $type_traitement_etapes_initial = $select_type_traitement_etapes_initial;
        $type_traitement_etapes_initial .= '<input type="hidden" name="ops_type_traitement_etapes_id" id="ops_type_traitement_etapes_id" value="' . $type_traitement_etape_initial_id . '">';
        $this->ss->assign("type_traitement_etapes_initial", $type_traitement_etapes_initial);

        parent::display();
    }
}
