<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');



class OPS_template_smsViewEdit extends ViewEdit
{
    /**
     * @see SugarView::preDisplay()
     */
    public function preDisplay()
    {
        parent::preDisplay();
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {
        global $mod_strings,$sugar_config,$app_list_strings;

        $dropDown = '';
        foreach ($app_list_strings['sms_templates_objects'] as $key => $value) {
            $selected = '';
            if ($key === 'meeting') {
                $selected = ' selected';
            }
            $dropDown .= '<option value="' . $key . '"' . $selected . '>' . $value . '</option>';
        }
        $this->ss->assign("DROPDOWN", $dropDown);

        $sms_length = $sugar_config['ops_sms']['sms_length'];
        $this->ss->assign("MAX_LENGTH_DESCRIPTION", $sms_length);
        $warningLabel = $mod_strings['LBL_WARNING'];
        $html_sms_length = '<span style="font-weight:bold;" id="count-char-label">' . $sms_length . '</span>';
        $warningLabelDescription = str_replace('__X__', $html_sms_length, $mod_strings['LBL_WARNING_DESCRIPTION']);

        $this->ss->assign('LBL_WARNING', $warningLabel);
        $this->ss->assign('LBL_WARNING_DESCRIPTION', $warningLabelDescription);

        parent::display();
    }
}
