const ModalTestSms = Object.create(OdeModal);

if( typeof(TestSms) == 'undefined' ){ 
    var TestSms = { 
        modal_id: 'ode_modal_test_sms',
        type: '',
        data_verification: false,
        loaded: false 
    };
}

TestSms.initialisation = function() {

    $('#test_sms_numero').val('');
    $('#test_sms_message').val('');
    $('.error').remove();

    $('#form_test_sms_btn_send').off().on('click', function() {

        let numero  = $('#test_sms_numero').val();
        let message = $('#test_sms_message').val();

        let config = {};

        let api = $('#api').val();
        let url_appel_api = $('input[name="url_appel_api"]').val();
        if(api !== undefined && api != '' && url_appel_api !== undefined && url_appel_api != '')
        {
            config.api = api;
            config.url_appel_api = url_appel_api;

            if(api == 'smsbox')
            {
                config.api_key = $('input[name="api_key"]').val();
            }
            else if(api == 'orange')
            {
                config.user_name = $('input[name="user_name"]').val();
                config.password  = $('input[name="password"]').val();
            }
            else if(api == 'ovh')
            {
                config.application_key    = $('input[name="application_key"]').val();
                config.application_secret = $('input[name="application_secret"]').val();
                config.consumer_key       = $('input[name="consumer_key"]').val();
                config.compte_api         = $('input[name="compte_api"]').val();
                config.expediteur_api     = $('input[name="expediteur_api"]').val();
            }
            else
            {
                console.log('Non pris en compte')
            }
        }

        if(numero === undefined || numero == '' || message === undefined || message == '')
        {
            console.log('Missing values');
            $('.error').remove();
            $('<p>').addClass('error').text('Veuillez remplir les champs').insertBefore('#btn_test_sms');
        }
        else
        {
            ModalTestSms.route('loading');

            var loading = function(){
                ModalTestSms.loading.setMessage('Récupération des données');
            };
        
            var callBack = function(){

                if ( typeof this.result.html_message === "string"){
                    ModalTestSms.route('erreur',this.result.html_message);
                    return; 
                }

                if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
                    ModalTestSms.route('erreur',this.result.erreur);
                    return; 
                }
        
                var message = `Envoi du SMS`;
        
                ModalTestSms.loading.setMessage(message);
        
                TestSms.setResult(this.result);
            };
        
            var data = {'numero': numero, 'message': message, 'config': config};
        
            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_template_sms');
            query.setAction("sendSms");
            query.setPostData( data );
            OdeAjax.getByAction( query, loading, callBack );
        }
    });
}

TestSms.setResult = function(result){
    ModalTestSms.route('message_test_sms');

    console.log(result);

    $('#message_test_sms').empty();

    let message = $('<p>');
    if(result.statut == 'ok')
    {
        $(message).addClass('success').append(result.message);
    }
    else
    {
        $(message).addClass('error').append(result.message);
    }

    $('#message_test_sms').append(message);
}

TestSms.setClickActionBtn = function(){
    $('[role="ode-modal-test_sms-btn"]').off().on('click', function () {
        ModalTestSms.loading.reset();
        ModalTestSms.open();
        ModalTestSms.route('form_test_sms');
        TestSms.initialisation();
    });
}

TestSms.setClickCloseBtn = function(){
    $('[role="ode-boutton-modal-close"]').off().on('click', function () {
        $.f_modal.close();
    });
}

$(document).ready(function() {
    
    ModalTestSms.initialisation( TestSms.modal_id );
    if ( ModalTestSms.loaded ) {
        TestSms.setClickActionBtn();
        TestSms.setClickCloseBtn();
    }
});
