<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

include_once 'custom/include/models/Autoloader.php';
require_once 'include/MassUpdate.php';
use ODE\Helper\OdeArrayHelper;
use ODE\Model\DossierModel;

class OPS_reunionController extends SugarController {

 //   $GLOBALS['log']->fatal(" action_addVersion :: data = ".print_r($data,true));

    /**
     * @access public
     * @name action_initFormulaireModifierReunion()
     * Fonction pour initialiser le formulaire de modification de reunion
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
    */
    public function action_initFormulaireModifierReunion() {

        $erreur = "";
        $data_verified =  $this->getDossiers( $_REQUEST );
        $resultat = $resultat_dossier = $reunions_all = $reunions = array();

        if ( $data_verified['statut'] == 'ok') {  

            do {
               
                // On récupere les dossiers
                $dossiers = $data_verified['data'];
                if ( !is_array( $dossiers ) || count( $dossiers ) === 0 ) {
                    $erreur = "Aucun dossier n'a été récupéré";
                    break;
                }
                
                // On récupere la liste des réunions
                $obj_reunion = new OPS_reunion();
                $liste_reunion = $obj_reunion->get_full_list();
                foreach ( $liste_reunion as $reun ) {
                    $date_now = new DateTime("now");
                    $date_reunion = new DateTime($reun->date_reunion);
                    $reunions_all[$reun->id] = $reun->name;
                    if ( $date_reunion > $date_now ) {
                        $reunions[$reun->id] = $reun->name;
                    }
                }

                // On vérifie qu'on a des réunions
                if ( !is_array( $reunions ) || count( $reunions ) === 0 ) {
                    $erreur = "Aucune réunion n'est disponible";
                    break;
                } else {
                    $resultat['reunions'] = $reunions;
                    uasort($resultat['reunions'], function ($a, $b) {
                        $pattern = '/(CD|CP)\s*-\s*(\d{2}\/\d{2}\/\d{4})$/';

                        preg_match($pattern, $a, $matchesA);
                        preg_match($pattern, $b, $matchesB);

                        $date_a = DateTime::createFromFormat('d/m/Y', $matchesA[2]);
                        $date_b = DateTime::createFromFormat('d/m/Y', $matchesB[2]);

                        $timestamp_a = $date_a->getTimestamp();
                        $timestamp_b = $date_b->getTimestamp();

                        if ($timestamp_a == $timestamp_b) {
                            return 0;
                        } elseif ($timestamp_a < $timestamp_b) {
                            return -1;
                        } else {
                            return 1;
                        }
                    });
                }
                // On parcours les dossiers 
                foreach ( $dossiers as $dossier_id ) {

                    do {

                        // On récupere le dossier 
                        $dossierModel = new DossierModel( $dossier_id );
                        $dossier = $dossierModel->getBean();
                        if ( !is_array($dossier) || count($dossier) === 0 ) {
                            $GLOBALS['log']->fatal(" OPS_reunionController :: action_initFormulaireModifierReunion => Dossier id = " . $dossier_id . " introuvable");
                            break;
                        }

                        // On récupere le numéro du dossier
                        $resultat_dossier[$dossier['id']]['dossier_num'] =  $dossier['num_dossier'];

                        // On récupere l'id de la réunion du dossier
                        $dossier_reunions = $dossierModel->getReunionIds();
                        $dossier_reunion_id = ( is_array($dossier_reunions) && count($dossier_reunions) > 0 ) ? $dossier_reunions[0] : "" ;
                        $dossier_reunion_name = ( array_key_exists( $dossier_reunion_id, $reunions_all) ) ? $reunions_all[$dossier_reunion_id] : "aucune réunion" ;
                        $resultat_dossier[$dossier['id']]['old_reunion'] =  $dossier_reunion_name;

                        // On vérifie si l'id de la réunion existe dans le resultat
                        if( empty($resultat['dossiers']) || array_key_exists ( $dossier_reunion_id ,  $resultat['dossiers'] ) === false ) {

                            $resultat['dossiers'][$dossier_reunion_id]['dossier_id'] = $dossier['id'];
                            $resultat['dossiers'][$dossier_reunion_id]['dossier_num'] = $dossier['num_dossier'];
                            $resultat['dossiers'][$dossier_reunion_id]['name'] = $dossier_reunion_name;

                        } else {
                            $resultat['dossiers'][$dossier_reunion_id]['dossier_id'] .= "|" . $dossier['id']; 
                            $resultat['dossiers'][$dossier_reunion_id]['dossier_num'] .= "," . $dossier['num_dossier']; 
                        }
                        $resultat['nb'] = count($dossiers);
                    } while (0);

                }

            } while (0);
  
        } else {
            $erreur = $data_verified['data'];
        }

        $data = ( empty($erreur) ) ? array( 'statut' => 'ok', 'data' =>  $resultat ) : array( 'statut' => 'err', 'data' => $erreur );
        
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
    
    /**
     * @access public
     * @name action_modifierReunion()
     * Fonction qui retourne le recap avant modification
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
    */
    public function action_modifierReunion() {

        $resultat = array();
        $dossiers = array();
        $erreur = "";
        $champs = array( "json" => true );

        $data_verified =  OdeArrayHelper::isDataValid( $_REQUEST, $champs );
        if ( $data_verified['statut'] == 'ok') {   
            
            $donnees = $data_verified['data']['json_array'];
            $donnees = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($donnees);

            do {
                
                // On récupere la liste des réunions
                $obj_reunion = new OPS_reunion();
                $liste_reunion = $obj_reunion->get_full_list();
                foreach ( $liste_reunion as $reun ) {
                    $reunions[$reun->id] = $reun->name;
                }


                // On vérifie qu'on a des réunions
                if ( !is_array( $reunions ) || count( $reunions ) === 0 ) {
                    $erreur = "Aucune réunion n'est disponible sur la plateforme";
                    break;
                }

                foreach ( $donnees->data as $data ) {
                    if( !empty( $data->dossiers ) ) {

                        $dossiers_ids = array();
                        // On récupere les ids des dossiers
                        if ( strpos($data->dossiers, "|") !== false ) {
                            $dossiers_ids = explode("|", $data->dossiers ); 
                        } else {
                            $dossiers_ids[] = $data->dossiers;
                        }

                        foreach ( $dossiers_ids as $dossier_id) {
                            if ( !empty( $data->reunion_id ) ) {
                                $dossiers[$dossier_id]['reunion'] = $data->reunion_id;
                            }
                        }
                    }
                }

                if ( is_array($dossiers) && count($dossiers) > 0 ) {
                    foreach ( $dossiers as $dossier_id => $donnees ) {
                        $resultat[$this->getDossierNum($dossier_id)] = $this->getRecapDossier( $reunions, $dossier_id, $donnees );
                        if ( $this->updateDossier($dossier_id, $donnees) === false) {
                            $resultat[$this->getDossierNum($dossier_id)] = "erreur";
                        }
                    }
                } 


            } while (0);


        } else {
            $erreur = $data_verified['data'];
        }

        $data = ( empty($erreur) ) ? array( 'statut' => 'ok', 'data' => $resultat ) : array( 'statut' => 'err', 'data' => $erreur);
        
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name action_getRecapModificationReunion()
     * Fonction qui retourne le recap avant modification
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
    */
    public function action_getRecapModificationReunion() {

        $resultat = array();
        $dossiers = array();
        $erreur = "";
        $champs = array( "json" => true );

        $data_verified =  OdeArrayHelper::isDataValid( $_REQUEST, $champs );
        if ( $data_verified['statut'] == 'ok') {   

            $donnees = $data_verified['data']['json_array'];
            $donnees = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($donnees);

            do {
                
                // On récupere la liste des réunions
                $obj_reunion = new OPS_reunion();
                $liste_reunion = $obj_reunion->get_full_list();
                foreach ( $liste_reunion as $reun ) {
                    $reunions[$reun->id] = $reun->name;
                }


                // On vérifie qu'on a des réunions
                if ( !is_array( $reunions ) || count( $reunions ) === 0 ) {
                    $erreur = "Aucune réunion n'est disponible sur la plateforme";
                    break;
                }


                foreach ( $donnees->data as $data ) 
                {
                    if( !empty( $data->dossiers ) ) {

                        $dossiers_ids = array();
                        // On récupere les ids des dossiers
                        if ( strpos($data->dossiers, "|") !== false ) {
                            $dossiers_ids = explode("|", $data->dossiers ); 
                        } else {
                            $dossiers_ids[] = $data->dossiers;
                        }

                        foreach ( $dossiers_ids as $dossier_id) {
                            if ( !empty( $data->reunion_id ) ) {
                                $dossiers[$dossier_id]['reunion'] = $data->reunion_id;
                            }
                        }
                    }
                }

                $data = $donnes;
                if ( is_array($dossiers) && count($dossiers) > 0 ) {
                    foreach ( $dossiers as $dossier_id => $donnees ) {
                        $count = 0;
                        $count = $count + 1;
                        $resultat[$this->getDossierNum($dossier_id)] = $this->getRecapDossier( $reunions, $dossier_id, $donnees );
                    }
                } 
            } while (0);


        } else {
            $erreur = $data_verified['data'];
        }

        $data = ( empty($erreur) ) ? array( 'statut' => 'ok', 'data' => $resultat ) : array( 'statut' => 'err', 'data' => $erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    private function getDossierNum( $dossier_id ) {

        $dossierModel = new DossierModel( $dossier_id );
        $dossier = $dossierModel->getBean();
        return ( is_array($dossier) && count($dossier) > 0 && !empty($dossier["num_dossier"]) ) ? $dossier["num_dossier"] : "" ;

    }

    private function getRecapDossier( $reunions, $dossier_id, $donnees ) {

        $recap_dossier = array(
            "old_reunion" => "",
            "new_reunion" => "",
        );

        $dossierModel = new DossierModel( $dossier_id );
        $dossier = $dossierModel->getBean();

        // On récupere l'id de la réunion du dossier
        $dossier_reunions = $dossierModel->getReunionIds();
        $dossier_reunion_id = ( is_array($dossier_reunions) && count($dossier_reunions) > 0 ) ? $dossier_reunions[0] : "" ;
        $recap_dossier['old_reunion'] = ( array_key_exists( $dossier_reunion_id, $reunions) ) ? $reunions[$dossier_reunion_id] : "aucune réunion" ;

        // On récupere le nom de la nouvelle réunion
        $recap_dossier['new_reunion'] = ( !empty($donnees['reunion']) && array_key_exists( $donnees['reunion'], $reunions) ) ? $reunions[$donnees['reunion']] : "aucune réunion" ;

        return $recap_dossier ;
        
    }

    private function updateDossier( $dossier_id, $donnees ) {

        $updated = false;
        $obj_dossier = BeanFactory::getBean( 'OPS_dossier', $dossier_id );
        if( !empty($obj_dossier->id) ){ 
            if ( !empty($donnees['reunion']) ) {
                $reunions = $obj_dossier->get_linked_beans( "ops_reunion_ops_dossier" , "OPS_reunion" );
                if( is_array($reunions) && count($reunions) > 0 ){
                    foreach ( $reunions as $reunion ) {
                        $obj_dossier->load_relationship( "ops_reunion_ops_dossier" );
                        $obj_dossier->ops_reunion_ops_dossier->delete( $obj_dossier->id, $reunion);
                    }
                } 
                $obj_dossier->load_relationship("ops_reunion_ops_dossier");
                $obj_dossier->ops_reunion_ops_dossier->add($donnees['reunion']);
                $updated = true;
            }
        }
        return $updated ;
        
    }
    

    /**
     * @access public
     * @name getDossiers()
     * Fonction pour retourne les ids des dossiers séléctionnés 
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return array                           $data : array avec un statut ( ok/err ) + les données ou le libellé de l'erreur
    */
    private function getDossiers($request)
    {
        global $db;
        $libelle_erreur = '';
        $dossiers = [];
        do {
            $data_verified = OdeArrayHelper::isDataValid($request, ["json" => true]);
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }

            $data = $data_verified["data"]["json_array"];

            if (!empty($data['dossiers']) && is_array($data['dossiers']) && count($data['dossiers']) > 0) {
                $dossiers = $data['dossiers'];
                break;
            }
            if (!empty($data['filtres'])) {
                $json = htmlentities(json_encode($data['filtres']), ENT_QUOTES, 'UTF-8');
                // Ce traitement est utilisé dans le cas ou l'utilisateur sélectionne l'intégralité des dossiers + filtres
                $mass = new MassUpdate();
                $mass->generateSearchWhere('OPS_dossier', $json);
                $where_clause = $mass->where_clauses;
                $obj_dossier = new OPS_dossier();
                $query = $obj_dossier->create_export_query("", $where_clause);
                $queryExplode = explode('FROM',$query);
                $queryExplode[0] = 'SELECT ops_dossier.id';
                $query = implode(' FROM', $queryExplode);
                $query = OPS_dossier::cleanQueryActionLot($query,array('ops_sous_territoire','ops_dossier','ops_elu'));
                $result = $db->query($query);
                while ($dossier = $db->fetchByAssoc($result)) {
                    $dossiers[] = $dossier['id'];
                }
            }

            // Je ne vérifie pas si $request['selectAll'] est non vide, empty($request['selectAll']) retourne true quand $request['selectAll']=0
            if (!is_array($dossiers) || count($dossiers) === 0) {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }
        } while (0);

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $dossiers) : array('statut' => 'err', 'data' => $libelle_erreur);

        return $data;
    }
}