<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;

class OPS_justificatifController extends SugarController
{

	function action_modifier_statut(){
		global $app_list_strings;
		if(!empty($_REQUEST['array_champs'])){
			
			$justificatifObj = BeanFactory::getBean('OPS_justificatif',$_REQUEST['array_champs']['statut_id']);
			$justificatifObj->statut = $_REQUEST['array_champs']['statut_name'];
			$justificatifObj->description = $_REQUEST['array_champs']['description'];
			$justificatifObj->obligatoire = $_REQUEST['array_champs']['obligatoire'];
			$justificatifObj->save();

			if($justificatifObj->ops_dossier_id && $justificatifObj->statut == 'valide'){
				$dossierObj = BeanFactory::getBean('OPS_dossier',$justificatifObj->ops_dossier_id);
				$justificatifRejete = $dossierObj->get_linked_beans(
				                'ops_dossier_ops_justificatif',
				                'OPS_justificatif',
				                '',
				                0,
				                -1,
				                0,
				                "statut='rejete'");

				if(empty($justificatifRejete)){
					$dossierObj->justificatif_incomplet = 0;
					$dossierObj->save();
				}
			}elseif($justificatifObj->ops_dossier_id && $justificatifObj->statut == 'rejete'){
				$dossierObj = BeanFactory::getBean('OPS_dossier',$justificatifObj->ops_dossier_id);
				$dossierObj->justificatif_incomplet = 1;
				$dossierObj->save();
			}

			if($justificatifObj->ops_dossier_id)
			{
				$dossierObj = BeanFactory::getBean('OPS_dossier',$justificatifObj->ops_dossier_id);

				$justificatifEtude = $dossierObj->get_linked_beans(
					                'ops_dossier_ops_justificatif',
					                'OPS_justificatif',
					                '',
					                0,
					                -1,
					                0,
					                "statut='etude'"
					            );

				$dossierObj->flag_justificatif_etude = ((empty($justificatifEtude)) ? 0 : 1);

				$justificatifReetude = $dossierObj->get_linked_beans(
					                'ops_dossier_ops_justificatif',
					                'OPS_justificatif',
					                '',
					                0,
					                -1,
					                0,
					                "statut='reetude'"
					            );

				$dossierObj->flag_justificatif_reetude = ((empty($justificatifReetude)) ? 0 : 1);

				$dossierObj->save();
			}


			$data = array(
				'statut_id' => $justificatifObj->id,
				'statut_color' => $justificatifObj->get_color_modal($justificatifObj->statut),
				'statut_name' => $app_list_strings['ops_statut_j_list'][$justificatifObj->statut],
				'description' => base64_encode($_REQUEST['array_champs']['description']),
				'obligatoire' => $_REQUEST['array_champs']['obligatoire'],
			);
		}else{
			return;
		}
		ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
	}

	function action_envoyer_mail(){

		global $sugar_config;

		$data = array();

		if(!empty($_REQUEST['array_champs'])){

			$bean = BeanFactory::getBean($_REQUEST['array_champs']['justificatif_name'],$_REQUEST['array_champs']['justificatif_id']);

			if($_REQUEST['array_champs']['justificatif_name'] == 'OPS_dossier'){
				$bean->load_relationship('ops_individu_ops_dossier');
				$individu_id = $bean->ops_individu_ops_dossier->get();
				$individu = BeanFactory::getBean('OPS_individu',$individu_id[0]);
				$destinataire = $individu;
			}else{
				$destinataire = $bean;
			}

			if(!empty($destinataire->email1)){

				if($_REQUEST['array_champs']['justificatif_name'] == "OPS_personne_morale"){
					if($_REQUEST['array_champs']['template_id'] == "nouveau"){
						$template = $sugar_config['opensocle']['notif_usager_justificatif_profil_nouveau'];
					}else if($_REQUEST['array_champs']['template_id'] == "rejet"){
						$template = $sugar_config['opensocle']['notif_usager_justificatif_profil_rejet'];
					}
				}elseif ($_REQUEST['array_champs']['justificatif_name'] == "OPS_dossier") {
					if($_REQUEST['array_champs']['template_id'] == "nouveau"){
						$template = $sugar_config['opensocle']['notif_usager_justificatif_dossier_nouveau'];
					}else if($_REQUEST['array_champs']['template_id'] == "rejet"){
						$template = $sugar_config['opensocle']['notif_usager_justificatif_dossier_rejet'];
					}
				}

				# On initialise le mailer 
				$mailer = new OdeMailer();

				# On initialise l'email 
				$ode_email = new OdeEmail([
					'bean_source_id' => $bean->id,
					'bean_source_name' => $_REQUEST['array_champs']['justificatif_name'],
					'bean_historisation_id' => $destinataire->id,
					'bean_historisation_name' => $destinataire->object_name,
					'email_template_id' => $template,
					'dest_to' => $destinataire->email1,
				]);
	
				# On déclenche l'envoie
				$retour = $mailer->send($ode_email);

			}else{
				$data['destinataire'] = 'invalid';
				if($_REQUEST['array_champs']['justificatif_name'] == 'OPS_dossier'){
					$data['message'] = 'L\'adresse mail du demandeur n\'est pas renseignée';
				}else{
					$data['message'] = 'L\'adresse mail du responsable du profil n\'est pas renseignée';
				}
			}
		}else{
			return;
		}
		$data['mail'] = ($retour)?'valid':'invalid';

		ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
	}

	public function action_supprimer_justificatif(){

		$data = [];
		$data['valid'] = true;

		if($_REQUEST['array_champs']['module_name'] == 'OPS_dossier'){
			$data['relationship'] = 'ops_dossier_ops_justificatif';
		}else{
			$data['relationship'] = 'ops_personne_morale_ops_justificatif';
		}

		$justificatifObj = BeanFactory::getBean('OPS_justificatif',$_REQUEST['array_champs']['justificatif_id']);

		if(!empty($justificatifObj)){
			$justificatifObj->mark_deleted($justificatifObj->id);
			$justificatifObj->save();
		}

		if($justificatifObj->deleted == 0){
			$data['valid'] = false;
		}

		ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
	}
}
