<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.detail.php');
require_once('modules/ACLActions/ACLAction.php');
require_once("modules/SecurityGroups/SecurityGroup.php");

use ODE\Modal\OdeModal;

class OPS_individuViewDetail extends ViewDetail {


    public function __construct(){
        parent::__construct();
    }

    function display(){
        
        global $app_strings, $app_list_strings, $current_user;

        echo '<link href="custom/include/libs/fontawesome/css/all.min.css" rel="stylesheet">';
        echo '<link href="custom/include/css/spinner.css" rel="stylesheet">';

        if(empty($this->bean->id)){
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }

        $configuratorObj = new Configurator();

        $bouton_calendar = '';
        if($current_user->isAdmin() || (isset($_SESSION['habilitation_individu']['individu_calendrier']) && $_SESSION['habilitation_individu']['individu_calendrier'] == 1) )
        {
            $bouton_calendar = '<input title="Calendrier" accesskey="i" class="button primary" onclick="var _form = document.getElementById(\'formDetailView\'); _form.return_module.value=\'' . $this->bean->module_name .'\'; _form.return_action.value=\'DetailView\'; _form.return_id.value=\'' . $this->bean->id .'\'; _form.action.value=\'CalendarView\';SUGAR.ajaxUI.submitForm(_form);" type="button" name="Calendar" id="calendar_button" value="Calendrier">';
        }
        $this->ss->assign("bouton_calendar", $bouton_calendar);

        $bouton_delete = $this->get_bouton_delete();

        $this->ss->assign("bouton_delete", $bouton_delete);
        $this->ss->assign("first_name", ucfirst(strtolower($this->bean->first_name)));
        
        if($this->bean->type_individu == 'enfant')
        {
            $this->ss->assign("situation_familiale", $app_list_strings['ops_sexe_list'][$this->bean->sexe]);
        }
        else
        {
            $this->ss->assign("situation_familiale", $app_list_strings['ops_situation_familiale_list'][$this->bean->situation_familiale]);
        }

        if($current_user->isAdmin())
        {
            $habilitation_individu = base64_encode(json_encode(['admin' => true]));
        }
        else
        {
            $habilitation_individu = (!empty($_SESSION['habilitation_individu'])) ? base64_encode(json_encode($_SESSION['habilitation_individu'])) : '';
        }
        
        $this->ss->assign("habilitation_individu", $habilitation_individu);

        $this->ss->assign("type_individu", $app_list_strings['ops_type_individu_list'][$this->bean->type_individu]);

        $this->dv->process();

        parent::display();
    }

    function get_bouton_delete(){

        global $current_user;
        $owner = $this->bean->assigned_user_id == $current_user->id;
        $hasAccess = ACLAction::userHasAccess($current_user->id, $this->module, "delete", "module", $owner);

        if(!$hasAccess) return "";
        
        $dossier = $this->bean->get_linked_beans('ops_individu_ops_dossier','OPS_dossier');
        $bouton = '';
        if(empty($dossier)){
            $bouton .= '<input title="Supprimer" accesskey="d" class="button" onclick="var _form = document.getElementById(\'formDetailView\'); _form.return_module.value=\'OPS_individu\'; _form.return_action.value=\'ListView\'; _form.action.value=\'Delete\'; if(confirm(\'Voulez-vous vraiment supprimer cet enregistrement ?\')) SUGAR.ajaxUI.submitForm(_form); return false;" type="submit" name="Delete" value="Supprimer" id="delete_button">';
        }else{
            $modal = new OdeModal('ode_modal_delete');
            $modal->setTitle("SUPPRESSION D'UN INDIVIDU");
            $modal->setCss(['modules/OPS_individu/css/delete.css']);
            $modal->setJS(['modules/OPS_individu/javascript/delete.js']);
            $modal->setPages(['modules/OPS_individu/tpl/delete.tpl']);
            $bouton = $modal->getHtml();
            $bouton .= '<input title="Supprimer" accesskey="d" class="button" type="button" name="Delete" value="Supprimer" id="delete_button" role="ode-modal-delete-btn">';
        }
        return $bouton;
    }
}

